/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.jetty.RewritePatternRuleWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;

public class RewriteHandlerObserver {
    private RewriteHandler rewriteHandler;

    public RewriteHandlerObserver(RewriteHandler rewriteHandler) {
        this.rewriteHandler = rewriteHandler;
    }

    public void onApplicationDeployed(String appContextPath) {
        Trace.logInfo("Adding rewrite rules for application {}", appContextPath);
        Stream rules = this.rewriteHandler.getRules() != null ? Arrays.stream(this.rewriteHandler.getRules()).filter(r -> !((RewritePatternRuleWrapper)((Object)r)).getAppContextPath().equals(appContextPath)) : Stream.empty();
        this.rewriteHandler.setRules((Rule[])Stream.concat(rules, this.createRules(appContextPath).stream()).toArray(Rule[]::new));
    }

    public void onApplicationDestroyed(String appName) {
        Trace.logInfo("Removing rewrite rules for application {}", appName);
        if (this.rewriteHandler.getRules() != null) {
            this.rewriteHandler.setRules((Rule[])Arrays.stream(this.rewriteHandler.getRules()).filter(r -> !((RewritePatternRuleWrapper)((Object)r)).getAppContextPath().equals(appName)).toArray(Rule[]::new));
        }
    }

    private List<RewritePatternRuleWrapper> createRules(String appContextPath) {
        ArrayList<RewritePatternRuleWrapper> rules = new ArrayList<RewritePatternRuleWrapper>();
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/fabric"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/fabric"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/dropbox"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/dropbox"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/exchange"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/exchange"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/repository"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/repository"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/sor"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/sor"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/sorquilt"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/sorquilt"));
        if (!appContextPath.equals("/sor")) {
            rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/service"));
            rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/service"));
            rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/ds"));
            rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/ds"));
        }
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/odata/v4"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/odata/v4"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/security"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/security"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/swagger/v2"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/swagger/v2"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/chart"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/chart"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, "/public", "/"));
        rules.add(RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, "/public", "/"));
        return rules;
    }

    public static RewritePatternRuleWrapper createRewritePatternRuleWrapper(String appContextPath, String path) {
        return RewriteHandlerObserver.createRewritePatternRuleWrapper(appContextPath, path, path);
    }

    public static RewritePatternRuleWrapper createRewritePatternRuleWrapper(String appContextPath, String path, String replacement) {
        RewritePatternRuleWrapper rule = new RewritePatternRuleWrapper(appContextPath);
        rule.setPattern(appContextPath + path);
        rule.setReplacement(replacement);
        return rule;
    }

    public static RewritePatternRuleWrapper createRewritePatternRuleWrapperWildcard(String appContextPath, String path) {
        return RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard(appContextPath, path, path);
    }

    public static RewritePatternRuleWrapper createRewritePatternRuleWrapperWildcard(String appContextPath, String path, String replacement) {
        RewritePatternRuleWrapper rule = new RewritePatternRuleWrapper(appContextPath);
        rule.setPattern(appContextPath + path + "/*");
        rule.setReplacement(replacement);
        return rule;
    }
}

