/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty;

import com.streamscape.Trace;
import com.streamscape.ds.lib.StringComparator;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.jetty.RewriteHandlerObserver;
import com.streamscape.sef.network.http.server.jetty.WarDeployer;
import com.streamscape.sef.network.http.server.jetty.sysint.SysInitScriptExecutorException;
import com.streamscape.sef.network.http.server.jetty.sysint.SysInitScriptsExecutor;
import com.streamscape.sef.network.http.server.jetty.sysint.SysInitScriptsExecutorException;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.tools.parser.ParserPositionalException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.PropertiesConfigurationManager;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlParser;

public class JettyWarDeployer
extends AbstractLifeCycle
implements WarDeployer {
    private static final String DEPLOY_ARCH_EXT = ".war";
    private HTTPAcceptor acceptor;
    private DeploymentManager deploymentManager;
    private WebAppProvider webappProvider;
    private boolean deployed = false;
    private RewriteHandlerObserver rewriteHandlerObserver;

    public JettyWarDeployer(HTTPAcceptor acceptor, DeploymentManager deploymentManager) {
        this.acceptor = acceptor;
        this.deploymentManager = deploymentManager;
    }

    protected void doStart() throws Exception {
        this.deployAll();
        this.webappProvider = new WebAppProvider(){

            protected void doStart() throws Exception {
                super.doStart();
            }

            public ContextHandler createContextHandler(App app) throws Exception {
                ContextHandler handler = super.createContextHandler(app);
                if (handler instanceof WebAppContext) {
                    final WebAppContext context = (WebAppContext)handler;
                    context.addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

                        public void lifeCycleStarted(LifeCycle event) {
                            Object contextPath = context.getDisplayName();
                            if (contextPath != null) {
                                if (!((String)contextPath).startsWith("/")) {
                                    contextPath = "/" + (String)contextPath;
                                }
                                context.setContextPath((String)contextPath);
                            }
                            if (context.getServletHandler() != null && context.getServletHandler().getServlets() != null) {
                                for (ServletHolder holder : context.getServletHandler().getServlets()) {
                                    String aliasesName = holder.getName() + ".servlet.init-param.aliases";
                                    String aliasesValue = holder.getInitParameter("aliases");
                                    if (aliasesValue == null || !aliasesValue.equalsIgnoreCase("true")) continue;
                                    context.addAliasCheck((path, resource) -> true);
                                }
                            }
                            JettyWarDeployer.this.rewriteHandlerObserver.onApplicationDeployed(context.getContextPath());
                        }
                    });
                }
                return handler;
            }
        };
        this.webappProvider.setMonitoredDirName(this.acceptor.getWebApplicationDir());
        this.webappProvider.setScanInterval(0);
        this.webappProvider.setExtractWars(false);
        this.webappProvider.setConfigurationManager((ConfigurationManager)new PropertiesConfigurationManager());
        this.deploymentManager.addAppProvider((AppProvider)this.webappProvider);
    }

    protected void doStop() throws Exception {
        this.deploymentManager.removeAppProvider((AppProvider)this.webappProvider);
    }

    @Override
    public void deployAll() {
        if (this.deployed) {
            return;
        }
        if (!this.assureDir(this.getWarDir())) {
            this.logError("War location " + String.valueOf(this.getWarDeployDir()) + " isn't a directory, deployment is impossible.");
            return;
        }
        if (!this.assureDir(this.getWarDeployDir())) {
            this.logError("Target deployment location " + String.valueOf(this.getWarDeployDir()) + " isn't a directory, deployment is impossible.");
            return;
        }
        List<String> wars = this.listWars();
        for (String war : wars) {
            File warDeployDir;
            Boolean deployOnStart = JettyAdvancedProperties.build(this.acceptor.getConfiguration()).getBooleanProperty("jetstream.war.redeploy.on.start");
            if (war.equals("swaggerui")) {
                deployOnStart = true;
            }
            if (!deployOnStart.booleanValue() && !(deployOnStart = Boolean.valueOf(!(warDeployDir = this.getWarDeployDir(war)).exists() || !warDeployDir.isDirectory())).booleanValue()) {
                this.logInfo("Doesn't deploy application '{}' on start because '{}' is disabled and application directory already exists.", war, "jetstream.war.redeploy.on.start");
            }
            try {
                if (!deployOnStart.booleanValue()) continue;
                this.deployWarInternal(war);
                this.executeSysInitScripts(war);
            }
            catch (IOException exception) {
                Trace.logError(this, "Failed to deploy war '" + war + "'", exception);
            }
        }
        this.deployed = true;
    }

    @Override
    public List<SysInitScriptsExecutorException> deployWar(String warName) throws IOException {
        this.logInfo("Deploying war '" + warName + "'...", new Object[0]);
        this.detachWebApp(warName);
        this.deployWarInternal(warName);
        List<SysInitScriptsExecutorException> exceptions = this.executeSysInitScripts(warName);
        this.attachWebApp(warName);
        this.logInfo("War '" + warName + "' deployed.", new Object[0]);
        return exceptions;
    }

    @Override
    public synchronized void undeployWar(String warName) throws IOException {
        this.logInfo("Undeploying war '" + warName + "'...", new Object[0]);
        this.detachWebApp(warName);
        FileIOUtils.deleteFileDir(this.getWarDeployDir(warName), false);
        if (this.getWarDeployDir(warName).exists()) {
            throw new IOException("Failed to remove applicaiton dir '" + this.getWarDeployDir(warName).getName() + "'.");
        }
        this.logInfo("War '" + warName + "' undeployed.", new Object[0]);
    }

    @Override
    public synchronized void removeWar(String warName) throws IOException {
        this.logInfo("Removing war '" + warName + "'...", new Object[0]);
        this.undeployWar(warName);
        this.getWarFile(warName).delete();
        if (this.getWarFile(warName).exists()) {
            throw new IOException("Failed to remove war file '" + this.getWarFile(warName).getName() + "'.");
        }
        this.logInfo("War '" + warName + "' removed.", new Object[0]);
    }

    @Override
    public synchronized File createWar(String warFullName) throws IOException {
        if (warFullName == null || !warFullName.endsWith(DEPLOY_ARCH_EXT)) {
            throw new IOException("Invalid war name. Should ends with .war");
        }
        if (warFullName.length() == DEPLOY_ARCH_EXT.length()) {
            throw new IOException("War name is empty");
        }
        String warName = warFullName.substring(0, warFullName.length() - DEPLOY_ARCH_EXT.length()).trim();
        if (this.listWars().contains(warName)) {
            throw new IOException("War file '" + warFullName + "' already exists, remove it first.");
        }
        if (this.listDeployedWars().contains(warName)) {
            throw new IOException("Application '" + warFullName + "' already deployed, undeploy it first.");
        }
        File warFile = this.getWarFile(warName);
        warFile.createNewFile();
        return warFile;
    }

    @Override
    public synchronized void createWar(String warFullName, byte[] content) throws IOException {
        this.createWar(warFullName, new ByteArrayInputStream(content));
    }

    @Override
    public synchronized void createWar(String warFullName, InputStream inputStream) throws IOException {
        this.logInfo("Creating war '" + warFullName + "'...", new Object[0]);
        File warFile = this.createWar(warFullName);
        this.copyStream(inputStream, new FileOutputStream(warFile));
        this.logInfo("War '" + warFullName + "' created.", new Object[0]);
    }

    @Override
    public List<String> listWars() {
        ArrayList<String> wars = new ArrayList<String>();
        this.getWarDir().listFiles(pathname -> {
            if (pathname.isFile() && pathname.getName().toLowerCase().endsWith(DEPLOY_ARCH_EXT)) {
                wars.add(pathname.getName().substring(0, pathname.getName().length() - DEPLOY_ARCH_EXT.length()));
                return true;
            }
            return false;
        });
        return wars;
    }

    @Override
    public synchronized List<String> listDeployedWars() {
        ArrayList<String> deployedWars = new ArrayList<String>();
        this.getWarDeployDir().listFiles(pathname -> {
            if (pathname.isDirectory()) {
                deployedWars.add(pathname.getName());
            }
            return true;
        });
        return deployedWars;
    }

    @Override
    public synchronized List<WarDeployer.WarInfo> listWarInfos() {
        List<String> wars = this.listWars();
        List<String> deployedWars = this.listDeployedWars();
        ArrayList<WarDeployer.WarInfo> infos = new ArrayList<WarDeployer.WarInfo>();
        for (App app : this.deploymentManager.getApps()) {
            try {
                ContextHandler context = app.getContextHandler();
                if (context == null) continue;
                String warName = context.getBaseResource().getFile().getName();
                String warDeployName = context.getBaseResource().getFile().getName();
                if (!deployedWars.remove(warName)) {
                    warDeployName = null;
                }
                if (!wars.remove(warName)) {
                    warName = null;
                }
                WarDeployer.WarInfo info = new WarDeployer.WarInfo(warName);
                info.setUrl(context.getContextPath());
                info.setWebAppDirectory(warDeployName);
                info.setWelcomeFiles(context.getWelcomeFiles());
                info.setDescription("[not specified]");
                if (context instanceof WebAppContext) {
                    WebAppContext webAppContext = (WebAppContext)app.getContextHandler();
                    if (webAppContext.getMetaData() != null) {
                        if (webAppContext.getMetaData().getWebXml() != null) {
                            if (webAppContext.getMetaData().getWebXml().getRoot() != null) {
                                XmlParser.Node node = webAppContext.getMetaData().getWebXml().getRoot().get("description");
                                if (node != null) {
                                    info.setDescription(node.toString(false, true));
                                }
                            } else {
                                info.setDescription("[invalid web.xml]");
                            }
                        } else {
                            info.setDescription("[missing web.xml]");
                        }
                    } else {
                        info.setDescription("[missing metadata]");
                    }
                }
                infos.add(info);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
        for (String deployedWar : deployedWars) {
            String warName = deployedWar;
            if (!wars.remove(warName)) {
                warName = null;
            }
            WarDeployer.WarInfo info = new WarDeployer.WarInfo(warName);
            info.setUrl(null);
            info.setWebAppDirectory(deployedWar);
            infos.add(info);
        }
        for (String warName : wars) {
            WarDeployer.WarInfo info = new WarDeployer.WarInfo(warName);
            info.setUrl(null);
            info.setWebAppDirectory(null);
            infos.add(info);
        }
        infos.sort((i1, i2) -> new StringComparator().compare(i1.getWarName(), i2.getWarName()));
        return infos;
    }

    private void deployWarInternal(String warName) throws IOException {
        this.logInfo("Copying war '" + warName + "' to webapps directory and extracting...", new Object[0]);
        ZipFile warZipFile = null;
        File warFile = this.getWarFile(warName);
        File deployDir = this.getWarDeployDir(warName);
        if (this.isAliased(deployDir)) {
            this.logInfo("Webapp directory '" + String.valueOf(deployDir) + "' is alias, don't deploy application '" + warName + "'.", new Object[0]);
            return;
        }
        try {
            if (!this.assureDir(deployDir)) {
                throw new IOException("Can't reach deployment dir " + String.valueOf(deployDir));
            }
            warZipFile = new ZipFile(warFile);
            Enumeration<? extends ZipEntry> entries = warZipFile.entries();
            while (entries.hasMoreElements()) {
                File outFile;
                ZipEntry warZipEntry = entries.nextElement();
                String warZipEntryName = warZipEntry.getName();
                if (File.separatorChar == '/') {
                    warZipEntryName = warZipEntryName.replace('\\', File.separatorChar);
                }
                if (this.isAliased(outFile = new File(deployDir, warZipEntryName))) continue;
                if (warZipEntry.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                FileOutputStream os = null;
                InputStream is = null;
                File parentFile = outFile.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                if (outFile.exists() && outFile.lastModified() >= warZipEntry.getTime()) continue;
                try {
                    os = new FileOutputStream(outFile);
                    is = warZipFile.getInputStream(warZipEntry);
                    this.copyStream(is, os);
                    outFile.setLastModified(warZipEntry.getTime());
                }
                catch (IOException exception) {
                    this.logError("Problem in extracting " + warZipEntryName + ".", exception);
                    throw exception;
                }
                finally {
                    try {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (is == null) continue;
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (ZipException exception) {
            this.logError("Invalid .war format.", exception);
            throw new IOException(exception.getMessage());
        }
        catch (IOException exception) {
            this.logError("Can't read " + String.valueOf(warFile) + ".", exception);
            throw exception;
        }
        finally {
            try {
                if (warZipFile != null) {
                    warZipFile.close();
                }
            }
            catch (Exception exception) {}
        }
        this.copyExtSysUsr(warName);
        this.logInfo("War '" + warName + "' copied and extracted.", new Object[0]);
    }

    private boolean isAliased(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    private void attachWebApp(String warName) throws IOException {
        try {
            this.logInfo("Starting webapp '" + warName + "'...", new Object[0]);
            App app = new App(this.deploymentManager, (AppProvider)this.webappProvider, this.getWarDeployDir(warName).getCanonicalPath());
            this.deploymentManager.addApp(app);
            this.deploymentManager.requestAppGoal(app.getOriginId(), "started");
            this.logInfo("Webapp '" + warName + "' started.", new Object[0]);
        }
        catch (Exception exception) {
            this.logError("Starting of a web app " + warName + " failed.", exception);
            throw new IOException(exception.getMessage());
        }
    }

    private void detachWebApp(String warName) throws IOException {
        this.logInfo("Stopping webapp '" + warName + "'...", new Object[0]);
        App app = this.deploymentManager.getAppByOriginId(this.getWarDeployDir(warName).getCanonicalPath());
        if (app != null) {
            this.deploymentManager.requestAppGoal(app, "undeployed");
            this.deploymentManager.removeApp(app);
            this.rewriteHandlerObserver.onApplicationDestroyed(app.getContextPath());
            this.logInfo("Webapp '" + warName + "' stopped.", new Object[0]);
        } else {
            this.logInfo("Webapp '" + warName + "' not started.", new Object[0]);
        }
    }

    private File getWarDir() {
        return new File(this.acceptor.getWebArchiveDir());
    }

    private File getWarFile(String warName) {
        return new File(this.getWarDir(), warName + DEPLOY_ARCH_EXT);
    }

    private File getWarDeployDir() {
        return new File(this.acceptor.getWebApplicationDir());
    }

    private File getWarDeployDir(String warName) {
        return new File(this.getWarDeployDir(), warName);
    }

    private boolean assureDir(File fileDir) {
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        return fileDir.isDirectory();
    }

    private void copyStream(InputStream is, OutputStream os) throws IOException {
        HTTPUtils.copyStream(is, os);
    }

    private List<SysInitScriptsExecutorException> executeSysInitScripts(String warName) {
        String sysinitPath = "/sysinit/";
        boolean interruptScriptOnFail = false;
        boolean interruptExecutionOnFail = false;
        List<Object> exceptions = new ArrayList();
        this.logInfo("Web application '{}' executing scripts from path {}, interruptScriptOnFail: {}, interruptExecutionOnFail: {}", warName, sysinitPath, interruptScriptOnFail, interruptExecutionOnFail);
        String sysinitAbsolutePath = this.getWarDeployDir(warName).getAbsolutePath() + sysinitPath;
        SysInitScriptsExecutor executor = new SysInitScriptsExecutor(sysinitAbsolutePath, warName);
        executor.setInterruptScriptOnFail(interruptScriptOnFail);
        executor.setInterruptExecutorOnFail(interruptExecutionOnFail);
        try {
            exceptions = executor.execute();
        }
        catch (SysInitScriptsExecutorException exception) {
            exceptions.add(exception);
        }
        if (exceptions.size() > 0) {
            Trace.logError(this, "Web application '{}' initialization failed: ", warName);
            for (SysInitScriptsExecutorException sysInitScriptsExecutorException : exceptions) {
                StringBuilder builder = new StringBuilder();
                builder.append('\n').append("Resource ").append(sysInitScriptsExecutorException.getResourceName());
                Throwable cause = sysInitScriptsExecutorException.getCause();
                if (cause instanceof SysInitScriptExecutorException) {
                    builder.append("\nin statement(line ").append(((ParserPositionalException)((Object)cause)).getLineNumber()).append(")");
                    builder.append("\n").append(((ParserPositionalException)((Object)cause)).getLine());
                    if (cause.getCause() instanceof ParserPositionalException) {
                        if (((ParserPositionalException)((Object)cause.getCause())).getLineNumber() > 0) {
                            builder.append("\n  in line number ").append(((ParserPositionalException)((Object)cause.getCause())).getLineNumber());
                            builder.append("\n   ").append(((ParserPositionalException)((Object)cause.getCause())).getLine());
                            builder.append("\n   ");
                            for (int i = 0; i < ((ParserPositionalException)((Object)cause.getCause())).getPositionInLine() - 1; ++i) {
                                builder.append(" ");
                            }
                            builder.append("^");
                        }
                        builder.append("\n   cause: ").append(((ParserPositionalException)((Object)cause.getCause())).getErrorMessage());
                    } else {
                        builder.append("\n cause: ").append(cause.getCause() != null ? cause.getCause().getMessage() : null);
                        Trace.logException(this, cause.getCause(), true);
                    }
                } else {
                    builder.append("\n cause: ").append(cause.getMessage());
                    Trace.logException(this, cause, true);
                }
                Trace.logError(this, builder.toString());
            }
        }
        return exceptions;
    }

    private void copyExtSysUsr(String warName) {
        this.copyExtSysUsr(warName, "/ext/sys");
        this.copyExtSysUsr(warName, "/ext/usr");
    }

    private void copyExtSysUsr(String warName, String path) {
        File sourcePath = new File(this.getWarDeployDir(warName), path);
        if (sourcePath.exists()) {
            File targetPath = new File(this.acceptor.getHtmlDir(), path);
            try {
                FileIOUtils.copyFileDir(sourcePath, targetPath);
            }
            catch (UtilitiesException exception) {
                Trace.logError(this, "Failed to copy '" + String.valueOf(sourcePath) + "' to '" + String.valueOf(targetPath) + "'.");
                Trace.logException(this, exception, true);
            }
        }
    }

    private void logInfo(String message, Object ... args) {
        Trace.logInfo(this, message, args);
    }

    private void logError(String message, Exception exception) {
        Trace.logError(this, message);
        if (exception != null) {
            Trace.logException(this, exception, true);
        }
    }

    private void logError(String message) {
        this.logError(message, null);
    }

    public void setRewriteHandlerObserver(RewriteHandlerObserver rewriteHandlerObserver) {
        this.rewriteHandlerObserver = rewriteHandlerObserver;
    }
}

