/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.FabricThreadPool;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.utils.Base64Encoder;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.authentication.AuthenticationManager;
import com.streamscape.sef.network.http.server.config.ServletInfo;
import com.streamscape.sef.network.http.server.cors.CORSPreprocessingHandler;
import com.streamscape.sef.network.http.server.dropbox.DropBoxConfigurator;
import com.streamscape.sef.network.http.server.jetty.CustomizedRequestLogHandler;
import com.streamscape.sef.network.http.server.jetty.DirectoryHandler;
import com.streamscape.sef.network.http.server.jetty.HTTPRequestTrigger;
import com.streamscape.sef.network.http.server.jetty.HTTPRequestTriggerHandler;
import com.streamscape.sef.network.http.server.jetty.HttpSessionListeners;
import com.streamscape.sef.network.http.server.jetty.HttpSessionListenersImpl;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.jetty.JettyErrorHandler;
import com.streamscape.sef.network.http.server.jetty.JettyFabricServletSecurityHandler;
import com.streamscape.sef.network.http.server.jetty.JettyFabricServletSessionHandler;
import com.streamscape.sef.network.http.server.jetty.JettyWarDeployer;
import com.streamscape.sef.network.http.server.jetty.RewriteHandlerObserver;
import com.streamscape.sef.network.http.server.jetty.RewritePatternRuleWrapper;
import com.streamscape.sef.network.http.server.jetty.SessionMaxInactiveIntervalHandler;
import com.streamscape.sef.network.http.server.jetty.WarDeployer;
import com.streamscape.sef.network.http.server.jetty.customizer.APICustomizerHandler;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionReleaseHandler;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProviders;
import com.streamscape.sef.network.http.server.swagger.clientgen.SwaggerClientGenConfigurator;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.network.mf.admin.CertificatesFactory;
import com.streamscape.sef.trace.TraceConfigurator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.DispatcherType;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.HashedSession;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServer {
    private RuntimeContext context;
    private HTTPAcceptor acceptor;
    private Server server;
    private JettyWarDeployer warDeployer;
    private AuthenticationManager authenticationManager;
    private HashSessionManager sessionManager;
    private HTTPRequestTrigger httpRequestTrigger;
    private JettyAdvancedProperties.Properties properties;
    private HttpSessionListeners httpSessionListeners = new HttpSessionListenersImpl();
    private DropBoxConfigurator dropBoxConfigurator;

    public JettyServer(RuntimeContext context, HTTPAcceptor acceptor) {
        this.context = context;
        this.acceptor = acceptor;
    }

    public void start() throws Exception {
        Trace.logDebug(this, "Starting HTTP server '" + this.acceptor.getName() + "' ...");
        if (this.server != null) {
            return;
        }
        Object tmpDirectory = this.acceptor.getConfiguration().getAdvancedProperties().getProperty("jetstream.tmp.directory");
        if (tmpDirectory != null && ((String)tmpDirectory).trim().length() > 0) {
            File tmpDirectoryFile = new File((String)tmpDirectory);
            if (!tmpDirectoryFile.isAbsolute()) {
                tmpDirectory = this.acceptor.getWorkingDir() + "/" + ((String)tmpDirectory).trim();
                tmpDirectoryFile = new File((String)tmpDirectory);
                this.acceptor.getConfiguration().getTransientAdvancedProperties().setProperty("jetstream.tmp.directory", tmpDirectoryFile.getAbsolutePath());
            }
            if (!tmpDirectoryFile.exists()) {
                new File((String)tmpDirectory).mkdirs();
            }
        }
        this.properties = JettyAdvancedProperties.build(this.acceptor.getConfiguration());
        this.properties.traceProperties(this.acceptor.getName());
        this.createDirectories();
        if (TraceConfigurator.getInstance().getLogFile() != null) {
            this.acceptor.getConfiguration().getUrlToPathAliases().put(this.acceptor.getRuntimeContext().getName() + ".log", TraceConfigurator.getInstance().getLogFile().getAbsolutePath());
        }
        FabricThreadPool fabricThreadPool = FabricThreadManager.getInstance().createDaemonThreadPool(ThreadPoolType.DYNAMIC, "HTTP:Request.Handler", "Pools of threads for HTTP requests handling.", this.properties.getIntProperty("jetstream.thread.pool.core.threads.count"), this.properties.getIntProperty("jetstream.thread.pool.max.threads.count"), this.properties.getIntProperty("jetstream.thread.pool.max.queue.size"));
        ((ThreadPoolExecutor)fabricThreadPool.getExecutor()).setKeepAliveTime(this.properties.getLongProperty("jetstream.thread.pool.keep.alive.timeout.ms"), TimeUnit.MILLISECONDS);
        ((ThreadPoolExecutor)fabricThreadPool.getExecutor()).allowCoreThreadTimeOut(this.properties.getBooleanProperty("jetstream.thread.pool.allow.core.thread.timeout"));
        this.server = new Server((ThreadPool)new ExecutorThreadPool(fabricThreadPool.getExecutor()));
        this.initConnectors();
        this.authenticationManager = new AuthenticationManager(this.acceptor);
        this.authenticationManager.start();
        this.httpRequestTrigger = new HTTPRequestTrigger(this.context, this.acceptor.getConfiguration());
        this.httpRequestTrigger.start();
        this.initHandlers();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.acceptor.getRuntimeContext().getSystemClassLoaderChain());
            this.server.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        Trace.logInfo(this, "HTTP server '" + this.acceptor.getName() + "' at '" + this.acceptor.getConfiguration().getResolvedUrlWithSchema() + "' started.");
    }

    public void stop() throws Exception {
        Trace.logDebug(this, "Stopping HTTP server " + this.acceptor.getName() + " ...");
        try {
            if (this.server != null) {
                this.server.stop();
                this.server.join();
            }
        }
        catch (Throwable exception) {
            Trace.logError(this, "Failed to stop server.");
            Trace.logException(this, exception, true);
        }
        try {
            if (this.httpRequestTrigger != null) {
                this.httpRequestTrigger.stop();
            }
        }
        catch (Throwable exception) {
            Trace.logError(this, "Failed to stop http request triggers.");
            Trace.logException(this, exception, true);
        }
        try {
            if (this.authenticationManager != null) {
                this.authenticationManager.stop();
            }
        }
        catch (Throwable exception) {
            Trace.logError(this, "Failed to stop authentication manager.");
            Trace.logException(this, exception, true);
        }
        Trace.logInfo(this, "HTTP server " + this.acceptor.getName() + " stopped.");
    }

    private void initConnectors() throws Exception {
        KeepAliveServerConnector connector;
        HttpConfiguration confifuration = new HttpConfiguration();
        confifuration.setOutputBufferSize(this.properties.getIntProperty("jetstream.http.configuration.output.buffer.size").intValue());
        confifuration.setOutputAggregationSize(this.properties.getIntProperty("jetstream.http.configuration.output.agregation.size").intValue());
        confifuration.setRequestHeaderSize(this.properties.getIntProperty("jetstream.http.configuration.request.header.size").intValue());
        confifuration.setResponseHeaderSize(this.properties.getIntProperty("jetstream.http.configuration.response.header.size").intValue());
        confifuration.setHeaderCacheSize(this.properties.getIntProperty("jetstream.http.configuration.header.cache.size").intValue());
        confifuration.setSendDateHeader(this.properties.getBooleanProperty("jetstream.http.configuration.send.date.header").booleanValue());
        confifuration.setSendServerVersion(this.properties.getBooleanProperty("jetstream.http.configuration.send.server.version").booleanValue());
        if (this.acceptor.getConfiguration().getEnableSSL()) {
            String password = this.acceptor.getConfiguration().getKeyStorePassword();
            password = password != null ? new String(new Base64Encoder().decode(password)) : null;
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePassword(password);
            RuntimeContext context = this.acceptor.getRuntimeContext();
            sslContextFactory.setKeyStoreResource((Resource)new BytesResource(CertificatesFactory.getKeyStorePathFor(this.acceptor, context), CertificatesFactory.getKeyStoreFor(this.acceptor, context)));
            sslContextFactory.setTrustStoreResource((Resource)new BytesResource(CertificatesFactory.getTrustStorePathFor(this.acceptor, context), CertificatesFactory.getTrustStoreFor(this.acceptor, context)));
            HttpConfiguration httpsConfiguration = new HttpConfiguration(confifuration);
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            connector = new KeepAliveServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfiguration)});
        } else {
            connector = new KeepAliveServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(confifuration)});
        }
        connector.setHost(this.acceptor.getAddress().getAddress().getHostName());
        connector.setPort(this.acceptor.getAddress().getAddress().getPort());
        connector.setIdleTimeout(this.acceptor.getConfiguration().getKeepAliveTimeout() * 1000);
        connector.setAcceptQueueSize(this.properties.getIntProperty("jetstream.socket.backlog.size"));
        this.server.addConnector((Connector)connector);
    }

    private void initHandlers() {
        ArrayList<Object> handlers = new ArrayList<Object>();
        JettyErrorHandler errorHandler = new JettyErrorHandler();
        errorHandler.setServer(this.server);
        this.server.addBean((Object)errorHandler);
        ContextHandlerCollection webapps = new ContextHandlerCollection();
        DeploymentManager deploymentManager = new DeploymentManager();
        deploymentManager.setContexts(webapps);
        this.warDeployer = new JettyWarDeployer(this.acceptor, deploymentManager);
        this.server.addBean((Object)this.warDeployer);
        this.server.addBean((Object)deploymentManager);
        APICustomizerHandler customizerHandler = new APICustomizerHandler(false);
        customizerHandler.setConfiguration(this.acceptor.getConfiguration());
        customizerHandler.setHandler((Handler)webapps);
        handlers.add((Object)customizerHandler);
        CORSPreprocessingHandler corsProcessingHandler = new CORSPreprocessingHandler();
        corsProcessingHandler.setCorsConfiguration(this.acceptor.getConfiguration().getOriginAccessControlConfiguration());
        handlers.add((Object)corsProcessingHandler);
        ServletContextHandler sessionAndSecurityContextHandler = new ServletContextHandler(1);
        sessionAndSecurityContextHandler.setSessionHandler((SessionHandler)this.createSessionHandler());
        sessionAndSecurityContextHandler.setContextPath("/");
        this.authenticationManager.initServlets(sessionAndSecurityContextHandler);
        sessionAndSecurityContextHandler.getServletHandler().setEnsureDefaultServlet(false);
        JettyFabricServletSecurityHandler securityHandler = this.createSecurityHandler();
        securityHandler.setHandler((Handler)sessionAndSecurityContextHandler.getServletHandler());
        sessionAndSecurityContextHandler.getSessionHandler().setHandler((Handler)securityHandler);
        this.setServletContextAttribute(sessionAndSecurityContextHandler);
        handlers.add(sessionAndSecurityContextHandler);
        ServletContextHandler servletContextesHandler = new ServletContextHandler();
        servletContextesHandler.setContextPath("/");
        for (ServletInfo servletInfo : this.acceptor.getConfiguration().getServlets()) {
            ServletHolder holder;
            if (servletInfo.getServletPath().startsWith("/sor")) {
                holder = servletContextesHandler.addServlet(servletInfo.getClassName(), "/sorquilt" + servletInfo.getServletPath().substring("/sor".length()));
                if (servletInfo.getParameters() != null) {
                    holder.setInitParameters(servletInfo.getParameters());
                }
            }
            holder = servletContextesHandler.addServlet(servletInfo.getClassName(), servletInfo.getServletPath());
            if (servletInfo.getParameters() == null) continue;
            holder.setInitParameters(servletInfo.getParameters());
        }
        try {
            this.dropBoxConfigurator = new DropBoxConfigurator();
            this.dropBoxConfigurator.configure(servletContextesHandler, this.acceptor, this.authenticationManager);
        }
        catch (Exception exception) {
            Trace.logError(this, "WARNING: Failed to configure drop box.");
            Trace.logException(this, exception, true);
        }
        try {
            new SwaggerClientGenConfigurator().configure(servletContextesHandler, this.acceptor);
        }
        catch (Exception exception) {
            Trace.logError(this, "WARNING: Failed to configure swagger client generator.");
            Trace.logException(this, exception, true);
        }
        servletContextesHandler.getServletHandler().setEnsureDefaultServlet(false);
        this.setServletContextAttribute(servletContextesHandler);
        APICustomizerHandler customizerHandler2 = new APICustomizerHandler(true);
        customizerHandler2.setConfiguration(this.acceptor.getConfiguration());
        customizerHandler2.setHandler((Handler)servletContextesHandler);
        SessionMaxInactiveIntervalHandler sessionMaxInactiveIntervalHandler = new SessionMaxInactiveIntervalHandler();
        sessionMaxInactiveIntervalHandler.setHandler((Handler)customizerHandler2);
        handlers.add((Object)sessionMaxInactiveIntervalHandler);
        DirectoryHandler directoryHandler = new DirectoryHandler();
        directoryHandler.init(this.context, this.acceptor.getConfiguration(), this.acceptor.getHtmlDir());
        handlers.add((Object)directoryHandler);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(this.acceptor.getHtmlDir());
        resourceHandler.setMinMemoryMappedContentLength(this.properties.getIntProperty("jetstream.resource.min.memory.mapped.content.length").intValue());
        handlers.add(resourceHandler);
        handlers.add(new DefaultHandler());
        HandlerCollection handlersCollection = new HandlerCollection();
        handlersCollection.setHandlers(handlers.toArray(new Handler[0]));
        this.server.setHandler((Handler)handlersCollection);
        if (this.acceptor.getConfiguration().getLogEachRequest()) {
            NCSARequestLog requestLog = new NCSARequestLog();
            requestLog.setFilename(this.acceptor.getWorkingDir() + "acceptor_yyyy_mm_dd.log");
            requestLog.setExtended(this.acceptor.getConfiguration().getLogExtended());
            requestLog.setLogDateFormat(this.acceptor.getConfiguration().getLogDateFormat());
            requestLog.setRetainDays(this.properties.getIntProperty("jetstream.request.logger.retain.days").intValue());
            requestLog.setAppend(this.properties.getBooleanProperty("jetstream.request.logger.append").booleanValue());
            String timezone = this.properties.getStringProperty("jetstream.request.logger.timezone");
            if (timezone == null || timezone.trim().length() == 0 || timezone.equalsIgnoreCase("LOCAL")) {
                timezone = TimeZone.getDefault().getID();
            }
            requestLog.setLogTimeZone(timezone);
            requestLog.setLogCookies(this.properties.getBooleanProperty("jetstream.request.logger.log.cookies").booleanValue());
            requestLog.setLogLatency(this.properties.getBooleanProperty("jetstream.request.logger.log.latency").booleanValue());
            requestLog.setLogServer(this.properties.getBooleanProperty("jetstream.request.logger.log.server").booleanValue());
            requestLog.setPreferProxiedForAddress(this.properties.getBooleanProperty("jetstream.request.logger.log.prefer.proxied").booleanValue());
            requestLog.setIgnorePaths(StringUtils.split(this.properties.getStringProperty("jetstream.request.logger.ignored.paths"), ';').toArray(new String[0]));
            CustomizedRequestLogHandler requestLogHandler = new CustomizedRequestLogHandler(requestLog);
            requestLogHandler.setHandler(this.server.getHandler());
            this.server.setHandler((Handler)requestLogHandler);
        }
        HTTPRequestTriggerHandler triggerHandler = new HTTPRequestTriggerHandler();
        triggerHandler.setHTTPRequestTrigger(this.httpRequestTrigger);
        triggerHandler.setHandler(this.server.getHandler());
        this.server.setHandler((Handler)triggerHandler);
        FabricConnectionReleaseHandler fabricConnectionReleaseHandler = new FabricConnectionReleaseHandler();
        fabricConnectionReleaseHandler.setHandler(this.server.getHandler());
        this.server.setHandler((Handler)fabricConnectionReleaseHandler);
        RewriteHandler rewriteHandler = new RewriteHandler();
        rewriteHandler.setDispatcherTypes(new DispatcherType[]{DispatcherType.REQUEST});
        rewriteHandler.setRewritePathInfo(true);
        rewriteHandler.setRewriteRequestURI(true);
        rewriteHandler.addRule((Rule)RewriteHandlerObserver.createRewritePatternRuleWrapper("/sor", "/sor"));
        rewriteHandler.addRule((Rule)RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard("/sor", "/sor"));
        rewriteHandler.addRule((Rule)RewriteHandlerObserver.createRewritePatternRuleWrapper("/sor", "/security"));
        rewriteHandler.addRule((Rule)RewriteHandlerObserver.createRewritePatternRuleWrapperWildcard("/sor", "/security"));
        RewritePatternRuleWrapper rule = new RewritePatternRuleWrapper("/public-sys");
        rule.setPattern("/public");
        rule.setReplacement("/");
        rewriteHandler.addRule((Rule)rule);
        rule = new RewritePatternRuleWrapper("/public-sys-wild");
        rule.setPattern("/public/*");
        rule.setReplacement("/");
        rewriteHandler.addRule((Rule)rule);
        RewriteHandlerObserver rewriteHandlerObserver = new RewriteHandlerObserver(rewriteHandler);
        rewriteHandlerObserver.onApplicationDeployed("/dashboard");
        rewriteHandlerObserver.onApplicationDeployed("/os");
        rewriteHandlerObserver.onApplicationDeployed("/rtai");
        rewriteHandlerObserver.onApplicationDeployed("/sor");
        rewriteHandler.setHandler(this.server.getHandler());
        this.server.setHandler((Handler)rewriteHandler);
        this.warDeployer.setRewriteHandlerObserver(rewriteHandlerObserver);
    }

    private JettyFabricServletSessionHandler createSessionHandler() {
        this.sessionManager = new HashSessionManager(this){
            private long lastScavengeTime = 0L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void scavenge() {
                long timeout;
                if (this.lastScavengeTime > 0L && (timeout = System.currentTimeMillis() - this.lastScavengeTime) > (long)(this.getScavengePeriod() * 1000 + 5000)) {
                    long sleepTime = timeout - (long)(this.getScavengePeriod() * 1000 + 5000);
                    Trace.logInfo((Object)this, "WARNING: it seems that OS is waked up after hibernate. Approximately sleep time was {} ms. Updating session access times.", sleepTime);
                    Iterator iterator = this._sessions.values().iterator();
                    while (iterator.hasNext()) {
                        HashedSession session;
                        HashedSession hashedSession = session = (HashedSession)iterator.next();
                        synchronized (hashedSession) {
                            if (session.isValid()) {
                                long accessed = session.getAccessed();
                                if (System.currentTimeMillis() - accessed > sleepTime) {
                                    AuthenticationHelper.touchSession((HttpSession)session, session.getAccessed() + sleepTime);
                                    Trace.logInfo((Object)this, "Session {} access time updated from {}ms to {}ms.", session.getId(), accessed, session.getAccessed());
                                }
                            }
                        }
                    }
                }
                try {
                    super.scavenge();
                }
                finally {
                    this.lastScavengeTime = System.currentTimeMillis();
                }
            }
        };
        this.sessionManager.setScavengePeriod(10);
        this.sessionManager.setMaxInactiveInterval(this.acceptor.getConfiguration().getSessionTimeout() * 60);
        this.sessionManager.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.URL, SessionTrackingMode.COOKIE));
        this.sessionManager.setSessionIdPathParameterName(null);
        this.sessionManager.addEventListener((EventListener)new HttpSessionListener(){

            @Override
            public void sessionCreated(HttpSessionEvent event) {
                event.getSession().setAttribute("com.streamscape.sef.network.http.server.HTTPRequestTrigger.session.requests.count", new AtomicLong(0L));
                Trace.logDebug(this, "New session (id {}) created (sessions count = {})", event.getSession().getId(), JettyServer.this.sessionManager.getSessions());
                JettyServer.this.httpSessionListeners.onSessionCreated(event.getSession());
            }

            @Override
            public void sessionDestroyed(HttpSessionEvent event) {
                if (Trace.isDebugEnabled(this.getClass())) {
                    Object message = "Session";
                    HttpSession session = event.getSession();
                    if (session != null) {
                        message = (String)message + " (id " + session.getId() + ", last accessed " + (System.currentTimeMillis() - session.getLastAccessedTime()) + " ms ago)";
                    }
                    message = (String)message + " destroyed (sessions count = " + JettyServer.this.sessionManager.getSessions() + ").";
                    Trace.logDebug(this, (String)message);
                }
                if (JettyServer.this.authenticationManager != null) {
                    JettyServer.this.authenticationManager.getFabricConnectionsProviders().removeConnection(event.getSession().getId(), false);
                }
                JettyServer.this.httpSessionListeners.onSessionDestroyed(event.getSession());
            }
        });
        JettyFabricServletSessionHandler handler = new JettyFabricServletSessionHandler();
        handler.setSessionManager((SessionManager)this.sessionManager);
        return handler;
    }

    private JettyFabricServletSecurityHandler createSecurityHandler() {
        JettyFabricServletSecurityHandler fabricServletSecurityHandler = new JettyFabricServletSecurityHandler();
        fabricServletSecurityHandler.seAuthenticationManager(this.authenticationManager);
        fabricServletSecurityHandler.setHTTPRequestTrigger(this.httpRequestTrigger);
        return fabricServletSecurityHandler;
    }

    private void setServletContextAttribute(ServletContextHandler handler) {
        handler.getServletContext().setAttribute(FabricConnectionsProviders.ATTRIBUTE, (Object)this.authenticationManager.getFabricConnectionsProviders());
        handler.getServletContext().setAttribute(WarDeployer.ATTRIBUTE, (Object)this.warDeployer);
        handler.getServletContext().setAttribute(HTTPAcceptorConfiguration.ATTRIBUTE, (Object)this.acceptor.getConfiguration());
        handler.getServletContext().setAttribute(HTTPRequestTrigger.ATTRIBUTE, (Object)this.httpRequestTrigger);
        handler.getServletContext().setAttribute(HttpSessionListeners.ATTRIBUTE, (Object)this.httpSessionListeners);
    }

    protected void createDirectories() {
        try {
            FileIOUtils.newFileDir(this.acceptor.getHttpDir());
            FileIOUtils.newFileDir(this.acceptor.getHtmlDir());
            FileIOUtils.newFileDir(this.acceptor.getWebApplicationDir());
            FileIOUtils.newFileDir(this.acceptor.getWebArchiveDir());
            FileIOUtils.newFileDir(new File(this.acceptor.getHtmlDir(), "/ext/sys").getPath());
            FileIOUtils.newFileDir(new File(this.acceptor.getHtmlDir(), "/ext/usr").getPath());
            String imagesDir = this.acceptor.getHtmlDir() + "images/";
            String[] images = new String[]{"loader.gif", "TypeBean.png", "small-javabean.png", "evtrigger.gif", "event.gif", "fabricUser.png", "event_handler.png", "actionable_event.png", "advisory.png", "metric.png", "method.png", "semantic_type.png", "pages_list.gif", "odata_v4.png", "swagger.png", "StreamScapeLogo.jpg", "StreamScapeLogo.png", "download.png"};
            String path = "com/streamscape/sef/network/http/server/servlet/html/images";
            for (String image : images) {
                HTTPUtils.copyResourceFromJar(this.acceptor.getRuntimeContext(), path, image, imagesDir, true);
            }
            HTTPUtils.copyResourceFromJar(this.acceptor.getRuntimeContext(), path, "favicon.ico", this.acceptor.getHtmlDir(), true);
            HTTPUtils.copyResourcesFromJar(this.acceptor.getRuntimeContext(), "com/streamscape/sef/network/http/server/servlet/html/css", new String[]{"prism.js", "prism.css", "sorservlet.css", "sorrowset.css"}, this.acceptor.getHtmlDir() + "css/", true);
            HTTPUtils.copyResourcesFromJar(this.acceptor.getRuntimeContext(), "com/streamscape/sef/network/http/server/servlet/html/json", new String[]{"meta.sql2SemanticTypes.json", "meta.sqlTypeAliases.json"}, this.acceptor.getHtmlDir() + "json/", true);
            HTTPUtils.copyResourcesFromJar(this.acceptor.getRuntimeContext(), "com/streamscape/sef/network/http/server/servlet/html", new String[]{"about.html"}, this.acceptor.getHtmlDir(), false);
            HTTPUtils.copyResourcesFromJar(this.acceptor.getRuntimeContext(), "swagger/", new String[]{"swaggerui.war"}, this.acceptor.getWebArchiveDir(), true);
        }
        catch (Throwable exception) {
            Trace.logError(this, "Exception creating acceptor artifacts.");
            Trace.logException(this, exception, true);
        }
    }

    private static class BytesResource
    extends Resource {
        private byte[] data;
        private String name;

        BytesResource(String name, byte[] data) {
            this.name = name;
            this.data = data;
        }

        public String getName() {
            return this.name;
        }

        public InputStream getInputStream() throws IOException {
            return this.data != null ? new ByteArrayInputStream(this.data) : null;
        }

        public String toString() {
            return this.getName();
        }

        public boolean isContainedIn(Resource r) throws MalformedURLException {
            return false;
        }

        public void close() {
        }

        public boolean exists() {
            return true;
        }

        public boolean isDirectory() {
            return false;
        }

        public long lastModified() {
            return 0L;
        }

        public long length() {
            return this.data.length;
        }

        public URL getURL() {
            return null;
        }

        public File getFile() throws IOException {
            return null;
        }

        public ReadableByteChannel getReadableByteChannel() throws IOException {
            return null;
        }

        public boolean delete() throws SecurityException {
            return false;
        }

        public boolean renameTo(Resource dest) throws SecurityException {
            return false;
        }

        public String[] list() {
            return null;
        }

        public Resource addPath(String path) throws IOException, MalformedURLException {
            return null;
        }
    }

    private class KeepAliveServerConnector
    extends ServerConnector {
        public KeepAliveServerConnector(Server server, ConnectionFactory ... factories) {
            super(server, factories);
        }

        protected void configure(Socket socket) {
            super.configure(socket);
            try {
                socket.setKeepAlive(JettyServer.this.properties.getBooleanProperty("jetstream.socket.keep.alive.enabled"));
            }
            catch (SocketException e) {
                Trace.logError((Object)this, "Failed to set keep alive on server socket for " + JettyServer.this.acceptor.getName() + ".");
            }
        }
    }
}

