/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty;

import com.streamscape.omf.odata.v4.server.jdbc.ODataUriSessionHelper;
import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.session.SessionHandler;

public class JettyFabricServletSessionHandler
extends SessionHandler {
    public static final String FABRIC_SESSION = "FabricSession";
    private static final String FABRIC_SESSION_PREFIX = "FabricSession=";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkRequestedSessionId(Request baseRequest, HttpServletRequest request) {
        String urlSessionId;
        if (AuthenticationHelper.isFabricRequest(request) || AuthenticationHelper.isDropBoxRequest(request)) {
            String fabricSessionId = null;
            String query = request.getQueryString();
            baseRequest.setRequestedSessionIdFromCookie(false);
            if (query != null) {
                int s = query.indexOf(FABRIC_SESSION_PREFIX);
                if (s >= 0) {
                    char c;
                    int i;
                    for (i = s += FABRIC_SESSION_PREFIX.length(); i < query.length() && (c = query.charAt(i)) != '&'; ++i) {
                    }
                    fabricSessionId = query.substring(s, i);
                }
                if (fabricSessionId != null) {
                    if (baseRequest.getCookies() != null) {
                        for (Cookie cookie : baseRequest.getCookies()) {
                            if (!cookie.getName().equalsIgnoreCase(baseRequest.getSessionManager().getSessionCookieConfig().getName())) continue;
                            cookie.setMaxAge(0);
                            break;
                        }
                    }
                    if (fabricSessionId.length() <= 0) return;
                    baseRequest.setRequestedSessionId(fabricSessionId);
                }
            }
        } else if (ODataUriSessionHelper.isSessionIdEnabled() && AuthenticationHelper.isOdataRequest(request) && (urlSessionId = ODataUriSessionHelper.getUriSession((HttpServletRequest)request)) != null) {
            baseRequest.setRequestedSessionIdFromCookie(false);
            baseRequest.setRequestedSessionId(urlSessionId);
        }
        super.checkRequestedSessionId(baseRequest, request);
    }
}

