/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty;

import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.authentication.AuthenticationManager;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.jetty.HTTPRequestTrigger;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProvider;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class JettyFabricServletSecurityHandler
extends HandlerWrapper {
    private AuthenticationManager authenticationManager;
    private HTTPRequestTrigger httpRequestTrigger;

    public void seAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setHTTPRequestTrigger(HTTPRequestTrigger httpRequestTrigger) {
        this.httpRequestTrigger = httpRequestTrigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (baseRequest.isHandled()) {
            return;
        }
        Authenticator.Authentication authentication = null;
        String oldContextPath = baseRequest.getContextPath();
        try {
            FabricConnectionsProvider provider;
            if (oldContextPath == null || oldContextPath.length() == 0) {
                baseRequest.setContextPath(AuthenticationHelper.getRequestContextPath(request));
            }
            if ((authentication = this.authenticationManager.getAuthenticator(request).authenticate(request, response)) == Authenticator.Authentication.OK && (provider = this.authenticationManager.getFabricConnectionsProvider(request)) != null) {
                authentication = provider.provideAndAcquireConnection(request, response) != null ? Authenticator.Authentication.OK : Authenticator.Authentication.FAILED;
            }
        }
        finally {
            baseRequest.setContextPath(oldContextPath);
        }
        if (authentication == Authenticator.Authentication.OK || authentication == Authenticator.Authentication.NO_NEED) {
            AuthenticationHelper.touchSession(request.getSession());
            super.handle(target, baseRequest, request, response);
        } else {
            this.httpRequestTrigger.post(request, HTTPRequestTrigger.OperationType.AUTH_FAILED);
            baseRequest.setHandled(true);
        }
    }
}

