/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JettyAdvancedProperties {
    public static final String JETTY_HTTP_CONFIGURATION_OUTPUT_BUFFER_SIZE = "jetstream.http.configuration.output.buffer.size";
    public static final String JETTY_HTTP_CONFIGURATION_OUTPUT_AGREGATION_SIZE = "jetstream.http.configuration.output.agregation.size";
    public static final String JETTY_HTTP_CONFIGURATION_REQUEST_HEADER_SIZE = "jetstream.http.configuration.request.header.size";
    public static final String JETTY_HTTP_CONFIGURATION_RESPONSE_HEADER_SIZE = "jetstream.http.configuration.response.header.size";
    public static final String JETTY_HTTP_CONFIGURATION_HEADER_CACHE_SIZE = "jetstream.http.configuration.header.cache.size";
    public static final String JETTY_HTTP_CONFIGURATION_SEND_SERVER_VERSION = "jetstream.http.configuration.send.server.version";
    public static final String JETTY_HTTP_CONFIGURATION_SEND_DATE_HEADER = "jetstream.http.configuration.send.date.header";
    public static final String JETTY_SOCKET_BACKLOG_SIZE = "jetstream.socket.backlog.size";
    public static final String JETTY_SOCKET_KEEP_ALIVE_ENABLED = "jetstream.socket.keep.alive.enabled";
    public static final String JETTY_RESOURCE_MIN_MEMORY_MAPPED_CONTENT_LENGTH = "jetstream.resource.min.memory.mapped.content.length";
    public static final String JETTY_THREAD_POOL_KEEP_ALIVE_TIMEOUT_MS = "jetstream.thread.pool.keep.alive.timeout.ms";
    public static final String JETTY_THREAD_POOL_ALLOW_CORE_THREAD_TIMEOUT = "jetstream.thread.pool.allow.core.thread.timeout";
    public static final String JETTY_THREAD_POOL_CORE_THREADS_COUNT = "jetstream.thread.pool.core.threads.count";
    public static final String JETTY_THREAD_POOL_MAX_THREADS_COUNT = "jetstream.thread.pool.max.threads.count";
    public static final String JETTY_THREAD_POOL_MAX_QUEUE_SIZE = "jetstream.thread.pool.max.queue.size";
    public static final String JETTY_REQUEST_LOGGER_RETAIN_DAYS = "jetstream.request.logger.retain.days";
    public static final String JETTY_REQUEST_LOGGER_APPEND = "jetstream.request.logger.append";
    public static final String JETTY_REQUEST_LOGGER_TIMEZONE = "jetstream.request.logger.timezone";
    public static final String JETTY_REQUEST_LOGGER_LOG_COOKIES = "jetstream.request.logger.log.cookies";
    public static final String JETTY_REQUEST_LOGGER_LOG_LATENCY = "jetstream.request.logger.log.latency";
    public static final String JETTY_REQUEST_LOGGER_LOG_SERVER = "jetstream.request.logger.log.server";
    public static final String JETTY_REQUEST_LOGGER_LOG_PREFER_PROXIED = "jetstream.request.logger.log.prefer.proxied";
    public static final String JETTY_REQUEST_LOGGER_IGNORED_PATHS = "jetstream.request.logger.ignored.paths";
    public static final String JETTY_MULTIPART_FORM_DATA_MAX_SIZE = "jetstream.multipart.form.data.max.size";
    public static final String JETTY_MULTIPART_FORM_DATA_MAX_SIZE_IN_MEMORY = "jetstream.multipart.form.data.max.size.in.memory";
    public static final String JETTY_TMP_DIRECTORY = "jetstream.tmp.directory";
    public static final String JETTY_DATASPACE_QUERY_TIMEOUT = "jetstream.dataspace.query.timeout.secs";
    public static final String JETTY_REQUEST_TRIGGER_INCLUDE_STATS = "jetstream.request.trigger.include.stats";
    public static final String JETTY_REQUEST_TRIGGER_INCLUDE_QUERY = "jetstream.request.trigger.include.query";
    public static final String JETTY_REQUEST_TRIGGER_POST_MAX_SIZE = "jetstream.request.trigger.post.max.size";
    public static final String JETTY_REQUEST_TRIGGER_INCLUDE_HEADERS = "jetstream.request.trigger.include.headers";
    public static final String JETTY_REQUEST_TRIGGER_EVENT_QUEUE_CAPACITY = "jetstream.request.trigger.event.queue.capacity";
    public static final String JETTY_REST_SHARE_CONNECTION_BETWEEN_SESSIONS = "jetstream.rest.share.connection.between.sessions";
    public static final String JETTY_REST_SHARE_CONNECTION_BETWEEN_URIS = "jetstream.rest.share.connection.between.uris";
    public static final String JETTY_REST_CONNECTIONS_PER_USER_LIMIT = "jetstream.rest.connections.per.user.limit";
    public static final String JETTY_REST_CONNECTION_WAIT_TIMEOUT = "jetstream.rest.connection.wait.timeout";
    public static final String JETTY_REST_LOCKED_SESSION_WAIT_TIMEOUT = "jetstream.rest.locked.session.wait.timeout";
    public static final String JETTY_OAUTH2_SHARE_TOKEN_BETWEEN_SESSIONS = "jetstream.oauth2.share.token.between.sessions";
    public static final String JETTY_WAR_REDEPLOY_ON_START = "jetstream.war.redeploy.on.start";
    private static Map<String, PropertyInfo> defaults = Collections.synchronizedMap(new LinkedHashMap());

    private static void registerProperty(String key, Object value, String description, String units) {
        defaults.put(key, new PropertyInfo(value, description, units));
    }

    public static Object getDefaultProperty(String name) {
        return defaults.get(name).getValue();
    }

    public static Map<String, PropertyInfo> getDefaultPropertiesInfo() {
        return new LinkedHashMap<String, PropertyInfo>(defaults);
    }

    public static boolean existsDefaultProperty(String name) {
        return defaults.containsKey(name);
    }

    public static Map<String, String> getDefaultPropertiesAsStrings() {
        return defaults.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Objects.toString(((PropertyInfo)e.getValue()).getValue(), null), (u, v) -> u, LinkedHashMap::new));
    }

    private static Integer getIntProperty(Map<Object, Object> properties, String name) {
        String value = JettyAdvancedProperties.getProperty(properties, name);
        try {
            if (value != null) {
                return Integer.valueOf(value);
            }
            return (Integer)JettyAdvancedProperties.getDefaultProperty(name);
        }
        catch (RuntimeException exception) {
            Trace.logError(JettyAdvancedProperties.class, "Failed to cast value '" + value + "' of property '" + name + "' to integer.");
            Trace.logException(JettyAdvancedProperties.class, exception, true);
            throw exception;
        }
    }

    private static Long getLongProperty(Map<Object, Object> properties, String name) {
        String value = JettyAdvancedProperties.getProperty(properties, name);
        try {
            if (value != null) {
                return Long.valueOf(value);
            }
            return (Long)JettyAdvancedProperties.getDefaultProperty(name);
        }
        catch (RuntimeException exception) {
            Trace.logError(JettyAdvancedProperties.class, "Failed to cast value '" + value + "' of property '" + name + "' to long.");
            Trace.logException(JettyAdvancedProperties.class, exception, true);
            throw exception;
        }
    }

    private static Boolean getBooleanProperty(Map<Object, Object> properties, String name) {
        String value = JettyAdvancedProperties.getProperty(properties, name);
        try {
            if (value != null) {
                return Boolean.valueOf(value);
            }
            return (Boolean)JettyAdvancedProperties.getDefaultProperty(name);
        }
        catch (RuntimeException exception) {
            Trace.logError(JettyAdvancedProperties.class, "Failed to cast value '" + value + "' of property '" + name + "' to boolean.");
            Trace.logException(JettyAdvancedProperties.class, exception, true);
            throw exception;
        }
    }

    private static String getStringProperty(Map<Object, Object> properties, String name) {
        String value = JettyAdvancedProperties.getProperty(properties, name);
        if (value != null) {
            return value;
        }
        return (String)JettyAdvancedProperties.getDefaultProperty(name);
    }

    private static String getProperty(Map<Object, Object> properties, String name) {
        Object o;
        String value = null;
        if (properties != null && (o = properties.get(name)) != null) {
            value = String.valueOf(o);
        }
        return value;
    }

    public static Properties build(Map<Object, Object> properties) {
        return new Properties(properties);
    }

    public static Properties build(HTTPAcceptorConfiguration configuration) {
        java.util.Properties properties = new java.util.Properties();
        properties.putAll((Map<?, ?>)configuration.getAdvancedProperties());
        properties.putAll((Map<?, ?>)configuration.getTransientAdvancedProperties());
        return new Properties(properties);
    }

    static {
        JettyAdvancedProperties.registerProperty(JETTY_HTTP_CONFIGURATION_OUTPUT_BUFFER_SIZE, 32768, "HTTP Output Buffer Size", "size in bytes");
        JettyAdvancedProperties.registerProperty(JETTY_HTTP_CONFIGURATION_OUTPUT_AGREGATION_SIZE, 8192, "HTTP Output Aggregation Size", "size in bytes");
        JettyAdvancedProperties.registerProperty(JETTY_HTTP_CONFIGURATION_REQUEST_HEADER_SIZE, 8192, "HTTP Request Header Size", "size in bytes");
        JettyAdvancedProperties.registerProperty(JETTY_HTTP_CONFIGURATION_RESPONSE_HEADER_SIZE, 8192, "HTTP Response Header Size", "size in bytes");
        JettyAdvancedProperties.registerProperty(JETTY_HTTP_CONFIGURATION_HEADER_CACHE_SIZE, 512, "HTTP Header Cache Size", "size in bytes");
        JettyAdvancedProperties.registerProperty(JETTY_HTTP_CONFIGURATION_SEND_SERVER_VERSION, true, "HTTP Send Server Version", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_HTTP_CONFIGURATION_SEND_DATE_HEADER, true, "HTTP Send Data Header", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_SOCKET_BACKLOG_SIZE, 2000, "Socket BackLog Size", "size in bytes");
        JettyAdvancedProperties.registerProperty(JETTY_SOCKET_KEEP_ALIVE_ENABLED, true, "Socket Keep Alive Enabled", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_RESOURCE_MIN_MEMORY_MAPPED_CONTENT_LENGTH, -1, "Minimum memory mapped file content length.", "size in bytes, -1 means disabled");
        JettyAdvancedProperties.registerProperty(JETTY_THREAD_POOL_KEEP_ALIVE_TIMEOUT_MS, 60000L, "Thread Pool Keep Alive Timeout", "milliseconds");
        JettyAdvancedProperties.registerProperty(JETTY_THREAD_POOL_ALLOW_CORE_THREAD_TIMEOUT, true, "Thread Pool Allow Core Thread Timeout", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_THREAD_POOL_CORE_THREADS_COUNT, 50, "Thread Pool Core Threads Count", "number of threads");
        JettyAdvancedProperties.registerProperty(JETTY_THREAD_POOL_MAX_THREADS_COUNT, 100, "Thread Pool Maximum Threads Count", "number of threads");
        JettyAdvancedProperties.registerProperty(JETTY_THREAD_POOL_MAX_QUEUE_SIZE, 1000, "Thread Pool Maximum Queue Size", "queue size");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_LOGGER_RETAIN_DAYS, 10, "Request Logger Retain Days", "number of days");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_LOGGER_APPEND, true, "Request Logger Append", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_LOGGER_TIMEZONE, "LOCAL", "Request Logger TimeZone", "timezone | empty or LOCAL means local timezeone");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_LOGGER_LOG_COOKIES, false, "Request Logger Log Cookies", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_LOGGER_LOG_LATENCY, false, "Request Logger Log Latency", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_LOGGER_LOG_SERVER, false, "Request Logger Log Server", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_LOGGER_LOG_PREFER_PROXIED, false, "Request Logger Log Prefer Proxied", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_LOGGER_IGNORED_PATHS, "", "Request Logger Ignored Paths", "semicolon separated paths");
        JettyAdvancedProperties.registerProperty(JETTY_MULTIPART_FORM_DATA_MAX_SIZE, -1, "Multipart Form Data Maximum Size", "size in bytes | -1 unlimited");
        JettyAdvancedProperties.registerProperty(JETTY_MULTIPART_FORM_DATA_MAX_SIZE_IN_MEMORY, 0xA00000, "Multipart Form Data Maximum Size In Memory", "size in bytes");
        JettyAdvancedProperties.registerProperty(JETTY_TMP_DIRECTORY, "./tmp", "Tmp Directory Used by Server to Store Temporary Files", "directory path | emty to use default system tmp dir");
        JettyAdvancedProperties.registerProperty(JETTY_DATASPACE_QUERY_TIMEOUT, 300, "Default timeout for dataspace servlet queries.", "query timeout in seconds");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_TRIGGER_INCLUDE_STATS, true, "Request Trigger Include Stats", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_TRIGGER_INCLUDE_QUERY, true, "Request Trigger Include Query", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_TRIGGER_POST_MAX_SIZE, 0, "Request Trigger POST Maximum Size", "size in bytes");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_TRIGGER_INCLUDE_HEADERS, false, "Request Trigger Include Headers", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_REQUEST_TRIGGER_EVENT_QUEUE_CAPACITY, 100000, "Request Trigger Event Queue Capacity", "queue capacity");
        JettyAdvancedProperties.registerProperty(JETTY_REST_SHARE_CONNECTION_BETWEEN_URIS, true, "Share one fabric connection between different URIs or not", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_REST_SHARE_CONNECTION_BETWEEN_SESSIONS, true, "Share one fabric connection between different sessions or not", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_REST_CONNECTIONS_PER_USER_LIMIT, -1, "REST Connections per User Limit", "connections count | -1 unlimited");
        JettyAdvancedProperties.registerProperty(JETTY_REST_CONNECTION_WAIT_TIMEOUT, -1, "REST Connection Wait Timeout if Connections Limit per User reached", "in secs | -1 no wait | 0 block");
        JettyAdvancedProperties.registerProperty(JETTY_REST_LOCKED_SESSION_WAIT_TIMEOUT, 10, "REST Locked Session Wait Timeout if there are concurrent requests in the same session", "in secs | -1 no wait | 0 block");
        JettyAdvancedProperties.registerProperty(JETTY_OAUTH2_SHARE_TOKEN_BETWEEN_SESSIONS, true, "Allow access with one token in different sessions or not", "true | false");
        JettyAdvancedProperties.registerProperty(JETTY_WAR_REDEPLOY_ON_START, false, "Redeploy web applications on each node start or not", "true | false");
    }

    public static class PropertyInfo {
        private final Object value;
        private final String description;
        private final String units;

        public PropertyInfo(Object value, String description, String units) {
            this.value = value;
            this.description = description;
            this.units = units;
        }

        public Object getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUnits() {
            return this.units;
        }
    }

    public static class Properties {
        private Map<Object, Object> properties;

        private Properties(Map<Object, Object> properties) {
            this.properties = properties;
        }

        public Integer getIntProperty(String name) {
            return JettyAdvancedProperties.getIntProperty(this.properties, name);
        }

        public Integer getIntProperty(String name, Integer defaultValue) {
            Integer result = this.getIntProperty(name);
            return result != null ? result : defaultValue;
        }

        public Long getLongProperty(String name) {
            return JettyAdvancedProperties.getLongProperty(this.properties, name);
        }

        public Long getLongProperty(String name, Long defaultValue) {
            Long result = this.getLongProperty(name);
            return result != null ? result : defaultValue;
        }

        public Boolean getBooleanProperty(String name) {
            return JettyAdvancedProperties.getBooleanProperty(this.properties, name);
        }

        public Boolean getBooleanProperty(String name, Boolean defaultValue) {
            Boolean result = this.getBooleanProperty(name);
            return result != null ? result : defaultValue;
        }

        public String getStringProperty(String name) {
            return JettyAdvancedProperties.getStringProperty(this.properties, name);
        }

        public String getStringProperty(String name, String defaultValue) {
            String result = this.getStringProperty(name);
            return result != null ? result : defaultValue;
        }

        public String getProperty(String name) {
            return JettyAdvancedProperties.getProperty(this.properties, name);
        }

        public void setProperty(String name, String value) {
            if (!defaults.containsKey(name)) {
                throw new RuntimeException("Unknown advanced property");
            }
            Object defaultValue = JettyAdvancedProperties.getDefaultProperty(name);
            if (defaultValue instanceof String) {
                this.properties.put(name, value);
            } else if (defaultValue instanceof Integer) {
                this.properties.put(name, Integer.parseInt(value));
            } else if (defaultValue instanceof Long) {
                this.properties.put(name, Long.parseLong(value));
            } else if (defaultValue instanceof Boolean) {
                this.properties.put(name, Boolean.parseBoolean(value));
            } else {
                throw new RuntimeException("Unexpected class of property value");
            }
        }

        public void traceProperties(String acceptorName) {
            StringBuilder builder = new StringBuilder();
            HashMap<Object, Object> copy = new HashMap<Object, Object>(this.properties);
            builder.append(defaults.entrySet().stream().map(e -> (String)e.getKey() + " = " + Objects.toString(copy.remove(e.getKey()), Objects.toString(e.getValue()))).collect(Collectors.joining("\n")));
            Trace.logDebug(this, "HTTP server '" + acceptorName + "' properties:\n" + builder.toString());
            if (!copy.isEmpty()) {
                builder.setLength(0);
                copy.forEach((key, value) -> builder.append("\n").append(key).append(" = ").append(value));
                Trace.logDebug(this, "WARNING: HTTP server '" + acceptorName + "' unknown properties: " + builder.toString());
            }
        }
    }
}

