/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty;

import com.streamscape.sef.network.http.server.jetty.HttpSessionListener;
import com.streamscape.sef.network.http.server.jetty.HttpSessionListeners;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpSession;

public class HttpSessionListenersImpl
implements HttpSessionListeners {
    private List<HttpSessionListener> onSessionCreatedListeners = new CopyOnWriteArrayList<HttpSessionListener>();
    private List<HttpSessionListener> onSessionDestroyedListeners = new CopyOnWriteArrayList<HttpSessionListener>();
    private final Object onSessionDestroyedListenersMapMutex = new Object();
    private ConcurrentHashMap<String, List<HttpSessionListener>> onSessionDestroyedListenersMap = new ConcurrentHashMap();

    @Override
    public void addOnSessionCreatedListener(HttpSessionListener listener) {
        this.onSessionCreatedListeners.add(listener);
    }

    @Override
    public void removeOnSessionCreatedListener(HttpSessionListener listener) {
        this.onSessionCreatedListeners.remove(listener);
    }

    @Override
    public void addOnSessionDestroyedListener(HttpSessionListener listener) {
        this.onSessionDestroyedListeners.add(listener);
    }

    @Override
    public void removeOnSessionDestroyedListener(HttpSessionListener listener) {
        this.onSessionDestroyedListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnSessionDestroyedListener(HttpSession session, HttpSessionListener listener) {
        Object object = this.onSessionDestroyedListenersMapMutex;
        synchronized (object) {
            List<HttpSessionListener> listeners = new CopyOnWriteArrayList<HttpSessionListener>();
            List oldListeners = this.onSessionDestroyedListenersMap.putIfAbsent(session.getId(), listeners);
            if (oldListeners != null) {
                listeners = oldListeners;
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnSessionDestroyedListener(HttpSession session, HttpSessionListener listener) {
        Object object = this.onSessionDestroyedListenersMapMutex;
        synchronized (object) {
            List<HttpSessionListener> listeners = this.onSessionDestroyedListenersMap.get(session.getId());
            listeners.remove(listener);
            if (listeners.size() == 0) {
                this.onSessionDestroyedListenersMap.remove(session.getId());
            }
        }
    }

    @Override
    public void onSessionCreated(HttpSession session) {
        this.onSessionCreatedListeners.forEach(l -> l.onEvent(session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSessionDestroyed(HttpSession session) {
        this.onSessionDestroyedListeners.forEach(l -> l.onEvent(session));
        Object object = this.onSessionDestroyedListenersMapMutex;
        synchronized (object) {
            List<HttpSessionListener> listeners = this.onSessionDestroyedListenersMap.get(session.getId());
            if (listeners != null) {
                listeners.forEach(l -> l.onEvent(session));
                this.onSessionDestroyedListenersMap.remove(session.getId());
            }
        }
    }
}

