/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;

public class HTTPRequestTrigger {
    public static final String HTTP_REQUEST_EVENT_ID = "event.http.Request";
    public static final String ATTRIBUTE = HTTPRequestTrigger.class.getName();
    public static final String NO_SESSION = "no session";
    public static final String ACCEPTOR_PROPERTY = "Acceptor";
    public static final String NODE_PROPERTY = "Node";
    public static final String OPERATION_TYPE_PROPERTY = "OperationType";
    public static final String COMPONENT_PROPERTY = "TargetComponent";
    public static final String USER_NAME = "UserName";
    public static final String USER_IP_ADDRESS = "UserIpAddress";
    public static final String AUTHENTICATION_TYPE = "AuthenticationType";
    public static final String REQUEST_TIMESTAMP = "RequestTimestamp";
    public static final String REQUEST_LATENCY = "RequestLatency";
    public static final String SESSION_ID = "SessionId";
    public static final String SESSION_REQUESTS_COUNT = "SessionRequestsCount";
    public static final String URI_PROPERTY = "Uri";
    public static final String METHOD_PROPERTY = "Method";
    public static final String ATTRIBUTE_TRIGGER_EVENT_SENT = "com.streamscape.sef.network.http.server.HTTPRequestTrigger.event.sent";
    public static final String ATTRIBUTE_POST_REQUEST_CONTENT = "com.streamscape.sef.network.http.server.HTTPRequestTrigger.post.request.content";
    public static final String ATTRIBUTE_OPERATION_TYPE = "com.streamscape.sef.network.http.server.HTTPRequestTrigger.operation.type";
    public static final String ATTRIBUTE_COMPONENT_NAME = "com.streamscape.sef.network.http.server.HTTPRequestTrigger.component.name";
    public static final String ATTRIBUTE_POST_MAX_SIZE = "com.streamscape.sef.network.http.server.HTTPRequestTrigger.post.max.size";
    public static final String ATTRIBUTE_SESSION_REQUESTS_COUNT = "com.streamscape.sef.network.http.server.HTTPRequestTrigger.session.requests.count";
    private RuntimeContext context;
    private HTTPAcceptorConfiguration configuration;
    private FabricConnection connection;
    private BlockingQueue<DataEvent> eventsQueue;
    private FabricThread<?> eventRaiserThread;
    private Boolean includeStats;
    private Boolean includeQuery;
    private Boolean includeHeaders;
    private int postMaxSize;
    private Integer eventQueueCapacity;

    public HTTPRequestTrigger(RuntimeContext context, HTTPAcceptorConfiguration configuration) {
        this.context = context;
        this.configuration = configuration;
    }

    public void start() {
        if (this.configuration.isRequestTriggerEnabled()) {
            try {
                JettyAdvancedProperties.Properties properties = JettyAdvancedProperties.build(this.configuration);
                this.includeStats = properties.getBooleanProperty("jetstream.request.trigger.include.stats");
                this.includeQuery = properties.getBooleanProperty("jetstream.request.trigger.include.query");
                this.postMaxSize = properties.getIntProperty("jetstream.request.trigger.post.max.size");
                this.includeHeaders = properties.getBooleanProperty("jetstream.request.trigger.include.headers");
                this.eventQueueCapacity = properties.getIntProperty("jetstream.request.trigger.event.queue.capacity");
                this.connection = new FabricConnectionFactory().createConnection();
                this.connection.open();
                this.connection.bindProducerFor(HTTP_REQUEST_EVENT_ID);
                this.eventsQueue = new LinkedBlockingQueue<DataEvent>(this.eventQueueCapacity);
                this.eventRaiserThread = FabricThreadManager.getInstance().createThread("HTTP:RequestTriggerRaiser_" + this.configuration.getName(), "Raises http trigger event for '" + this.configuration.getName() + "' acceptor.", new EventRaiser());
                this.eventRaiserThread.start();
            }
            catch (Exception exception) {
                this.logError("Failed to initialize http request trigger. Cause: " + exception.getMessage());
                this.stop();
            }
        }
    }

    public void stop() {
        if (this.eventRaiserThread != null) {
            this.eventRaiserThread.interrupt();
            this.eventRaiserThread.join(1000L);
            this.eventRaiserThread = null;
        }
        if (this.eventsQueue != null) {
            this.eventsQueue.clear();
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (FabricConnectionException exception) {
                this.logError("Failed to close connection used in http request trigger. Cause: " + exception.getMessage());
            }
        }
    }

    public void setupRequest(HttpServletRequest request) {
        request.setAttribute(ATTRIBUTE_POST_MAX_SIZE, this.postMaxSize);
    }

    public static void ignoreRequest(HttpServletRequest request) {
        request.setAttribute(ATTRIBUTE_TRIGGER_EVENT_SENT, true);
    }

    public static void setRequestContent(HttpServletRequest request, byte[] content) {
        Integer postMaxSize = (Integer)request.getAttribute(ATTRIBUTE_POST_MAX_SIZE);
        if (postMaxSize == null || postMaxSize <= 0) {
            return;
        }
        if (content != null && content.length > postMaxSize) {
            content = Arrays.copyOf(content, (int)postMaxSize);
        }
        request.setAttribute(ATTRIBUTE_POST_REQUEST_CONTENT, content);
    }

    public static void setOperationType(HttpServletRequest request, OperationType operationType) {
        request.setAttribute(ATTRIBUTE_OPERATION_TYPE, (Object)operationType);
    }

    public static void setComponentName(HttpServletRequest request, String componentName) {
        request.setAttribute(ATTRIBUTE_COMPONENT_NAME, componentName);
    }

    public void postBefore(HttpServletRequest request) {
        if (this.configuration.isRequestTriggerEnabled() && this.includeStats != null && !this.includeStats.booleanValue()) {
            this.post(request);
        }
    }

    public void post(HttpServletRequest request) {
        this.post(request, null);
    }

    public void post(HttpServletRequest request, OperationType operationType) {
        this.post(request, operationType, null);
    }

    public void post(HttpServletRequest request, OperationType operationType, String component) {
        if (!this.configuration.isRequestTriggerEnabled()) {
            return;
        }
        if (request.getAttribute(ATTRIBUTE_TRIGGER_EVENT_SENT) != null) {
            return;
        }
        if (this.connection == null) {
            this.logDebug("WARNING: HTTP request trigger is enabled but trigger is not initialized. It can be because acceptor not yet restarted or some error on acceptor start occurred. Please check trace log.");
            return;
        }
        if (operationType == null) {
            operationType = (OperationType)((Object)request.getAttribute(ATTRIBUTE_OPERATION_TYPE));
        }
        if (operationType == null) {
            operationType = this.resolveOperationType(operationType, request);
        }
        if (operationType == null) {
            return;
        }
        if (component == null) {
            component = (String)request.getAttribute(ATTRIBUTE_COMPONENT_NAME);
        }
        HTTPRequest httpRequestData = new HTTPRequest();
        httpRequestData.setMethod(this.getMethod(request));
        httpRequestData.setUri(this.getUri(request));
        if (this.includeQuery.booleanValue()) {
            httpRequestData.setQueryParameters(this.getQueryParameters(request));
        }
        if (this.includeHeaders.booleanValue()) {
            httpRequestData.setHeaders(this.getHeaders(request));
        }
        httpRequestData.setData((byte[])request.getAttribute(ATTRIBUTE_POST_REQUEST_CONTENT));
        if (Trace.isDebugEnabled(this.getClass())) {
            this.logDebug("Http triggering request operation type " + String.valueOf((Object)operationType) + ", request " + httpRequestData.toString());
        }
        try {
            DataEvent event = (DataEvent)EventDatagramFactory.getInstance().createEvent(HTTP_REQUEST_EVENT_ID);
            event.setData(httpRequestData);
            event.setEventStringProperty(ACCEPTOR_PROPERTY, this.configuration.getName());
            event.setEventStringProperty(NODE_PROPERTY, this.context.getName());
            event.setEventStringProperty(OPERATION_TYPE_PROPERTY, operationType.toString());
            event.setEventStringProperty(COMPONENT_PROPERTY, component != null ? component : "");
            event.setEventStringProperty(USER_NAME, request.getRemoteUser() != null ? request.getRemoteUser() : (request.getAttribute(HTTPCredentials.ATTRIBUTE) != null ? ((HTTPCredentials)request.getAttribute(HTTPCredentials.ATTRIBUTE)).getUserName() : ""));
            event.setEventStringProperty(USER_IP_ADDRESS, request.getRemoteAddr() != null ? request.getRemoteAddr() : "");
            event.setEventStringProperty(AUTHENTICATION_TYPE, this.configuration.getAuthenticationType() != null ? this.configuration.getAuthenticationType().toString() : "");
            long requestTimestamp = ((Request)request).getTimeStamp();
            event.setEventLongProperty(REQUEST_TIMESTAMP, requestTimestamp);
            if (this.includeStats.booleanValue()) {
                event.setEventLongProperty(REQUEST_LATENCY, System.currentTimeMillis() - requestTimestamp);
            }
            HttpSession session = request.getSession(false);
            String sessionId = NO_SESSION;
            long sessionRequestsCount = 0L;
            if (session != null) {
                sessionId = session.getId();
                AtomicLong count = (AtomicLong)session.getAttribute(ATTRIBUTE_SESSION_REQUESTS_COUNT);
                if (count != null) {
                    sessionRequestsCount = count.incrementAndGet();
                }
            }
            event.setEventStringProperty(SESSION_ID, sessionId);
            event.setEventLongProperty(SESSION_REQUESTS_COUNT, sessionRequestsCount);
            if (this.eventsQueue.offer(event)) {
                request.setAttribute(ATTRIBUTE_TRIGGER_EVENT_SENT, true);
            } else {
                this.logError("Failed to add http trigger event, events queue is full. Capacity: " + this.eventQueueCapacity);
            }
        }
        catch (Exception exception) {
            this.logError("Failed to create and fill event [event.http.Request]. Cause: " + exception.getMessage());
        }
    }

    private OperationType resolveOperationType(OperationType operationType, HttpServletRequest request) {
        Object uri = request.getRequestURI();
        if (uri == null) {
            return null;
        }
        if (!((String)uri).startsWith("/")) {
            uri = "/" + (String)uri;
        }
        operationType = ((String)uri).startsWith("/security") ? OperationType.SECURITY : (((String)uri).startsWith("/fabric") ? OperationType.FABRIC : (((String)uri).startsWith("/exchange") ? OperationType.EXCHANGE : (((String)uri).startsWith("/repository") ? OperationType.REPOSITORY : (((String)uri).startsWith("/sor") ? OperationType.SOR : (((String)uri).startsWith("/service") ? OperationType.SERVICE : (((String)uri).startsWith("/ds") ? OperationType.DATASPACE : (((String)uri).startsWith("/odata/v4") ? OperationType.ODATA : OperationType.OTHER)))))));
        return operationType;
    }

    private String getMethod(HttpServletRequest request) {
        Object method = request.getAttribute("API_CUSTOMIZER_ORIGINAL_METHOD");
        if (method == null) {
            method = request.getMethod();
        }
        return (String)method;
    }

    private String getUri(HttpServletRequest request) {
        Object uri = request.getAttribute("API_CUSTOMIZER_ORIGINAL_URI");
        if (uri != null) {
            return ((HttpURI)uri).getCompletePath();
        }
        return request.getRequestURI();
    }

    private Map<String, String> getQueryParameters(HttpServletRequest request) {
        Map<String, String[]> parameters = request.getAttribute("API_CUSTOMIZER_ORIGINAL_QUERY_PARAMETERS");
        if (parameters == null) {
            parameters = request.getParameterMap();
        }
        Map parametersMap = parameters;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (parametersMap != null) {
            for (Object key : parametersMap.keySet()) {
                String[] value = parameters.get(key);
                if (value == null || !(value instanceof Object[])) continue;
                if (((Object[])value).length > 0) {
                    resultMap.put((String)key, (String)((Object[])value)[0]);
                    continue;
                }
                resultMap.put((String)key, "");
            }
        }
        return resultMap;
    }

    private Map<String, String> getHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = null;
        Enumeration<String> headersEnumeration = request.getHeaderNames();
        while (headersEnumeration.hasMoreElements()) {
            String headerName = headersEnumeration.nextElement();
            String headerValue = request.getHeader(headerName);
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    public static String makeComponentName(String nodeName, String componentName) {
        if (nodeName != null) {
            componentName = nodeName + "." + (String)componentName;
        }
        return componentName;
    }

    private void logDebug(String message) {
        this.log(Trace.Level.DEBUG, message);
    }

    private void logError(String message) {
        this.log(Trace.Level.ERROR, message);
    }

    private void log(Trace.Level level, String message) {
        if (Trace.isEnabled(this.getClass(), level)) {
            message = "[HTTPAcceptor." + this.configuration.getName() + "] " + (String)message;
            switch (level) {
                case DEBUG: {
                    Trace.logDebug(this, (String)message);
                    break;
                }
                case ERROR: {
                    Trace.logError(this, (String)message);
                    break;
                }
                case INFO: {
                    Trace.logInfo(this, (String)message);
                    break;
                }
            }
        }
    }

    private class EventRaiser
    implements Runnable {
        private EventRaiser() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        DataEvent event;
                        if ((event = HTTPRequestTrigger.this.eventsQueue.take()) == null) {
                            continue;
                        }
                        try {
                            if (HTTPRequestTrigger.this.connection == null) continue block4;
                            HTTPRequestTrigger.this.connection.raiseEvent(event, EventScope.INHERITED, 0L);
                            continue block4;
                        }
                        catch (Exception exception) {
                            HTTPRequestTrigger.this.logError("Failed to raise http trigger event. Cause: " + exception.getMessage());
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    HTTPRequestTrigger.this.logDebug("HTTP:RequestTriggerRaiser_" + HTTPRequestTrigger.this.configuration.getName() + " thread interrupted.");
                    return;
                }
            }
        }
    }

    public static enum OperationType {
        DATASPACE,
        SERVICE,
        FABRIC,
        EXCHANGE,
        REPOSITORY,
        AUTH_FAILED,
        SOR,
        SECURITY,
        ODATA,
        OTHER;

    }
}

