/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProvider;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.network.http.server.utils.MultipartFormDataHelper;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorFactory;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.transports.TransportFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.URIUtil;

public class DirectoryHandler
extends HandlerWrapper {
    private RuntimeContext context;
    private HTTPAcceptorConfiguration configuration;
    private String htmlDirectory;
    private MimeTypes mimeTypes = new MimeTypes();

    public void init(RuntimeContext context, HTTPAcceptorConfiguration configuration, String htmlDirectory) {
        this.context = context;
        this.configuration = configuration;
        this.htmlDirectory = htmlDirectory;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (baseRequest.isHandled()) {
            return;
        }
        String realPath = this.getRealPath(target);
        if (realPath == null) {
            return;
        }
        baseRequest.setHandled(true);
        boolean skipContent = false;
        if (HttpMethod.POST.is(request.getMethod())) {
            this.handleUpload(realPath, request, response);
            if (response.isCommitted()) {
                return;
            }
        } else if (HttpMethod.HEAD.is(request.getMethod())) {
            skipContent = true;
        } else if (!HttpMethod.GET.is(request.getMethod())) {
            super.handle(target, baseRequest, request, response);
            return;
        }
        this.handleGet(realPath, request, response, skipContent);
    }

    private void handleGet(String path, HttpServletRequest request, HttpServletResponse response, boolean skipContent) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            if (!file.canRead()) {
                response.sendError(403);
                return;
            }
            if (file.isDirectory()) {
                this.handleGetDirecotry(request, response, path);
            } else {
                this.handlerGetFile(request, response, file, skipContent);
            }
        } else {
            response.sendError(404);
        }
    }

    private void handleGetDirecotry(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        if (!request.getPathInfo().endsWith("/")) {
            String newPath = URIUtil.addPaths((String)request.getRequestURI(), (String)"/");
            response.sendRedirect(response.encodeRedirectURL(newPath));
            return;
        }
        File directory = new File(path);
        boolean isUploadFormNeeded = this.isUploadFormNeeded(request);
        Object[] names = directory.list();
        if (names == null) {
            response.sendError(403, "Can't access " + request.getRequestURI());
            return;
        }
        String title = "Index of " + (path.length() == 0 ? "." : (new File(path).isAbsolute() ? new File(path).getCanonicalPath() : HTTPUtils.canonicalizePath(path)));
        StringBuilder builder = new StringBuilder();
        builder.append("<head>");
        if (isUploadFormNeeded) {
            builder.append(this.getUploadFormStyle()).append("\n");
        }
        builder.append("</head><body><br>\n");
        builder.append("<h2>").append(title).append("</h2>\n");
        builder.append("<pre>\n");
        builder.append("Mode         Bytes    Last Changed    Name\n");
        builder.append("<hr>\n");
        Arrays.sort(names);
        for (int i = 0; i < names.length; ++i) {
            File file = new File(directory, (String)names[i]);
            String fileType = file.isDirectory() ? "d" : (file.isFile() ? "-" : "?");
            String fileRead = file.canRead() ? "r" : "-";
            String fileWrite = file.canWrite() ? "w" : "-";
            String fileExec = file.canExecute() ? "x" : "-";
            String fileSize = this.addSpaces(new DecimalFormat("#").format(file.length()), 12);
            String fileDate = this.addSpaces(HTTPUtils.lsDateStr(new Date(file.lastModified())), 14);
            String fileDirsuf = file.isDirectory() ? "/" : "";
            String fileSuf = file.isDirectory() ? "/" : "";
            builder.append(fileType + fileRead + fileWrite + fileExec + "  " + fileSize + "  " + fileDate + "    <a href=\"" + HTTPUtils.encodeString((String)names[i]) + fileDirsuf + "\">" + (String)names[i] + fileSuf + "</a>\n");
        }
        builder.append("<br>Total Entries: " + names.length).append("\n");
        builder.append("</pre>\n");
        if (isUploadFormNeeded) {
            builder.append(this.getUploadForm()).append("\n");
        }
        response.setStatus(200);
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter().println(SorServletCss.makeFullHtml(title, builder.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handlerGetFile(HttpServletRequest request, HttpServletResponse response, File file, boolean skipContent) throws IOException {
        long ifModified;
        try {
            file.getCanonicalPath();
        }
        catch (Exception e) {
            response.sendError(403, "Forbidden, exception:" + String.valueOf(e));
            return;
        }
        long lastModified = file.lastModified();
        if (lastModified > 0L && (ifModified = request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString())) > 0L && lastModified / 1000L <= ifModified / 1000L) {
            response.setStatus(304);
            return;
        }
        String contentType = this.getContentType(request, file);
        if (contentType != null) {
            response.setContentType(contentType);
        }
        boolean doCompress = false;
        if (this.configuration.getCompressResponse() && contentType != null && contentType.startsWith("text") && HTTPUtils.isGzipAccepted(request.getHeader("Accept-Encoding")) > 0.0f) {
            response.setHeader("Content-Encoding", "gzip");
            doCompress = true;
        }
        if (!doCompress || skipContent) {
            long fileLength = file.length();
            if (fileLength < Integer.MAX_VALUE) {
                response.setContentLength((int)fileLength);
            } else {
                response.setHeader("Content-Length", Long.toString(fileLength));
            }
        }
        response.setStatus(200);
        if (skipContent) {
            return;
        }
        InputStream input = null;
        OutputStream output = doCompress ? new GZIPOutputStream(response.getOutputStream()) : response.getOutputStream();
        int tfcacheIndex = file.getPath().indexOf(".tfcache");
        try {
            if (tfcacheIndex != -1) {
                SemanticObjectReferenceStore.beginXact();
                tfcacheIndex = file.getPath().indexOf(File.separatorChar, tfcacheIndex);
                String pathInTFCache = file.getPath().substring(tfcacheIndex);
                pathInTFCache = pathInTFCache.replaceAll("\\" + File.separatorChar, "/");
                input = new URL("tfcache://" + pathInTFCache).openStream();
            } else {
                input = new FileInputStream(file);
            }
            HTTPUtils.copyStream(input, output);
        }
        catch (Throwable error) {
            try {
                if (tfcacheIndex == -1) throw new IOException(error.toString());
                SemanticObjectReferenceStore.abortXactSafe();
                tfcacheIndex = -1;
                throw new IOException(error.toString());
            }
            catch (Throwable throwable) {
                try {
                    if (tfcacheIndex != -1) {
                        SemanticObjectReferenceStore.commitXact();
                    }
                }
                catch (Exception criticalError) {
                    Trace.logError((Object)this, "Can't end TFCache transaction: " + String.valueOf(criticalError));
                }
                if (input != null) {
                    ((InputStream)input).close();
                }
                if (!doCompress) throw throwable;
                ((GZIPOutputStream)output).finish();
                throw throwable;
            }
        }
        try {
            if (tfcacheIndex != -1) {
                SemanticObjectReferenceStore.commitXact();
            }
        }
        catch (Exception criticalError) {
            Trace.logError((Object)this, "Can't end TFCache transaction: " + String.valueOf(criticalError));
        }
        if (input != null) {
            ((InputStream)input).close();
        }
        if (!doCompress) return;
        ((GZIPOutputStream)output).finish();
    }

    private void handleUpload(String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<FileItem> items;
        try {
            items = MultipartFormDataHelper.getOrParseMultiParts(request, this.configuration, 1);
        }
        catch (Exception exception) {
            response.sendError(400, "Failed to parse post request. Cause: " + exception.getMessage());
            return;
        }
        for (FileItem item : items) {
            int tfcacheIndex;
            if (item.isFormField()) continue;
            path = HTTPUtils.canonicalizePath((String)path);
            path = ((String)path).replace('/', File.separatorChar);
            path = (String)path + item.getName();
            File file = new File((String)path);
            File oldFile = null;
            if (file.exists()) {
                oldFile = new File((String)path + ".old");
                if (oldFile.exists()) {
                    oldFile.delete();
                }
                if (!this.isAcceptorUri(request.getRequestURI())) {
                    try {
                        FileIOUtils.copy(file, oldFile);
                    }
                    catch (Exception e) {
                        Trace.logDebug((Object)this, "Copying file to " + item.getName() + ".old failed");
                    }
                }
            }
            if ((tfcacheIndex = ((String)path).indexOf(".tfcache")) != -1) {
                this.processUploadToTFCache(request, response, item.getName(), item.get());
            } else {
                try {
                    item.write(new File((String)path));
                }
                catch (Exception exception) {
                    response.sendError(400, "Failed to uppload file '" + (String)path + "'. Cause: " + exception.getMessage());
                    return;
                }
            }
            if (response.isCommitted() || !oldFile.exists()) break;
            oldFile.delete();
            break;
        }
    }

    private String getContentType(HttpServletRequest request, File file) {
        Object mime = this.mimeTypes.getMimeByExtension(file.getName());
        if (mime == null) {
            mime = this.mimeTypes.getMimeByExtension(request.getPathInfo());
        }
        if (TraceConfigurator.getInstance().getLogFile() != null && file.getAbsolutePath().equals(TraceConfigurator.getInstance().getLogFile().getAbsolutePath())) {
            mime = "application/x-download";
        }
        String[] xmlEndings = new String[]{".sco", ".sdo", ".type"};
        String name = file.getName();
        for (String xmlEnding : xmlEndings) {
            if (!name.endsWith(xmlEnding)) continue;
            mime = "application/xhtml+xml";
            break;
        }
        if (mime != null && ((String)mime).indexOf(";charset=") == -1) {
            mime = (String)mime + "; charset=UTF-8";
        }
        return mime;
    }

    private String getRealPath(String path) {
        if (this.configuration.getUrlToPathAliases() != null) {
            int index = path.indexOf(47, 1);
            if (index == -1) {
                index = path.length();
            }
            Object realPath = this.configuration.getUrlToPathAliases().get(path.substring(1, index));
            path = path.substring(index);
            if (realPath != null) {
                if (!new File((String)(realPath = (String)realPath + path)).isAbsolute()) {
                    realPath = this.htmlDirectory + "/" + (String)realPath;
                }
                realPath = ((String)realPath).replace('/', File.separatorChar);
                return realPath;
            }
        }
        return null;
    }

    private boolean isUploadFormNeeded(HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (uri.startsWith("/repository")) {
            int index = "/repository".length() + 1;
            return uri.startsWith("clients", index) || uri.startsWith("jdbc", index) || uri.startsWith("services", index) || uri.startsWith("transports", index) || uri.startsWith("ext", index) || uri.startsWith("lib", index) || this.isAcceptorUri(uri);
        }
        return false;
    }

    private String getAcceptorType(String uri) {
        List<String> registeredFactories = this.context.getAcceptorManager().listRegisteredFactories();
        int dirIndex = uri.indexOf(47, 1) + 1;
        for (String registeredFactory : registeredFactories) {
            int l = registeredFactory.length() - "AcceptorFactory".length();
            String factoryType = l > 0 ? registeredFactory.substring(0, l).toLowerCase() : null;
            if (factoryType == null || !uri.startsWith("objects/sys/network/acceptors/" + factoryType, dirIndex)) continue;
            return factoryType;
        }
        return null;
    }

    private boolean isAcceptorUri(String uri) {
        return this.getAcceptorType(uri) != null;
    }

    protected void processUploadToTFCache(HttpServletRequest request, HttpServletResponse response, String fileName, byte[] fileData) throws IOException {
        block23: {
            HttpSession session = request.getSession();
            if (session == null) {
                response.sendError(403, "User not authorized or session expired.");
                return;
            }
            HTTPServerFabricConnection fabricConnection = FabricConnectionsProvider.getConnectionFromRequest(request);
            if (fabricConnection == null) {
                response.sendError(403, "User not authorized or session expired.");
            }
            Object dataObject = null;
            try {
                RepositoryAccessor accessor = fabricConnection.getRepositoryAccessor();
                String uri = request.getRequestURI();
                int dirIndex = uri.indexOf(47, 1) + 1;
                if (uri.startsWith("lib", dirIndex)) {
                    if (accessor.existsArchive(fileName)) {
                        accessor.removeArchive(fileName);
                    }
                    accessor.addArchive(fileName, fileData);
                    break block23;
                }
                if (uri.startsWith("ext", dirIndex)) {
                    if (accessor.existsExtensionArchive(fileName)) {
                        throw new ServletException("Extension archive '" + fileName + "' already exist and can not be overwritten.");
                    }
                    accessor.addExtensionArchive(fileName, fileData);
                    break block23;
                }
                dataObject = HTTPUtils.getXmlSerializer().deserialize(fileData);
                if (uri.startsWith("clients", dirIndex)) {
                    String type;
                    if (!(dataObject instanceof ClientFactory)) {
                        throw new ServletException("Wrong Client Factory file: " + fileName);
                    }
                    ClientFactory factory = (ClientFactory)dataObject;
                    String name = factory.getFactoryName();
                    if (accessor.existsClientFactory(name, type = factory.getFactoryType())) {
                        accessor.removeClientFactory(name, type);
                    }
                    accessor.saveClientFactory(factory);
                    break block23;
                }
                if (uri.startsWith("jdbc", dirIndex)) {
                    String type;
                    if (!(dataObject instanceof JDBCFactory)) {
                        throw new ServletException("Wrong JDBC Factory file: " + fileName);
                    }
                    JDBCFactory factory = (JDBCFactory)dataObject;
                    String name = factory.getFactoryName();
                    if (accessor.existsJDBCFactory(name, type = factory.getFactoryType())) {
                        accessor.removeJDBCFactory(name, type);
                    }
                    accessor.saveJDBCFactory(factory);
                    break block23;
                }
                if (uri.startsWith("transports", dirIndex)) {
                    String type;
                    if (!(dataObject instanceof TransportFactory)) {
                        throw new ServletException("Wrong Transport Factory file: " + fileName);
                    }
                    TransportFactory factory = (TransportFactory)dataObject;
                    String name = factory.getFactoryName();
                    if (accessor.existsTransportFactory(name, type = factory.getFactoryType())) {
                        accessor.removeTransportFactory(name, type);
                    }
                    accessor.saveTransportFactory(factory);
                    break block23;
                }
                if (uri.startsWith("services", dirIndex)) {
                    String type;
                    if (!(dataObject instanceof ServiceConfigurationObject)) {
                        throw new ServletException("Wrong Service Configuration file: " + fileName);
                    }
                    ServiceConfigurationObject sco = (ServiceConfigurationObject)dataObject;
                    String name = sco.getServiceName();
                    if (accessor.existsServiceConfiguration(name, type = sco.getServiceType())) {
                        accessor.removeServiceConfiguration(name, type);
                    }
                    accessor.saveServiceConfiguration(sco);
                    break block23;
                }
                if (this.isAcceptorUri(uri)) {
                    this.updateAcceptor(uri, dataObject);
                    break block23;
                }
                throw new ServletException("Upload is supported only for: Client Factory (/clients), JDBC Factory (/jdbc), Transport Factory (/transports) and Service Configuration (/services)");
            }
            catch (ServletException exception) {
                response.sendError(400, exception.getMessage());
            }
            catch (Exception exception) {
                if (dataObject == null) {
                    response.sendError(400, "XML deserialization failed for file: " + fileName);
                }
                response.sendError(500, exception.getMessage());
            }
        }
    }

    private void updateAcceptor(String uri, Object acceptorObject) throws ServletException {
        String acceptorType = this.getAcceptorType(uri);
        if (acceptorType == null) {
            throw new ServletException("Uri is not acceptor uri.");
        }
        if (!(acceptorObject instanceof Acceptor)) {
            throw new ServletException("Provided file is not acceptor.");
        }
        AcceptorFactory factory = this.context.getAcceptorManager().lookupFactory(acceptorType.toUpperCase() + "AcceptorFactory");
        if (factory == null) {
            throw new ServletException("Factory for acceptor type '" + acceptorType + "' doesn't exist.");
        }
        SemanticType acceptorSemanticType = this.context.getSemanticTypeCache().lookupSemanticClass(acceptorObject.getClass());
        if (acceptorSemanticType == null) {
            Trace.logError((Object)this, "Semantic type for provided acceptor '" + String.valueOf(acceptorObject.getClass()) + "' doesn't exist.");
            throw new ServletException("Invalid acceptor provided. Semantic type for provided acceptor doesn't exist.");
        }
        if (!factory.listSupportedModels().contains(acceptorSemanticType.getTypeName())) {
            throw new ServletException("Invalid acceptor provided. Acceptor model is not supported by factory " + factory.getName() + ".");
        }
        Acceptor acceptor = (Acceptor)acceptorObject;
        try {
            acceptor.init(this.context);
        }
        catch (Exception exception) {
            Trace.logError((Object)this, "Initialization of acceptor failed. Cause: " + exception.getMessage());
            throw new ServletException("Initialization of acceptor failed.");
        }
        Acceptor oldAcceptor = factory.lookupAcceptor(acceptor.getName());
        try {
            factory.saveAcceptor(acceptor);
        }
        catch (Exception exception) {
            String error = "Saving new acceptor failed. Cause: " + exception.getMessage();
            Trace.logError((Object)this, error);
            try {
                factory.saveAcceptor(oldAcceptor);
            }
            catch (Exception e) {
                Trace.logError((Object)this, "Restoring of old acceptor failed. Cause: " + e.getMessage());
            }
            throw new ServletException(error);
        }
    }

    private String addSpaces(String str, int length) {
        while (((String)str).length() < length) {
            str = " " + (String)str;
        }
        return str;
    }

    private String getUploadFormStyle() {
        return "<style type=\"text/css\">\n#FileUpload\n{\nposition:relative;\n}\n#BrowserVisible\n{\n    position: absolute;\n    top: 0px;\n    left: 0px;\n    z-index: 1;\n    height:20px;\n    width:340px;\n}\n#FileField\n{\n    width:260px;\n    height:20px;\n    border:solid 1px #000;\n}\n#BrowserHidden\n{\n    position:relative;\n    width:340px;\n    height:20px;\n   text-align: right;\n   -moz-opacity:0;\n    filter:alpha(opacity: 0);\n    opacity: 0;\n    z-index: 2;\n}\n</style>\n";
    }

    private String getUploadForm() {
        return "<hr>\n<h4>Configuration Artifact Upload</h4>\n<div id=\"FileUpload\">\n  <form method=\"post\" enctype=\"multipart/form-data\">\n    <table><tr>\n      <td><input type=\"file\" name=\"name\" id=\"BrowserHidden\" onchange=\"getElementById('FileField').value = getElementById('BrowserHidden').value;\"></td>\n      <td><input type=\"submit\" value=\"Upload\" class='" + SorServletCss.DEPLOY_BUTTON_STYLE + "'></td>\n    </tr></table>\n  </form>\n  <div id=\"BrowserVisible\">\n    <table><tr>\n      <td><input type=\"text\" id=\"FileField\"/></td><td>&nbsp;</td>\n      <td><input type=\"button\" value=\"Browse\"/ class='" + SorServletCss.DEPLOY_BUTTON_STYLE + "'></td>\n    </tr></table>\n  </div>\n</div>\n";
    }
}

