/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class CustomizedRequestLogHandler
extends HandlerWrapper {
    private RequestLog requestLog;
    private final AsyncListener listener = new AsyncListener(){

        @Override
        public void onTimeout(AsyncEvent event) throws IOException {
        }

        @Override
        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().addListener(this);
        }

        @Override
        public void onError(AsyncEvent event) throws IOException {
            HttpServletResponse response = (HttpServletResponse)event.getAsyncContext().getResponse();
            if (!response.isCommitted()) {
                response.setStatus(500);
            }
        }

        @Override
        public void onComplete(AsyncEvent event) throws IOException {
            AsyncContextState context = (AsyncContextState)event.getAsyncContext();
            Request request = context.getHttpChannelState().getBaseRequest();
            Response response = request.getResponse();
            CustomizedRequestLogHandler.this.uncustomizeRequest(request);
            CustomizedRequestLogHandler.this.requestLog.log(request, response);
        }
    };

    public CustomizedRequestLogHandler(NCSARequestLog requestLog) {
        this.updateBean(this.requestLog, requestLog);
        this.requestLog = requestLog;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            super.handle(target, baseRequest, request, response);
        }
        catch (IOException | Error | RuntimeException | ServletException e) {
            if (!response.isCommitted() && !baseRequest.getHttpChannelState().isAsync()) {
                response.setStatus(500);
            }
            throw e;
        }
        finally {
            if (this.requestLog != null && baseRequest.getDispatcherType().equals((Object)DispatcherType.REQUEST)) {
                if (baseRequest.getHttpChannelState().isAsync()) {
                    if (baseRequest.getHttpChannelState().isInitial()) {
                        baseRequest.getAsyncContext().addListener(this.listener);
                    }
                } else {
                    this.uncustomizeRequest(baseRequest);
                    this.requestLog.log(baseRequest, (Response)response);
                }
            }
        }
    }

    private void uncustomizeRequest(Request request) {
        Object uri;
        Object method = request.getAttribute("API_CUSTOMIZER_ORIGINAL_METHOD");
        if (method != null) {
            request.setMethod(HttpMethod.fromString((String)((String)method)), (String)method);
        }
        if ((uri = request.getAttribute("API_CUSTOMIZER_ORIGINAL_URI")) != null) {
            request.setUri((HttpURI)uri);
            request.setRequestURI(null);
        }
    }
}

