/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs.swagger;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.streamscape.sef.network.http.server.authentication.jaxrs.ApiKeySwaggerJaxrsBuilder;
import com.streamscape.sef.network.http.server.dropbox.DropBoxSwaggerJaxrsBuilder;
import com.streamscape.sef.network.http.server.jaxrs.swagger.SwaggerJaxrsBuilder;
import com.streamscape.sef.network.http.server.swagger.clientgen.SwaggerClientGenSwaggerJaxrsBuilder;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.File;
import java.nio.file.Paths;

public class SwaggerJaxrxBuilderMain {
    private String basePath;

    public SwaggerJaxrxBuilderMain(String basePath) {
        this.basePath = basePath;
    }

    private void buildAll() throws Exception {
        this.build(new DropBoxSwaggerJaxrsBuilder());
        this.build(new ApiKeySwaggerJaxrsBuilder());
        this.build(new SwaggerClientGenSwaggerJaxrsBuilder());
    }

    private void build(SwaggerJaxrsBuilder builder) throws Exception {
        try {
            Swagger swagger = builder.build();
            new File(this.getPath(builder)).mkdirs();
            this.save(Yaml.pretty(), builder, swagger, "yaml");
            this.save(Json.pretty(), builder, swagger, "json");
        }
        catch (Exception exception) {
            System.err.println("Failed to build swagger definition for '" + String.valueOf(builder.getClass()) + "'.");
            exception.printStackTrace(System.err);
            throw exception;
        }
    }

    private void save(ObjectWriter writer, SwaggerJaxrsBuilder builder, Swagger swagger, String type) throws Exception {
        try {
            File file = Paths.get(this.getPath(builder), "swagger." + type).toFile();
            System.out.println("Writing swagger " + type + " definition to " + file.getAbsolutePath());
            writer.writeValue(file, (Object)swagger);
        }
        catch (Exception exception) {
            System.err.println("Failed to build swagger " + type + " definition for '" + String.valueOf(builder.getClass()) + "'.");
            exception.printStackTrace(System.err);
            throw exception;
        }
    }

    private String getPath(SwaggerJaxrsBuilder builder) {
        String path = builder.getClass().getPackage().getName().replaceAll("\\.", "/");
        return Paths.get(this.basePath, path).toAbsolutePath().toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: builder <target base path>");
            return;
        }
        System.out.println("Generating swagger definitions and save them to '" + args[0] + "'...");
        new SwaggerJaxrxBuilderMain(args[0]).buildAll();
        System.out.println("Swagger definitions generated and saved.");
    }
}

