/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs.swagger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.jaxrs.swagger.SwaggerJaxrsBuilder;
import com.streamscape.sef.network.http.server.jaxrs.swagger.SwaggerParameterExtension;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import io.swagger.annotations.ApiOperation;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

public abstract class AbstractSwaggerResource {
    @Context
    private ServletContext context;

    @GET
    @Produces(value={"application/json", "application/yaml"})
    @ApiOperation(value="The swagger definition in either JSON or YAML", hidden=true)
    public Response get(@PathParam(value="type") String type) {
        return Response.ok().entity((Object)this.buildSwaggerContent(type)).type(type != null && type.trim().equalsIgnoreCase("yaml") ? "application/yml" : "application/json").build();
    }

    private String getAttributeName(String type) {
        return this.getClass().getName() + "." + type;
    }

    private String buildSwaggerContent(String type) {
        String content = (String)this.context.getAttribute(this.getAttributeName(type));
        if (content != null) {
            return content;
        }
        Swagger swagger = this.buildSwagger(type);
        try {
            ObjectWriter mapper = null;
            mapper = type != null && type.trim().equalsIgnoreCase("yaml") ? Yaml.pretty() : Json.pretty();
            content = mapper.writeValueAsString(swagger);
            this.context.setAttribute(this.getAttributeName(type), content);
            return content;
        }
        catch (JsonProcessingException exception) {
            throw new ProcessingException("Swagger serialization error.", (Throwable)exception);
        }
    }

    private Swagger buildSwagger(String type) {
        SwaggerJaxrsBuilder builder = this.getSwaggerJaxrsBuilder();
        builder.setAcceptorConfiguration((HTTPAcceptorConfiguration)this.context.getAttribute(HTTPAcceptorConfiguration.ATTRIBUTE));
        if (AbstractSwaggerResource.buildInRuntime()) {
            try {
                return builder.build();
            }
            catch (SwaggerBuilderException exception) {
                throw new ProcessingException("Swagger build error.", (Throwable)exception);
            }
        }
        String content = this.getSwaggerContent(type);
        ObjectReader mapper = type != null && type.trim().equalsIgnoreCase("yaml") ? Yaml.mapper().reader() : Json.mapper().reader();
        Swagger swagger = null;
        mapper = mapper.withType(Swagger.class);
        try {
            swagger = (Swagger)mapper.readValue(content);
        }
        catch (IOException exception) {
            throw new ProcessingException("Swagger deserialization error.", (Throwable)exception);
        }
        try {
            builder.init(swagger);
        }
        catch (SwaggerBuilderException exception) {
            Trace.logError(this, "Swagger initialization error.");
            Trace.logException(this, exception, true);
        }
        return swagger;
    }

    public static boolean buildInRuntime() {
        try {
            AbstractSwaggerResource.class.getClassLoader().loadClass("io.swagger.jaxrs.Reader");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String getSwaggerContent(String type) {
        Class<?> clazz = this.getSwaggerJaxrsBuilder().getClass();
        String swaggerFilename = clazz.getPackage().getName().replaceAll("\\.", "/") + "/swagger." + type;
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(swaggerFilename);
        if (inputStream == null) {
            throw new ProcessingException("Swagger resource '" + swaggerFilename + "' not found.");
        }
        try {
            return new String(FileIOUtils.getStreamContent(inputStream, -1L));
        }
        catch (UtilitiesException exception) {
            throw new ProcessingException("Failed to read swagger resource '" + swaggerFilename + "' not found.", (Throwable)exception);
        }
    }

    protected abstract SwaggerJaxrsBuilder getSwaggerJaxrsBuilder();

    static {
        if (AbstractSwaggerResource.buildInRuntime()) {
            ArrayList<SwaggerParameterExtension> extensions = new ArrayList<SwaggerParameterExtension>(SwaggerExtensions.getExtensions());
            extensions.add(0, new SwaggerParameterExtension());
            SwaggerExtensions.setExtensions(extensions);
        }
    }
}

