/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs.swagger;

import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.jaxrs.swagger.SwaggerJaxrsBuilder;
import com.streamscape.sef.network.http.server.swagger.AbstractSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import io.swagger.jaxrs.Reader;
import io.swagger.models.Swagger;
import java.util.Set;

public abstract class AbstractSwaggerJaxrsBuilder
implements SwaggerJaxrsBuilder {
    protected Swagger swagger;
    private HTTPAcceptorConfiguration acceptorConfiguration;

    @Override
    public void setAcceptorConfiguration(HTTPAcceptorConfiguration acceptorConfiguration) {
        this.acceptorConfiguration = acceptorConfiguration;
    }

    @Override
    public void init(final Swagger swagger) throws SwaggerBuilderException {
        try {
            AbstractSwaggerBuilder builder = new AbstractSwaggerBuilder("ui"){

                @Override
                public Swagger build() throws SwaggerBuilderException {
                    super.setHost(swagger);
                    super.setSecurity(swagger);
                    super.setInfo(swagger);
                    swagger.getInfo().title(AbstractSwaggerJaxrsBuilder.this.getTitle()).description(AbstractSwaggerJaxrsBuilder.this.getDescription());
                    swagger.setBasePath(AbstractSwaggerJaxrsBuilder.this.getBasePath());
                    swagger.setConsumes(null);
                    swagger.setProduces(null);
                    return swagger;
                }

                @Override
                public Swagger build(Swagger swagger2) throws SwaggerBuilderException {
                    return swagger2;
                }
            };
            builder.setAcceptorConfiguration(this.acceptorConfiguration);
            builder.build();
        }
        catch (Exception exception) {
            throw new SwaggerBuilderException("Failed to initialize swagger info for '" + this.getTitle() + "'.", exception);
        }
    }

    @Override
    public Swagger build() throws SwaggerBuilderException {
        this.swagger = new Swagger();
        this.init(this.swagger);
        try {
            if (this.swagger == null) {
                this.swagger = new Swagger();
            }
            return new Reader(this.swagger).read(this.getClasses());
        }
        catch (Exception exception) {
            throw new SwaggerBuilderException("Failed to build swagger info for '" + this.getTitle() + "'.", exception);
        }
    }

    protected abstract Set<Class<?>> getClasses();

    protected abstract String getBasePath();

    protected abstract String getDescription();

    protected abstract String getTitle();
}

