/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs.params;

import com.streamscape.sef.network.http.server.jaxrs.WsModel;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionContext;
import com.streamscape.sef.network.http.server.jaxrs.models.MethodModel;
import com.streamscape.sef.network.http.server.jaxrs.params.ParamProcessor;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;

public class ParametersInstantiator {
    private WsModel model;

    public ParametersInstantiator(WsModel model) {
        this.model = model;
    }

    public Object[] instantiate(MethodModel methodModel, InjectionContext context) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (ParamProcessor processor : methodModel.getParameterProcessors()) {
            Object value = processor.process(context);
            if (value != null) {
                if (value instanceof String && processor.getParamConverter() != null) {
                    processor.getParamConverter().fromString((String)value);
                } else if (!processor.getParameter().getType().isAssignableFrom(value.getClass())) {
                    try {
                        Instantiator primitiveInstantiator = this.getPrimitiveInstantiator(processor.getParameter().getType());
                        value = primitiveInstantiator != null ? primitiveInstantiator.instantiate((String)value) : this.serializeValue(processor.getParameter(), (String)value, context);
                    }
                    catch (Exception exception) {
                        throw new BadRequestException("Conversion of parameter '" + processor.getName() + "' failed.", (Throwable)exception);
                    }
                }
            }
            parameters.add(value);
        }
        return parameters.toArray();
    }

    private Object serializeValue(Parameter parameter, String value, InjectionContext context) throws IOException {
        MediaType mediaType = MediaType.valueOf((String)context.get(FabricHTTPRequest.class).getRequest().getHeader("Content-Type"));
        MessageBodyReader reader = this.model.getMessageBodyReader(parameter.getType(), parameter.getType().getGenericSuperclass(), parameter.getAnnotations(), mediaType);
        if (reader == null && "x-www-form-urlencoded".equals(mediaType.getSubtype())) {
            mediaType = MediaType.APPLICATION_JSON_TYPE;
            reader = this.model.getMessageBodyReader(parameter.getType(), parameter.getType().getGenericSuperclass(), parameter.getAnnotations(), mediaType);
        }
        if (reader == null) {
            throw new ProcessingException("Cannot find reader for parameter type " + String.valueOf(parameter.getType()) + " and media type " + String.valueOf(mediaType) + ".");
        }
        return reader.readFrom(parameter.getType(), parameter.getType().getGenericSuperclass(), parameter.getAnnotations(), mediaType, context.get(HttpHeaders.class).getRequestHeaders(), (InputStream)new ByteArrayInputStream(value.getBytes()));
    }

    private Instantiator getPrimitiveInstantiator(Class<?> type) {
        if (type == Integer.TYPE || type == Integer.class) {
            return value -> Integer.valueOf(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return value -> Boolean.valueOf(value);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return value -> Byte.valueOf(value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return value -> Short.valueOf(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return value -> Long.valueOf(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return value -> Float.valueOf(value);
        }
        if (type == Double.TYPE || type == Double.class) {
            return value -> Double.valueOf(value);
        }
        if (type.isEnum()) {
            return value -> {
                if (value == null) {
                    return null;
                }
                try {
                    return Enum.valueOf(type, value);
                }
                catch (Exception exception) {
                    throw new ProcessingException("Cannot convert value '" + value + "' to enum '" + String.valueOf(type) + "'.");
                }
            };
        }
        return null;
    }

    static interface Instantiator {
        public Object instantiate(String var1);
    }
}

