/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs.injection;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.authentication.RuntimeAuthenticator;
import com.streamscape.sef.network.http.server.jaxrs.injection.AbstractServiceInjectionResolver;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionContext;
import com.streamscape.sef.network.http.server.jaxrs.injection.WsContextInjectionResolver;
import com.streamscape.sef.network.http.server.servlet.AbstractServlet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Provider
public class ServiceInjectionResolver
extends AbstractServiceInjectionResolver {
    private static final Set<Class<?>> types = new HashSet<Class>(Arrays.asList(RuntimeContext.class, FabricConnection.class, RuntimeAuthenticator.class));

    @Override
    public Set<Class<?>> getInjectedTypes() {
        return new HashSet(types);
    }

    @Override
    public <T> T resolve(Class<T> type, InjectionContext context) {
        Object result = null;
        if (type == RuntimeContext.class) {
            result = RuntimeContext.getInstance();
        } else if (type == FabricConnection.class) {
            try {
                result = AbstractServlet.getFabricConnectionOrThrowException(new WsContextInjectionResolver().resolve(HttpServletRequest.class, context));
            }
            catch (Exception exception) {
                throw new NotAuthorizedException("Failed to inject FabricConnection for unauthorized request.", (Object)exception, new Object[0]);
            }
        } else if (type == RuntimeAuthenticator.class) {
            ServletContext servletContext = this.resolve(Context.class, ServletContext.class, context);
            result = servletContext.getAttribute(RuntimeAuthenticator.ATTRIBUTE);
        }
        return (T)result;
    }
}

