/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs.injection;

import com.streamscape.sef.network.http.server.jaxrs.injection.AbstractInjectionResolver;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionResolver;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class InjectionResolvers {
    private List<InjectionResolver> resolvers = new ArrayList<InjectionResolver>();

    public void register(InjectionResolver resolver) {
        ((AbstractInjectionResolver)resolver).injectionResolvers = this;
        this.resolvers.add(resolver);
    }

    public InjectionResolver lookup(Class<?> annotationType, Class<?> type) {
        return this.resolvers.stream().filter(p -> p.getAnnotationType() == annotationType && p.getInjectedTypes().contains(type)).findFirst().orElse(null);
    }

    public List<InjectionResolver> lookup(Class<? extends Annotation> annotationType) {
        return this.resolvers.stream().filter(p -> p.getAnnotationType() == annotationType).collect(Collectors.toList());
    }

    public boolean isRegistered(Class<?> injectionResolverClass) {
        return this.resolvers.stream().filter(p -> p.getClass() == injectionResolverClass).findAny().isPresent();
    }
}

