/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs.injection;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectedField;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionClassModel;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionException;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionResolver;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionResolvers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;

public class InjectionClassModelBuilder {
    private InjectionResolvers injectionResolvers;

    public InjectionClassModelBuilder(InjectionResolvers injectionResolvers) {
        this.injectionResolvers = injectionResolvers;
    }

    public InjectionClassModel build(Class<?> clazz) {
        InjectionClassModel model = new InjectionClassModel(clazz);
        for (Field field : ClassUtils.getAllFields(clazz)) {
            for (Annotation annotation : field.getAnnotations()) {
                InjectionResolver injectionResolver = this.injectionResolvers.lookup(annotation.annotationType(), field.getType());
                if (injectionResolver != null) {
                    field.setAccessible(true);
                    model.addInjectedField(new InjectedField(field, injectionResolver));
                    continue;
                }
                if (this.injectionResolvers.lookup(annotation.annotationType()).size() <= 0) continue;
                throw new InjectionException("Unsupported type '" + String.valueOf(field.getType()) + "' for injection annotation '" + String.valueOf(annotation.annotationType()) + "'.");
            }
        }
        for (Method method : ClassUtils.getAllMethods(clazz)) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (method.getParameterCount() > 0) {
                throw new InjectionException("PostContract method '" + String.valueOf(method) + "' has non empty parameters lists.");
            }
            model.addPostConstructMethod(method);
        }
        return model;
    }
}

