/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs.exception;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.jaxrs.exception.AbstractExceptionMapper;
import com.streamscape.sef.network.http.server.jaxrs.exception.DefaultToStringThrowableMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public class ExceptionMappersChain
implements ExceptionMapper {
    private List<ExceptionMapper> chain = new ArrayList<ExceptionMapper>();
    private ExceptionMapper<Throwable> defaultMapper = new DefaultToStringThrowableMapper();

    public void add(ExceptionMapper mapper) {
        this.chain.add(mapper);
    }

    public Response toResponse(Throwable exception) {
        final Class clazz = exception != null ? exception.getClass() : Throwable.class;
        ArrayList sortedChain = (ArrayList)this.chain.stream().filter(m -> this.getException(m.getClass()).isAssignableFrom(clazz)).collect(Collectors.toList());
        sortedChain.sort(new Comparator<ExceptionMapper>(){

            @Override
            public int compare(ExceptionMapper o1, ExceptionMapper o2) {
                int d2;
                Class<?> e2;
                Class<?> e1 = ExceptionMappersChain.this.getException(o1.getClass());
                if (e1 == (e2 = ExceptionMappersChain.this.getException(o2.getClass()))) {
                    return 0;
                }
                if (e1 == null) {
                    return 1;
                }
                if (e2 == null) {
                    return -1;
                }
                int d1 = this.distance(e1, clazz);
                return d1 < (d2 = this.distance(e2, clazz)) ? -1 : (d1 > d2 ? 1 : 0);
            }

            private int distance(Class<?> e1, Class<?> clazz2) {
                int distance = 0;
                while (clazz2 != e1 && clazz2 != Throwable.class) {
                    ++distance;
                    clazz2 = clazz2.getSuperclass();
                }
                return distance;
            }
        });
        try {
            for (ExceptionMapper mapper : sortedChain) {
                Response response = mapper.toResponse(exception);
                if (response == null) continue;
                return response;
            }
        }
        catch (Exception e) {
            Trace.logException(this, e, true);
        }
        return this.defaultMapper.toResponse(exception);
    }

    private Class<?> getException(Class<?> clazz) {
        ParameterizedType itype;
        Type superclass = clazz.getGenericSuperclass();
        if (superclass != null && superclass instanceof ParameterizedType && ((itype = (ParameterizedType)superclass).getRawType() == AbstractExceptionMapper.class || itype.getRawType() == ExceptionMapper.class)) {
            return (Class)itype.getActualTypeArguments()[0];
        }
        for (Type i : clazz.getGenericInterfaces()) {
            Class<?> result;
            ParameterizedType itype2;
            if (i instanceof ParameterizedType && ((itype2 = (ParameterizedType)superclass).getRawType() == AbstractExceptionMapper.class || itype2.getRawType() == ExceptionMapper.class)) {
                return (Class)itype2.getActualTypeArguments()[0];
            }
            if (!(i instanceof Class) || (result = this.getException((Class)i)) == null) continue;
            return result;
        }
        return null;
    }
}

