/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.jaxrs.ContainerRequestContextImpl;
import com.streamscape.sef.network.http.server.jaxrs.HttpHeadersImpl;
import com.streamscape.sef.network.http.server.jaxrs.ResponseWriter;
import com.streamscape.sef.network.http.server.jaxrs.UriInfoImpl;
import com.streamscape.sef.network.http.server.jaxrs.WsModel;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionContext;
import com.streamscape.sef.network.http.server.jaxrs.models.AbstarctResourceMethodModel;
import com.streamscape.sef.network.http.server.jaxrs.models.MethodModel;
import com.streamscape.sef.network.http.server.jaxrs.models.NameBindingModel;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;

public class WsServletContainer
extends HttpServlet {
    private WsModel model;
    private ResponseWriter responseWriter;

    public WsServletContainer(WsModel model) {
        this.model = model;
        this.responseWriter = new ResponseWriter(model);
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        FabricHTTPRequest url = new FabricHTTPRequest(req);
        InjectionContext injectionContext = this.createInjectionContext(url, resp);
        Response response = null;
        try {
            this.applyGlobalContainerRequestFilters(url);
            MethodModel methodModel = this.matchMethodModel(url);
            injectionContext.put(MethodModel.class, methodModel);
            injectionContext.put(ExceptionMapper.class, this.model.getExceptionMapper());
            this.applyNameBindings(url, methodModel.getResourceModel(), injectionContext);
            this.applyNameBindings(url, methodModel, injectionContext);
            response = this.invokeResourceMethod(methodModel, injectionContext);
        }
        catch (Throwable exception) {
            response = this.model.getExceptionMapper().toResponse(exception);
        }
        try {
            this.responseWriter.write(injectionContext, response);
        }
        catch (Throwable exception) {
            try {
                this.responseWriter.write(injectionContext, this.model.getExceptionMapper().toResponse(exception));
            }
            catch (Throwable exception1) {
                try {
                    this.responseWriter.write(injectionContext, this.model.getExceptionMapper().toResponse(exception1));
                }
                catch (Throwable exception2) {
                    Trace.logException(this, exception2, true);
                    if (exception2 instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new ServletException(exception2);
                }
            }
        }
    }

    private MethodModel matchMethodModel(FabricHTTPRequest url) {
        return this.model.lookup(url);
    }

    private void applyGlobalContainerRequestFilters(FabricHTTPRequest url) throws IOException {
        for (ContainerRequestFilter filter : this.model.getGlobalContainerRequestFilters()) {
            this.executeContainerRequestFilter(url, filter);
        }
    }

    private void applyNameBindings(FabricHTTPRequest url, AbstarctResourceMethodModel resourceMethodModel, InjectionContext injectionContext) throws IOException {
        for (NameBindingModel nameBindingModel : resourceMethodModel.getNameBindingModels()) {
            ContainerRequestFilter filter = (ContainerRequestFilter)this.model.createInjectionInstantiator().instantiate(nameBindingModel.getProviderInjectionClassModel(), injectionContext);
            this.executeContainerRequestFilter(url, filter);
        }
    }

    private void executeContainerRequestFilter(FabricHTTPRequest url, ContainerRequestFilter filter) throws IOException {
        filter.filter((ContainerRequestContext)new ContainerRequestContextImpl(url));
    }

    private Response invokeResourceMethod(MethodModel methodModel, InjectionContext injectionContext) throws Throwable {
        return this.model.createResourceInvoker().invoke(methodModel, injectionContext);
    }

    private InjectionContext createInjectionContext(FabricHTTPRequest url, HttpServletResponse resp) {
        InjectionContext injectionContext = this.model.createInjectionContext();
        injectionContext.put(HttpServlet.class, this);
        injectionContext.put(url.getClass(), url);
        injectionContext.put(HttpServletRequest.class, url.getRequest());
        injectionContext.put(HttpServletResponse.class, resp);
        injectionContext.put(ServletConfig.class, this.getServletConfig());
        injectionContext.put(ServletContext.class, this.getServletContext());
        injectionContext.put(HttpHeaders.class, new HttpHeadersImpl(url));
        injectionContext.put(UriInfo.class, new UriInfoImpl(url));
        return injectionContext;
    }
}

