/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs;

import com.streamscape.lib.reflection.ReflectionProvider;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.apicustomizer.UriMatcher;
import com.streamscape.sef.network.http.server.jaxrs.MediaTypeParser;
import com.streamscape.sef.network.http.server.jaxrs.ResourceInstantiator;
import com.streamscape.sef.network.http.server.jaxrs.ResourceInvoker;
import com.streamscape.sef.network.http.server.jaxrs.WsConfig;
import com.streamscape.sef.network.http.server.jaxrs.WsResourceException;
import com.streamscape.sef.network.http.server.jaxrs.exception.ExceptionMappersChain;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionClassModel;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionClassModelBuilder;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionContext;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionContextConfigurator;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionContextImpl;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionException;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionInstantiator;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionParamProcessor;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionResolver;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionResolvers;
import com.streamscape.sef.network.http.server.jaxrs.injection.WsContextInjectionResolver;
import com.streamscape.sef.network.http.server.jaxrs.models.AbstarctResourceMethodModel;
import com.streamscape.sef.network.http.server.jaxrs.models.MethodModel;
import com.streamscape.sef.network.http.server.jaxrs.models.NameBindingModel;
import com.streamscape.sef.network.http.server.jaxrs.models.PathModel;
import com.streamscape.sef.network.http.server.jaxrs.models.ResourceModel;
import com.streamscape.sef.network.http.server.jaxrs.params.ParamProcessor;
import com.streamscape.sef.network.http.server.jaxrs.params.ParametersInstantiator;
import com.streamscape.sef.network.http.server.uri.UriRegistry;
import com.streamscape.sef.network.http.server.uri.UriTree;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.eclipse.jetty.http.HttpMethod;

public class WsModel
extends Application {
    private WsConfig config;
    private UriRegistry<PathModel> registry;
    private ExceptionMappersChain exceptionMappersChain = new ExceptionMappersChain();
    private List<MessageBodyReader> messageBodyReaders = new ArrayList<MessageBodyReader>();
    private List<MessageBodyWriter> messageBodyWriters = new ArrayList<MessageBodyWriter>();
    private InjectionResolvers injectionResolvers = new InjectionResolvers();
    private List<ContainerRequestFilter> globalContainerRequestFilters = new ArrayList<ContainerRequestFilter>();
    private List<NameBindingModel> nameBindingsModels = new ArrayList<NameBindingModel>();
    private InjectionContextConfigurator injectionContextConfigurator;
    private static Set<Class<?>> methodAnnotations = new HashSet<Class>(Arrays.asList(POST.class, GET.class, DELETE.class, HEAD.class, OPTIONS.class, PUT.class));

    public void init(WsConfig config) {
        this.config = config;
        this.registry = new UriRegistry();
        this.injectionResolvers.register(new WsContextInjectionResolver());
        this.initNameBindings();
        this.initProviders();
        this.initResources();
    }

    private void initResources() {
        for (Class<?> resourceClass : this.config.resourceClasses) {
            ResourceModel resourceModel = new ResourceModel();
            resourceModel.setPath(this.getPath(resourceClass.getAnnotation(Path.class)));
            this.configureCommonAnnotations(resourceModel, resourceClass);
            InjectionClassModel injectionClassModel = new InjectionClassModelBuilder(this.injectionResolvers).build(resourceClass);
            resourceModel.setInjectionClassModel(injectionClassModel);
            for (Method method : resourceClass.getMethods()) {
                Set<HttpMethod> httpMethods = this.getHttpMethods(method);
                if (httpMethods.size() == 0) continue;
                method.setAccessible(true);
                MethodModel methodModel = this.buildMethodModel(resourceModel, method);
                PathModel pathModel = this.registry.getData(methodModel.getMethodFullPath());
                if (pathModel == null) {
                    pathModel = new PathModel();
                    pathModel.setPath(methodModel.getMethodFullPath());
                    try {
                        this.registry.register(pathModel.getPath(), pathModel, false);
                    }
                    catch (UriTree.UriException exception) {
                        throw new WsResourceException("Failed to register method '" + String.valueOf(method) + "'.", exception);
                    }
                }
                for (HttpMethod httpMethod : httpMethods) {
                    pathModel.add(httpMethod, methodModel);
                }
            }
        }
    }

    private MethodModel buildMethodModel(ResourceModel resourceModel, Method method) {
        String methodPath = this.getPath(method.getAnnotation(Path.class));
        if (methodPath == null) {
            methodPath = "/";
        }
        MethodModel methodModel = new MethodModel();
        methodModel.setResourceModel(resourceModel);
        methodModel.setMethod(method);
        methodModel.setMethodPath(methodPath);
        this.configureCommonAnnotations(methodModel, method);
        ArrayList<ParamProcessor> parameterProcessors = new ArrayList<ParamProcessor>();
        for (Parameter parameter : method.getParameters()) {
            ArrayList<ParamProcessor> oneParameterProcessors = new ArrayList<ParamProcessor>();
            DefaultValue defaultValue = null;
            boolean encoded = false;
            for (Annotation annotation : parameter.getAnnotations()) {
                InjectionResolver injectionResolver;
                ParamProcessor processor = ParamProcessor.createProcessor(annotation);
                if (processor != null) {
                    oneParameterProcessors.add(processor);
                }
                if (annotation.annotationType() == DefaultValue.class) {
                    defaultValue = (DefaultValue)annotation;
                }
                if (annotation.annotationType() == Encoded.class) {
                    encoded = true;
                }
                if ((injectionResolver = this.injectionResolvers.lookup(annotation.annotationType(), parameter.getType())) != null) {
                    oneParameterProcessors.add(new InjectionParamProcessor(annotation, injectionResolver));
                    continue;
                }
                if (this.injectionResolvers.lookup(annotation.annotationType()).size() <= 0) continue;
                throw new InjectionException("Unsupported type '" + String.valueOf(parameter.getType()) + "' for injection annotation '" + String.valueOf(annotation.annotationType()) + "'.");
            }
            if (oneParameterProcessors.size() == 0) {
                oneParameterProcessors.add(ParamProcessor.createProcessor(null));
            }
            if (oneParameterProcessors.size() > 1) {
                throw new WsResourceException("Parameter '" + parameter.getName() + "' in method '" + String.valueOf(method) + "' already with more then one annotations '" + oneParameterProcessors.stream().map(p -> p.getAnnotation().annotationType().toString()).collect(Collectors.joining(",")) + "'.");
            }
            if (defaultValue != null) {
                ((ParamProcessor)oneParameterProcessors.get(0)).setDefaultValue(defaultValue.value());
            }
            ((ParamProcessor)oneParameterProcessors.get(0)).setEncoded(encoded);
            ((ParamProcessor)oneParameterProcessors.get(0)).setParameter(parameter);
            parameterProcessors.add((ParamProcessor)oneParameterProcessors.get(0));
        }
        methodModel.setParameterProcessors(parameterProcessors);
        return methodModel;
    }

    private void configureCommonAnnotations(AbstarctResourceMethodModel model, AnnotatedElement clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (this.config.nameBindingClasses.contains(annotation.annotationType())) {
                for (NameBindingModel nameBindingModel : this.getNameBindingsModels().stream().filter(m -> m.getAnnotation().annotationType() == annotation.annotationType()).collect(Collectors.toList())) {
                    model.addNameBindingModel(nameBindingModel);
                }
                continue;
            }
            if (annotation.annotationType() == Consumes.class) {
                model.setConsumes(MediaTypeParser.parse(((Consumes)annotation).value()));
                continue;
            }
            if (annotation.annotationType() != Produces.class) continue;
            model.setProduces(MediaTypeParser.parse(((Produces)annotation).value()));
        }
    }

    public MethodModel lookup(FabricHTTPRequest url) {
        try {
            PathModel pathModel = this.registry.lookupPathInfo(url);
            if (pathModel == null) {
                throw new NotFoundException();
            }
            MethodModel methodModel = pathModel.get(url.getRequest().getMethod());
            if (methodModel == null) {
                throw new NotFoundException();
            }
            return methodModel;
        }
        catch (UriTree.UriException exception) {
            throw new ProcessingException("Uri registery lookup failed.", (Throwable)exception);
        }
    }

    private void initNameBindings() {
    }

    private void initProviders() {
        for (Class<?> providerClass : this.config.providerClasses) {
            if (MessageBodyReader.class.isAssignableFrom(providerClass)) {
                this.messageBodyReaders.add((MessageBodyReader)this.newProviderInstance(providerClass));
            }
            if (MessageBodyWriter.class.isAssignableFrom(providerClass)) {
                this.messageBodyWriters.add((MessageBodyWriter)this.newProviderInstance(providerClass));
            }
            if (ExceptionMapper.class.isAssignableFrom(providerClass)) {
                this.exceptionMappersChain.add((ExceptionMapper)this.newProviderInstance(providerClass));
            }
            if (InjectionResolver.class.isAssignableFrom(providerClass) && !this.injectionResolvers.isRegistered(providerClass)) {
                this.injectionResolvers.register((InjectionResolver)this.newProviderInstance(providerClass));
            }
            if (!ContainerRequestFilter.class.isAssignableFrom(providerClass)) continue;
            Annotation nameBindingAnnotation = this.getNamebindingAnnotation(providerClass);
            if (nameBindingAnnotation != null) {
                NameBindingModel nameBindingModel = new NameBindingModel();
                nameBindingModel.setAnnotation(nameBindingAnnotation);
                nameBindingModel.setProviderInjectionClassModel(new InjectionClassModelBuilder(this.injectionResolvers).build(providerClass));
                this.nameBindingsModels.add(nameBindingModel);
                continue;
            }
            this.getGlobalContainerRequestFilters().add((ContainerRequestFilter)this.newProviderInstance(providerClass));
        }
    }

    private Annotation getNamebindingAnnotation(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!this.config.nameBindingClasses.contains(annotation.annotationType())) continue;
            return annotation;
        }
        return null;
    }

    private Object newProviderInstance(Class<?> providerClass) {
        return ReflectionProvider.getInstance().newInstance(providerClass);
    }

    private String getPath(Path path) {
        if (path == null) {
            return null;
        }
        String value = path.value();
        if (value == null || value.trim().length() == 0) {
            value = "/";
        }
        return UriMatcher.normalizeUriWithLastSlashRemove(value);
    }

    private Set<HttpMethod> getHttpMethods(Method method) {
        HashSet<HttpMethod> result = new HashSet<HttpMethod>();
        for (Annotation annotation : method.getAnnotations()) {
            if (!methodAnnotations.contains(annotation.annotationType())) continue;
            result.add(HttpMethod.fromString((String)annotation.annotationType().getSimpleName()));
        }
        return result;
    }

    public ExceptionMapper<Throwable> getExceptionMapper() {
        return this.exceptionMappersChain;
    }

    public ResourceInvoker createResourceInvoker() {
        return new ResourceInvoker(this);
    }

    public InjectionInstantiator createInjectionInstantiator() {
        return new InjectionInstantiator(this);
    }

    public ResourceInstantiator createResourceInstantiator() {
        return new ResourceInstantiator(this);
    }

    public ParametersInstantiator createParametersInstantiator() {
        return new ParametersInstantiator(this);
    }

    public InjectionContext createInjectionContext() {
        InjectionContextImpl context = new InjectionContextImpl();
        context.put(Application.class, (Object)this);
        context.put(RuntimeContext.class, RuntimeContext.getInstance());
        if (this.injectionContextConfigurator != null) {
            this.injectionContextConfigurator.configure(context);
        }
        return context;
    }

    public InjectionContextConfigurator getInjectionContextConfigurator() {
        return this.injectionContextConfigurator;
    }

    public void setInjectionContextConfigurator(InjectionContextConfigurator injectionContextConfigurator) {
        this.injectionContextConfigurator = injectionContextConfigurator;
    }

    public MessageBodyReader getMessageBodyReader(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Iterator<MessageBodyReader> iterator = this.messageBodyReaders.iterator();
        if (iterator.hasNext()) {
            MessageBodyReader reader = iterator.next();
            if (reader.isReadable(type, genericType, annotations, mediaType)) {
                // empty if block
            }
            return reader;
        }
        if (this.config.getDefaultMessageBodyReader() != null && this.config.getDefaultMessageBodyReader().isReadable(type, genericType, annotations, mediaType)) {
            return this.config.getDefaultMessageBodyReader();
        }
        return null;
    }

    public MessageBodyWriter getMessageBodyWriter(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        for (MessageBodyWriter writer : this.messageBodyWriters) {
            if (!writer.isWriteable(type, genericType, annotations, mediaType)) continue;
            return writer;
        }
        return null;
    }

    public MessageBodyWriter<?> getDefaultMessageBodyWriter() {
        return this.config.getDefaultMessageBodyWriter();
    }

    public List<NameBindingModel> getNameBindingsModels() {
        return this.nameBindingsModels;
    }

    public List<ContainerRequestFilter> getGlobalContainerRequestFilters() {
        return this.globalContainerRequestFilters;
    }

    public Set<Class<?>> getClasses() {
        HashSet result = new HashSet();
        result.addAll(this.config.resourceClasses);
        result.addAll(this.config.providerClasses);
        result.addAll(this.config.nameBindingClasses);
        return result;
    }

    public Set<Object> getSingletons() {
        return Collections.emptySet();
    }

    public Map<String, Object> getProperties() {
        return Collections.emptyMap();
    }
}

