/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.jaxrs.AuthorizedRequestFilter;
import com.streamscape.sef.network.http.server.jaxrs.AuthorizedRequestFilterAnnotation;
import com.streamscape.sef.network.http.server.jaxrs.GenericMessageBodyReader;
import com.streamscape.sef.network.http.server.jaxrs.GenericMessageBodyWriter;
import com.streamscape.sef.network.http.server.jaxrs.exception.ThrowableMapper;
import com.streamscape.sef.network.http.server.jaxrs.exception.WebApplicationExceptionMapper;
import com.streamscape.sef.network.http.server.jaxrs.injection.ServiceInjectionResolver;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.NameBinding;
import javax.ws.rs.Path;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

public class WsConfig {
    protected Set<Class<?>> resourceClasses = new HashSet();
    protected Set<Class<?>> providerClasses = new HashSet();
    protected Set<Class<?>> nameBindingClasses = new HashSet();
    private MessageBodyReader<?> defaultMessageBodyReader;
    private MessageBodyWriter<?> defaultMessageBodyWriter;

    public static WsConfig createDeafult(RuntimeContext runtimeContext) {
        WsConfig config = new WsConfig();
        config.register(ServiceInjectionResolver.class);
        config.register(AuthorizedRequestFilterAnnotation.class);
        config.register(AuthorizedRequestFilter.class);
        config.register(WebApplicationExceptionMapper.class);
        config.register(ThrowableMapper.class);
        if (runtimeContext != null) {
            config.setDefaultMessageBodyReader(GenericMessageBodyReader.getDefault(runtimeContext));
            config.setDefaultMessageBodyWriter(GenericMessageBodyWriter.getDefault(runtimeContext));
        }
        return config;
    }

    public MessageBodyReader<?> getDefaultMessageBodyReader() {
        return this.defaultMessageBodyReader;
    }

    public void setDefaultMessageBodyReader(MessageBodyReader<?> defaultMessageBodyReader) {
        this.defaultMessageBodyReader = defaultMessageBodyReader;
    }

    public MessageBodyWriter<?> getDefaultMessageBodyWriter() {
        return this.defaultMessageBodyWriter;
    }

    public void setDefaultMessageBodyWriter(MessageBodyWriter<?> defaultMessageBodyWriter) {
        this.defaultMessageBodyWriter = defaultMessageBodyWriter;
    }

    public void register(Class<?> clazz) {
        this.registerProvider(clazz);
        this.registerNameBinding(clazz);
        this.registerResource(clazz);
    }

    private boolean registerResource(Class<?> clazz) {
        if (!this.isPath(clazz)) {
            return false;
        }
        this.resourceClasses.add(clazz);
        return true;
    }

    private boolean registerNameBinding(Class<?> clazz) {
        if (!this.isNameBinding(clazz)) {
            return false;
        }
        this.nameBindingClasses.add(clazz);
        return true;
    }

    private boolean registerProvider(Class<?> clazz) {
        if (!this.isProvider(clazz)) {
            return false;
        }
        this.providerClasses.add(clazz);
        return true;
    }

    private boolean isPath(Class<?> clazz) {
        return clazz.getAnnotation(Path.class) != null;
    }

    private boolean isProvider(Class<?> clazz) {
        return clazz.getAnnotation(Provider.class) != null;
    }

    private boolean isNameBinding(Class<?> clazz) {
        return clazz.getAnnotation(NameBinding.class) != null;
    }
}

