/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs;

import com.streamscape.sef.network.http.server.jaxrs.MediaTypeParser;
import com.streamscape.sef.network.http.server.jaxrs.ResponseImpl;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.RuntimeDelegate;

public class RuntimeDelegateImpl
extends RuntimeDelegate {
    private static Pattern whitespace = Pattern.compile("\\s");
    private static Pattern whitespaceOrQuote = Pattern.compile("[\\s\"]");

    public UriBuilder createUriBuilder() {
        return null;
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return new ResponseImpl.ResponseBuilderImpl();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return null;
    }

    public <T> T createEndpoint(Application application, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        return null;
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> type) throws IllegalArgumentException {
        if (type == MediaType.class) {
            return new RuntimeDelegate.HeaderDelegate<MediaType>(this){

                public MediaType fromString(String value) {
                    return value != null ? MediaTypeParser.valueOf(value) : null;
                }

                public String toString(MediaType value) {
                    StringBuilder b = new StringBuilder();
                    b.append(value.getType()).append('/').append(value.getSubtype());
                    for (Map.Entry e : value.getParameters().entrySet()) {
                        b.append("; ").append((String)e.getKey()).append('=');
                        b.append((String)e.getValue());
                    }
                    return b.toString();
                }
            };
        }
        return null;
    }

    public Link.Builder createLinkBuilder() {
        return null;
    }

    public static void appendQuotedIfWhiteSpaceOrQuote(StringBuilder b, String value) {
        if (value == null) {
            return;
        }
        Matcher m = whitespaceOrQuote.matcher(value);
        boolean quote = m.find();
        if (quote) {
            b.append('\"');
        }
        RuntimeDelegateImpl.appendEscapingQuotes(b, value);
        if (quote) {
            b.append('\"');
        }
    }

    public static void appendQuotedIfWhitespace(StringBuilder b, String value) {
        if (value == null) {
            return;
        }
        Matcher m = whitespace.matcher(value);
        boolean quote = m.find();
        if (quote) {
            b.append('\"');
        }
        RuntimeDelegateImpl.appendEscapingQuotes(b, value);
        if (quote) {
            b.append('\"');
        }
    }

    public static void appendQuoted(StringBuilder b, String value) {
        b.append('\"');
        RuntimeDelegateImpl.appendEscapingQuotes(b, value);
        b.append('\"');
    }

    public static void appendEscapingQuotes(StringBuilder b, String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                b.append('\\');
            }
            b.append(c);
        }
    }
}

