/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs;

import com.streamscape.sef.network.http.server.jaxrs.WsModel;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionContext;
import com.streamscape.sef.network.http.server.jaxrs.models.MethodModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;

public class ResponseWriter {
    private WsModel model;

    public ResponseWriter(WsModel model) {
        this.model = model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(InjectionContext context, Response response) throws WebApplicationException, IOException {
        HttpServletResponse servletResponse = context.get(HttpServletResponse.class);
        if (response == null) {
            servletResponse.getOutputStream().flush();
            return;
        }
        if (response.getCookies() != null) {
            response.getCookies().entrySet().forEach(e -> {
                Cookie cookie = new Cookie((String)e.getKey(), ((NewCookie)e.getValue()).getValue());
                cookie.setPath(((NewCookie)e.getValue()).getPath());
                cookie.setComment(((NewCookie)e.getValue()).getComment());
                cookie.setSecure(((NewCookie)e.getValue()).isSecure());
                cookie.setMaxAge(((NewCookie)e.getValue()).getMaxAge());
                cookie.setHttpOnly(((NewCookie)e.getValue()).isHttpOnly());
                if (((NewCookie)e.getValue()).getDomain() != null) {
                    cookie.setDomain(((NewCookie)e.getValue()).getDomain());
                }
                servletResponse.addCookie(cookie);
            });
        }
        if (response.getEntity() != null) {
            servletResponse.setStatus(response.getStatus());
            MessageBodyWriter writer = null;
            MediaType mediaType = null;
            List requestAccepts = context.get(HttpHeaders.class).getAcceptableMediaTypes();
            List<MediaType> resourceProduces = context.exists(MethodModel.class) ? context.get(MethodModel.class).getMergedProduces() : Collections.emptyList();
            List<MediaType> neogatiateMediaType = this.neogatiateAccepts(requestAccepts, resourceProduces);
            if (response.getEntity() instanceof String && response.getMediaType() != null && this.model.getDefaultMessageBodyWriter() != null) {
                writer = this.model.getDefaultMessageBodyWriter();
                mediaType = response.getMediaType();
            }
            if (writer == null) {
                for (MediaType type : neogatiateMediaType) {
                    writer = this.model.getMessageBodyWriter(response.getEntity().getClass(), null, null, type);
                    if (writer == null) continue;
                    mediaType = type;
                    break;
                }
            }
            if (writer == null && (writer = this.model.getDefaultMessageBodyWriter()) != null) {
                for (MediaType type : neogatiateMediaType) {
                    if (!writer.isWriteable(response.getEntity().getClass(), null, null, type)) continue;
                    mediaType = type;
                    break;
                }
                if (mediaType == null && response.getEntity().getClass() == String.class) {
                    mediaType = MediaType.WILDCARD_TYPE;
                } else if (mediaType == null) {
                    mediaType = MediaType.APPLICATION_JSON_TYPE;
                }
            }
            if (writer == null) throw new ProcessingException("Unsupported request accept types: " + String.valueOf(requestAccepts) + ", resource produces: " + String.valueOf(resourceProduces));
            writer.writeTo(response.getEntity(), response.getEntity().getClass(), null, null, mediaType, context.get(HttpHeaders.class).getRequestHeaders(), (OutputStream)servletResponse.getOutputStream());
        } else if (response.getStatus() == 307) {
            if (response.getLocation() != null) {
                servletResponse.sendRedirect(response.getLocation().toString());
            } else {
                servletResponse.sendError(response.getStatus(), "location not specified.");
            }
        } else {
            servletResponse.sendError(response.getStatus());
        }
        servletResponse.getOutputStream().flush();
    }

    private List<MediaType> neogatiateAccepts(List<MediaType> requestAccepts, List<MediaType> resourceProduces) {
        List<MediaType> result = resourceProduces.stream().filter(t -> requestAccepts.contains(t)).collect(Collectors.toList());
        if (result.size() == 0 && requestAccepts.stream().filter(t -> "*".equals(t.getType()) && "*".equals(t.getSubtype())).findFirst().isPresent()) {
            result = resourceProduces;
        }
        return result;
    }
}

