/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs;

import com.streamscape.sef.network.http.server.jaxrs.MediaTypeParser;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;

public class ResponseImpl
extends Response {
    private int status;
    private Object entity;
    private MediaType type;
    private Map<String, NewCookie> cookieMap;
    private URI location;

    private ResponseImpl() {
    }

    public int getStatus() {
        return this.status;
    }

    public Response.StatusType getStatusInfo() {
        return new Response.StatusType(){

            public int getStatusCode() {
                return ResponseImpl.this.status;
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)ResponseImpl.this.status);
            }

            public String getReasonPhrase() {
                return "";
            }
        };
    }

    public Object getEntity() {
        return this.entity;
    }

    public Map<String, NewCookie> getCookies() {
        return this.cookieMap;
    }

    public URI getLocation() {
        return this.location;
    }

    public <T> T readEntity(Class<T> entityType) {
        return null;
    }

    public <T> T readEntity(GenericType<T> entityType) {
        return null;
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        return null;
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        return null;
    }

    public boolean hasEntity() {
        return false;
    }

    public boolean bufferEntity() {
        return false;
    }

    public void close() {
    }

    public MediaType getMediaType() {
        return this.type;
    }

    public Locale getLanguage() {
        return null;
    }

    public int getLength() {
        return 0;
    }

    public Set<String> getAllowedMethods() {
        return null;
    }

    public EntityTag getEntityTag() {
        return null;
    }

    public Date getDate() {
        return null;
    }

    public Date getLastModified() {
        return null;
    }

    public Set<Link> getLinks() {
        return null;
    }

    public boolean hasLink(String relation) {
        return false;
    }

    public Link getLink(String relation) {
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        return null;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return null;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return null;
    }

    public String getHeaderString(String name) {
        return null;
    }

    public static class ResponseBuilderImpl
    extends Response.ResponseBuilder {
        private int status;
        private Object entity;
        private MediaType type;
        private List<NewCookie> cookies;
        private URI location;

        public Response build() {
            ResponseImpl response = new ResponseImpl();
            response.status = this.status;
            response.entity = this.entity;
            response.type = this.type;
            response.location = this.location;
            if (this.cookies != null) {
                response.cookieMap = new HashMap<String, NewCookie>();
                this.cookies.forEach(c -> response.cookieMap.put(c.getName(), (NewCookie)c));
            }
            return response;
        }

        public Response.ResponseBuilder clone() {
            return new ResponseBuilderImpl().status(this.status).entity(this.entity);
        }

        public Response.ResponseBuilder status(int status) {
            this.status = status;
            return this;
        }

        public Response.ResponseBuilder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        public Response.ResponseBuilder entity(Object entity, Annotation[] annotations) {
            this.entity(entity);
            return this;
        }

        public Response.ResponseBuilder cookie(NewCookie ... cookies) {
            this.cookies = Arrays.asList(cookies);
            return this;
        }

        public Response.ResponseBuilder location(URI location) {
            this.location = location;
            return this;
        }

        public Response.ResponseBuilder allow(String ... methods) {
            return this;
        }

        public Response.ResponseBuilder allow(Set<String> methods) {
            return this;
        }

        public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
            return this;
        }

        public Response.ResponseBuilder encoding(String encoding) {
            return this;
        }

        public Response.ResponseBuilder header(String name, Object value) {
            return this;
        }

        public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> headers) {
            return this;
        }

        public Response.ResponseBuilder language(String language) {
            return this;
        }

        public Response.ResponseBuilder language(Locale language) {
            return this;
        }

        public Response.ResponseBuilder type(MediaType type) {
            this.type = type;
            return this;
        }

        public Response.ResponseBuilder type(String type) {
            this.type = MediaTypeParser.valueOf(type);
            return this;
        }

        public Response.ResponseBuilder variant(Variant variant) {
            return this;
        }

        public Response.ResponseBuilder contentLocation(URI location) {
            return this;
        }

        public Response.ResponseBuilder expires(Date expires) {
            return this;
        }

        public Response.ResponseBuilder lastModified(Date lastModified) {
            return this;
        }

        public Response.ResponseBuilder tag(EntityTag tag) {
            return this;
        }

        public Response.ResponseBuilder tag(String tag) {
            return this;
        }

        public Response.ResponseBuilder variants(Variant ... variants) {
            return this;
        }

        public Response.ResponseBuilder variants(List<Variant> variants) {
            return this;
        }

        public Response.ResponseBuilder links(Link ... links) {
            return this;
        }

        public Response.ResponseBuilder link(URI uri, String rel) {
            return this;
        }

        public Response.ResponseBuilder link(String uri, String rel) {
            return this;
        }
    }
}

