/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs;

import com.streamscape.lib.utils.Utils;
import com.streamscape.sef.network.http.server.jaxrs.WsModel;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionContext;
import com.streamscape.sef.network.http.server.jaxrs.models.MethodModel;
import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;

public class ResourceInvoker {
    private WsModel model;

    public ResourceInvoker(WsModel model) {
        this.model = model;
    }

    public Response invoke(MethodModel methodModel, InjectionContext context) throws Throwable {
        Object resource = this.model.createResourceInstantiator().instantiate(methodModel.getResourceModel(), context);
        Object[] params = this.model.createParametersInstantiator().instantiate(methodModel, context);
        try {
            Object result = methodModel.getMethod().invoke(resource, params);
            Response response = null;
            if (methodModel.getMethod().getReturnType() != Void.TYPE) {
                response = result instanceof Response ? (Response)result : Response.ok().entity(result).build();
            }
            return response;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new ProcessingException("Cannot execute method '" + String.valueOf(methodModel.getMethod()) + "'.", (Throwable)exception);
        }
        catch (InvocationTargetException exception) {
            throw Utils.unwrapInvokeException(exception);
        }
    }
}

