/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs;

import com.streamscape.sef.network.http.server.jaxrs.MediaTypeParser;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class HttpHeadersImpl
implements HttpHeaders {
    private FabricHTTPRequest url;

    public HttpHeadersImpl(FabricHTTPRequest url) {
        this.url = url;
    }

    public List<String> getRequestHeader(String name) {
        return (List)this.getRequestHeaders().get((Object)name);
    }

    public String getHeaderString(String name) {
        List values = (List)this.getRequestHeaders().get((Object)name);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.stream().collect(Collectors.joining(","));
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        MultivaluedHashMap result = new MultivaluedHashMap();
        Enumeration<String> names = this.url.getRequest().getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Enumeration<String> values = this.url.getRequest().getHeaders(name);
            while (values.hasMoreElements()) {
                result.add((Object)name, (Object)values.nextElement());
            }
        }
        return result;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        String accept = this.getHeaderString("Accept");
        if (accept == null || accept.length() == 0) {
            return Arrays.asList(MediaType.WILDCARD_TYPE);
        }
        return MediaTypeParser.parse(accept);
    }

    public List<Locale> getAcceptableLanguages() {
        return Arrays.asList(new Locale("*"));
    }

    public MediaType getMediaType() {
        String contentType = (String)this.getRequestHeaders().getFirst((Object)"Content-Type");
        if (contentType == null) {
            return null;
        }
        return MediaTypeParser.valueOf(contentType);
    }

    public Locale getLanguage() {
        return new Locale("*");
    }

    public Map<String, Cookie> getCookies() {
        HashMap<String, Cookie> result = new HashMap<String, Cookie>();
        List cookies = (List)this.getRequestHeaders().get((Object)"Cookie");
        for (String cookie : cookies) {
            if (cookie == null) continue;
            result.putAll(HttpHeadersImpl.parseCookies(cookie));
        }
        return result;
    }

    public Date getDate() {
        return null;
    }

    public int getLength() {
        return 0;
    }

    public static Map<String, Cookie> parseCookies(String header) {
        String[] bites = header.split("[;,]");
        LinkedHashMap<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();
        int version = 0;
        MutableCookie cookie = null;
        for (String bite : bites) {
            String value;
            String[] crumbs = bite.split("=", 2);
            String name = crumbs.length > 0 ? crumbs[0].trim() : "";
            String string = value = crumbs.length > 1 ? crumbs[1].trim() : "";
            if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                value = value.substring(1, value.length() - 1);
            }
            if (!name.startsWith("$")) {
                if (cookie != null) {
                    cookies.put(cookie.name, cookie.getImmutableCookie());
                }
                cookie = new MutableCookie(name, value);
                cookie.version = version;
                continue;
            }
            if (name.startsWith("$Version")) {
                version = Integer.parseInt(value);
                continue;
            }
            if (name.startsWith("$Path") && cookie != null) {
                cookie.path = value;
                continue;
            }
            if (!name.startsWith("$Domain") || cookie == null) continue;
            cookie.domain = value;
        }
        if (cookie != null) {
            cookies.put(cookie.name, cookie.getImmutableCookie());
        }
        return cookies;
    }

    private static class MutableCookie {
        String name;
        String value;
        int version = 1;
        String path = null;
        String domain = null;

        public MutableCookie(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Cookie getImmutableCookie() {
            return new Cookie(this.name, this.value, this.path, this.domain, this.version);
        }
    }
}

