/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs;

import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;

public class GenericMessageBodyWriter
implements MessageBodyWriter {
    private XSerializer xmlSerializer;
    private JSONSerializer jsonSerializer;

    GenericMessageBodyWriter(XSerializer xmlSerializer, JSONSerializer jsonSerializer) {
        this.xmlSerializer = xmlSerializer;
        this.jsonSerializer = jsonSerializer;
    }

    public JSONSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE) || mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE);
    }

    public long getSize(Object t, Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        OutputStreamWriter writer = new OutputStreamWriter(entityStream);
        try {
            if (t instanceof String) {
                httpHeaders.remove((Object)"Content-Type");
                httpHeaders.add((Object)"Content-Type", (Object)(mediaType != null ? mediaType.toString() : "plain/text"));
                writer.write(t.toString());
            } else if (mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                httpHeaders.remove((Object)"Content-Type");
                httpHeaders.add((Object)"Content-Type", (Object)"application/xml");
                this.xmlSerializer.serialize(t, writer);
            } else if (mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                httpHeaders.remove((Object)"Content-Type");
                httpHeaders.add((Object)"Content-Type", (Object)"application/json");
                this.jsonSerializer.serialize(t, writer);
            } else if (t != null) {
                httpHeaders.remove((Object)"Content-Type");
                httpHeaders.add((Object)"Content-Type", (Object)"plain/text");
                writer.write(t.toString());
            }
            ((Writer)writer).flush();
        }
        catch (SerializerException exception) {
            throw new ProcessingException("Serialization failed.", (Throwable)exception);
        }
    }

    public static GenericMessageBodyWriter getDefault(RuntimeContext context) {
        return new GenericMessageBodyWriter(context.getXSerializer(), HTTPUtils.getJsonSerializerForJaxrx(context));
    }
}

