/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jaxrs;

import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;

public class GenericMessageBodyReader
implements MessageBodyReader {
    private XSerializer xmlSerializer;
    private JSONSerializer jsonSerializer;

    GenericMessageBodyReader(XSerializer xmlSerializer, JSONSerializer jsonSerializer) {
        this.xmlSerializer = xmlSerializer;
        this.jsonSerializer = jsonSerializer;
    }

    public boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE) || mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public Object readFrom(Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        InputStreamReader reader = new InputStreamReader(entityStream);
        try {
            if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                return this.xmlSerializer.deserialize(reader);
            }
            if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                return this.jsonSerializer.deserialize(type, (Reader)reader);
            }
            throw new ProcessingException("Unsupported content type '" + String.valueOf(mediaType) + "'.");
        }
        catch (SerializerException exception) {
            throw new ProcessingException("Serialization failed.", (Throwable)exception);
        }
    }

    public static GenericMessageBodyReader getDefault(RuntimeContext context) {
        return new GenericMessageBodyReader(context.getXSerializer(), HTTPUtils.getJsonSerializerForJaxrx(context));
    }
}

