/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.AbstractPage;
import com.streamscape.sef.network.http.server.html.ButtonToken;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.jetty.WarDeployer;
import com.streamscape.sef.network.http.server.jetty.sysint.SysInitScriptsExecutorException;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.MultipartFormDataHelper;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.fileupload.FileItem;

public class WebAppsHtmlTable
extends AbstractHtmlTable {
    public static String COLUMN_WAR_NAME = "War Name";
    public static String COLUMN_DEPLOYMENT_DIR = "Deployment Dir";
    public static String COLUMN_URL = "Url";
    public static String COLUMN_DESCRIPTION = "Description";
    public static String COLUMN_WELCOME_FILES = "Welcome Files";
    public static String COLUMN_DISTRIBUTABLE = "Distributable";
    public static String COLUMN_ACTION = "Actions";
    private String alertText = null;

    public WebAppsHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_WAR_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_DEPLOYMENT_DIR, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_URL, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_DESCRIPTION, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_WELCOME_FILES, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_DISTRIBUTABLE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_ACTION, ExtendedRowMetaData.Align.CENTER);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Web Application Archives";
    }

    public void setAlertText(String alertText) {
        this.alertText = alertText;
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        for (WarDeployer.WarInfo warInfo : connection.getWarDeployer(url.getRequest()).listWarInfos()) {
            try {
                Row row = this.table.newRow();
                ComplexToken actionToken = new ComplexToken();
                if (warInfo.getWebAppDirectory() == null && warInfo.getWarName() != null) {
                    actionToken.append(new DeployUndeployButton("Deploy", SorUriRegistry.registry().formatFullUri(WebAppsDeployHtml.class, warInfo.getWarName())));
                    actionToken.append(new DeployUndeployButton("Remove", SorUriRegistry.registry().formatFullUri(WebAppsRemoveHtml.class, warInfo.getWarName())));
                } else if (warInfo.getWebAppDirectory() != null) {
                    actionToken.append(new DeployUndeployButton("Undeploy", SorUriRegistry.registry().formatFullUri(WebAppsUndeployHtml.class, warInfo.getWebAppDirectory())));
                }
                row.setColumn(COLUMN_WAR_NAME, (Object)(warInfo.getWarName() != null ? warInfo.getWarName() : "doesn't exist"));
                row.setColumn(COLUMN_DEPLOYMENT_DIR, (Object)(warInfo.getWebAppDirectory() != null ? warInfo.getWebAppDirectory() : "not deployed"));
                row.setColumn(COLUMN_URL, warInfo.getUrl() != null ? new LinkToken(warInfo.getUrl()) : "not started");
                row.setColumn(COLUMN_DESCRIPTION, (Object)(warInfo.getDescription() != null ? warInfo.getDescription() : "not deployed"));
                row.setColumn(COLUMN_WELCOME_FILES, (Object)(warInfo.getWelcomeFiles() != null ? warInfo.getWelcomeFiles().stream().collect(Collectors.joining("<br>")) : "not deployed"));
                row.setColumn(COLUMN_DISTRIBUTABLE, (Object)"");
                row.setColumn(COLUMN_ACTION, (Object)actionToken);
                this.table.addToRowSet(row);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
            }
        }
    }

    @Override
    public String getHtml() {
        return super.getHtml() + this.getUploadFormStyle() + this.getUploadForm() + this.getAlertScript();
    }

    private String getAlertScript() {
        if (this.alertText != null) {
            return "<script type=\"text/javascript\">\nalert('" + this.alertText.replace("'", "\\'") + "');\nwindow.location='" + SorUriRegistry.registry().getPrefix() + "/webapps';\n</script>\n";
        }
        return "";
    }

    private String getUploadForm() {
        return "<h4>War Upload</h4>\n<div id=\"FileUpload\">\n  <form method=\"post\" enctype=\"multipart/form-data\" action=\"" + SorUriRegistry.registry().formatFullUri(WebAppsUploadHtml.class, new String[0]) + "\">\n    <table><tr>\n      <td><input type=\"file\" name=\"name\" accept=\".war\" id=\"BrowserHidden\" onchange=\"getElementById('FileField').value = getElementById('BrowserHidden').value;\"></td>\n      <td><input type=\"submit\" value=\"Upload\" class=\"" + SorServletCss.DEPLOY_BUTTON_STYLE + "\"></td>\n    </tr></table>\n  </form>\n  <div id=\"BrowserVisible\">\n    <table><tr>\n      <td><input type=\"text\" id=\"FileField\"/></td><td>&nbsp;</td>\n      <td><input type=\"button\" value=\"Browse\" class=\"" + SorServletCss.DEPLOY_BUTTON_STYLE + "\"/></td>\n    </tr></table>\n  </div>\n</div>\n";
    }

    private String getUploadFormStyle() {
        return "<style type=\"text/css\">\n#FileUpload\n{\nposition:relative;\n}\n#BrowserVisible\n{\n    position: absolute;\n    top: 0px;\n    left: 0px;\n    z-index: 1;\n    height:20px;\n    width:340px;\n}\n#FileField\n{\n    width:260px;\n    height:20px;\n    border:solid 1px #000;\n}\n#BrowserHidden\n{\n    position:relative;\n    width:340px;\n    height:20px;\n   text-align: right;\n   -moz-opacity:0;\n    filter:alpha(opacity: 0);\n    opacity: 0;\n    z-index: 2;\n}\n</style>\n";
    }

    public static class DeployUndeployButton
    extends ButtonToken {
        public DeployUndeployButton(String value, String href) {
            super(value, href);
            this.addStyle(SorServletCss.DEPLOY_BUTTON_STYLE);
        }
    }

    public static class WebAppsDeployHtml
    extends AbstractDeployUndeployHtml {
        @Override
        public void onInit(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            String webappname = this.getWebAppName(url);
            List<SysInitScriptsExecutorException> exceptions = connection.getWarDeployer(url.getRequest()).deployWar(webappname);
            this.alertText = "Application '" + this.getWebAppName(url) + "' has been Deployed.";
            if (exceptions != null && exceptions.size() > 0) {
                this.alertText = this.alertText + "\\n\\nWARNING: Some elements of System Initialization scripts (DSQL) have failed.  Please see the node's error log for details.";
            }
        }
    }

    public static class WebAppsRemoveHtml
    extends AbstractDeployUndeployHtml {
        @Override
        public void onInit(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            connection.getWarDeployer(url.getRequest()).removeWar(this.getWebAppName(url));
            this.alertText = "Application '" + this.getWebAppName(url) + "' has been removed.";
        }
    }

    public static class WebAppsUndeployHtml
    extends AbstractDeployUndeployHtml {
        @Override
        public void onInit(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            connection.getWarDeployer(url.getRequest()).undeployWar(this.getWebAppName(url));
            this.alertText = "Application '" + this.getWebAppName(url) + "' has been Un-Deployed.\\n\\nClick [Remove] to delete the associated archive.";
        }
    }

    public static class WebAppsUploadHtml
    extends AbstractDeployUndeployHtml {
        @Override
        public void onInit(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            List<FileItem> items = MultipartFormDataHelper.getOrParseMultiParts(url.getRequest(), (HTTPAcceptorConfiguration)url.getRequest().getServletContext().getAttribute(HTTPAcceptorConfiguration.ATTRIBUTE), -1);
            for (FileItem item : items) {
                if (item.isFormField()) continue;
                File warFile = connection.getWarDeployer(url.getRequest()).createWar(item.getName());
                item.write(warFile);
            }
            this.alertText = "Archive has been uploaded.\\n\\nClick [Deploy] to deploy application.";
        }
    }

    static abstract class AbstractDeployUndeployHtml
    extends AbstractPage {
        protected String alertText = null;
        private Object response;

        AbstractDeployUndeployHtml() {
        }

        @Override
        public Object buildResponse(FabricHTTPRequest url) {
            return this.response;
        }

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            this.onInit(runtime, connection, url);
            WebAppsHtmlTable table = new WebAppsHtmlTable();
            table.setAlertText(this.alertText);
            table.init(runtime, connection, url);
            this.response = table.buildResponse(url);
        }

        protected abstract void onInit(RuntimeContext var1, HTTPServerFabricConnection var2, FabricHTTPRequest var3) throws Exception;

        protected String getWebAppName(FabricHTTPRequest url) {
            return url.getUriParameter("webAppName");
        }
    }
}

