/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.dropbox.DropBoxConfigurator;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.DataspacesHtmlTable;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;

public class SwaggerStaticApisHtmlTable
extends AbstractHtmlTable {
    public static String COLUMN_NAME = "Name";
    public static String COLUMN_SWAGGER = "Swagger.io";

    public SwaggerStaticApisHtmlTable() throws Exception {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_SWAGGER, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Swagger Static APIs";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        this.table.addToRowSet(new Object[]{"DropBox", new SwaggerApiLinkWithImage("/dropbox", "dropbox", DropBoxConfigurator.isDropBoxConfigured((HTTPAcceptorConfiguration)url.getRequest().getServletContext().getAttribute(HTTPAcceptorConfiguration.ATTRIBUTE)))});
        this.table.addToRowSet(new Object[]{"API Key Security", new SwaggerApiLinkWithImage("/security/apikey", "apikey")});
        this.table.addToRowSet(new Object[]{"Swagger Client Generation", new SwaggerApiLinkWithImage("/swagger/v2/client/gen", "clientgen")});
    }

    public static class SwaggerApiLinkWithImage
    extends DataspacesHtmlTable.SwaggerLinkWithImage {
        public SwaggerApiLinkWithImage(String apipath, String name) {
            this(apipath, name, true);
        }

        public SwaggerApiLinkWithImage(String apipath, String name, boolean enabled) {
            super(new SwaggerApiJsonYamlLink(apipath, "json", enabled), new SwaggerApiJsonYamlLink(apipath, "yaml", enabled), new DataspacesHtmlTable.SwaggerUiLink(new SwaggerApiJsonYamlLink(apipath, "json"), enabled), new DataspacesHtmlTable.SwaggerClientDownloadLink(new SwaggerApiJsonYamlLink(apipath, "json"), name, enabled));
        }
    }

    public static class SwaggerApiJsonYamlLink
    extends LinkToken {
        public SwaggerApiJsonYamlLink(String apipath, Object formatName) {
            this(apipath, formatName, true);
        }

        public SwaggerApiJsonYamlLink(String apipath, Object formatName, boolean enabled) {
            super(apipath + "/swagger." + String.valueOf(formatName), formatName);
            if (!enabled) {
                this.addStyle("sor-link-inactive");
            }
        }
    }
}

