/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.authentication.oauth2.servlet.HtmlTemplate;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;

public class SorLoginHtml
extends AbstractHtmlPage {
    private static HtmlTemplate template = null;
    private static final Object templateMutex = new Object();
    private String html;

    @Override
    public String getHtml() {
        return "";
    }

    @Override
    public String getTitle() {
        return "SOR Login";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        SorLoginHtml.initTemplate();
        String origin = url.getParameter("origin");
        if (origin != null && origin.trim().length() == 0) {
            origin = null;
        }
        HtmlTemplate.Builder builder = template.createBuilder();
        builder.setFieldValue("applicationName", "SOR");
        builder.setFieldValue("description", "Web SOR access.");
        builder.setFieldValue("global", "false");
        builder.setFieldValue("expiresIn", String.valueOf(86400));
        builder.setFieldValue("extendPeriod", String.valueOf(-1));
        builder.setFieldValue("securityBindings", ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION.toString());
        builder.setFieldValue("redirectUri", origin != null ? url.getParameter("origin") : SorUriRegistry.registry().getPrefix());
        builder.setFieldValue("errorRedirectUri", SorUriRegistry.registry().getPrefix() + "/login" + (String)(origin != null ? "?origin=" + origin : ""));
        builder.setFieldValue("basePath", SorUriRegistry.registry().getPrefix());
        builder.setFieldValue("responseFormat", "COOKIE");
        this.html = builder.build(new StringBuilder()).toString();
    }

    @Override
    public String getFullHtml() {
        return this.html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTemplate() {
        if (template == null) {
            Object object = templateMutex;
            synchronized (object) {
                if (template == null) {
                    String filename = "com/streamscape/sef/network/http/server/servlet/html/sor_apikey_authentication.html";
                    try {
                        byte[] bytes = HTTPUtils.getResourceFromJar(filename);
                        if (bytes == null) {
                            throw new Exception("sor_apikey_authentication.html not found..");
                        }
                        template = new HtmlTemplate(new String(bytes));
                    }
                    catch (Exception exception) {
                        Trace.logError(SorLoginHtml.class, "Failed to load sor auth file '" + filename + "'.");
                        Trace.logException(SorLoginHtml.class, exception, false);
                        throw new RuntimeException(exception);
                    }
                    template.setTemplateFields("applicationName", "description", "global", "expiresIn", "extendPeriod", "securityBindings", "redirectUri", "errorRedirectUri", "basePath", "responseFormat");
                    try {
                        template.compile();
                    }
                    catch (Exception exception) {
                        Trace.logError(SorLoginHtml.class, "Failed to compile sor authorize html template.");
                        Trace.logException(SorLoginHtml.class, exception, false);
                        template = null;
                        throw exception;
                    }
                }
            }
        }
    }
}

