/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.authentication.XSessionAuthenticator;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.ApiKeyWebApplicationsHtmlTable;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.ConnectionFactoriesHtmlTable;
import com.streamscape.sef.network.http.server.html.DataspacesHtmlTable;
import com.streamscape.sef.network.http.server.html.EventPrototypesHtmlTable;
import com.streamscape.sef.network.http.server.html.HtmlTokenFormatter;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.MappersHtmlTable;
import com.streamscape.sef.network.http.server.html.RemoteServicesHtmlTable;
import com.streamscape.sef.network.http.server.html.SQLQueriesHtmlTable;
import com.streamscape.sef.network.http.server.html.SemanticTypesHtmlTable;
import com.streamscape.sef.network.http.server.html.ServiceHtml;
import com.streamscape.sef.network.http.server.html.ServicesHtmlTable;
import com.streamscape.sef.network.http.server.html.SwaggerStaticApisHtmlTable;
import com.streamscape.sef.network.http.server.html.WebAppsHtmlTable;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;

public class SorHtml
extends AbstractHtmlPage {
    private FabricHTTPRequest url;

    @Override
    public String getHtml() {
        HtmlTokenFormatter formatter = new HtmlTokenFormatter();
        Object tokenId = XSessionAuthenticator.getTokenIfAuthenticated(this.url.getRequest());
        if (tokenId != null) {
            tokenId = "?x-session-token=" + (String)tokenId + "&x-session-token-move-to-cookie=true";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(new PageLinkWithImage("Services", ServicesHtmlTable.class).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("Remote Services", RemoteServicesHtmlTable.class).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("Semantic Types", SemanticTypesHtmlTable.class).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("Semantic Mappers", MappersHtmlTable.class).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("SQL Queries", SQLQueriesHtmlTable.class).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("Connection Factories", ConnectionFactoriesHtmlTable.class).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("Dataspaces", DataspacesHtmlTable.class).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("Remote Dataspaces", DataspacesHtmlTable.RemoteDataspacesHtmlTable.class).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("Event Prototypes", EventPrototypesHtmlTable.class).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("Web Applications", ApiKeyWebApplicationsHtmlTable.class).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("Repository Browser", "/repository" + (String)(tokenId != null ? tokenId : "")).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("Swagger Static APIs", SwaggerStaticApisHtmlTable.class).format(formatter)).append("<br>");
        builder.append(new PageLinkWithImage("Web Application Archives", WebAppsHtmlTable.class).format(formatter)).append("<br>");
        return SorServletCss.makeDefaultDiv(builder.toString());
    }

    @Override
    public String getTitle() {
        return "SOR Servlet";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        this.url = url;
    }

    @Override
    public String getFullHtml() {
        return SorServletCss.makeFullHtml(this.getTitle(), this.getHtml(), SorServletCss.getHeaderVersion(), "", true);
    }

    public static class PageLinkWithImage
    extends ComplexToken {
        public PageLinkWithImage(String displayName, String linkTo) {
            this(displayName, linkTo, false);
        }

        public PageLinkWithImage(String displayName, Class<? extends AbstractHtmlPage> pageClass) {
            this(displayName, pageClass, new String[]{null});
        }

        public PageLinkWithImage(String displayName, Class<? extends AbstractHtmlPage> pageClass, String ... arguments) {
            this(displayName, pageClass, false, arguments);
        }

        public PageLinkWithImage(String displayName, Class<? extends AbstractHtmlPage> pageClass, boolean disabled, String ... arguments) {
            this(displayName, SorUriRegistry.registry().formatFullUri(pageClass, arguments), disabled);
        }

        public PageLinkWithImage(String displayName, String linkTo, boolean disabled) {
            this.append(ServiceHtml.PAGES_LIST_IMAGE);
            LinkToken linkToken = new LinkToken(linkTo, displayName);
            if (disabled) {
                linkToken.addStyle("disabled");
            }
            this.append(linkToken);
        }
    }
}

