/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.network.http.server.authentication.XSessionAuthenticator;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.DataspacesHtmlTable;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.ServiceConfigurationPreviewPage;
import com.streamscape.sef.network.http.server.html.ServiceHtml;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceManager;

public class ServicesHtmlTable
extends AbstractHtmlTable {
    private static String COLUMN_SERVICE_FULL_NAME = "Name";
    private static String COLUMN_STATE = "State";
    private static String COLUMN_INVOKE_METHOD = "Invoke Method";
    private static String COLUMN_EVENT_SCOPE = "Event Scope";
    private static String COLUMN_AUTOSTART = "Autostart";
    private static String COLUMN_DESCRIPTION = "Description";
    private static String COLUMN_SWAGGER = "Swagger.io";
    private static String COLUMN_CUSTOMIZED_SWAGGER = "Customized Swagger.io";

    public ServicesHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_SERVICE_FULL_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_STATE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_AUTOSTART, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_INVOKE_METHOD, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_EVENT_SCOPE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_DESCRIPTION, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_SWAGGER, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_CUSTOMIZED_SWAGGER, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Services";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        try {
            RepositoryAccessor repositoryAccessor = runtime.getRepositoryAccessor();
            for (String serviceType : repositoryAccessor.listServiceTypes()) {
                for (String serviceName : repositoryAccessor.listServicesByType(serviceType)) {
                    if (serviceName.equalsIgnoreCase("prototype")) continue;
                    try {
                        String serviceFullName = serviceType + "." + serviceName;
                        ServiceManager serviceManager = runtime.getServiceManager();
                        ServiceDescriptor serviceDescriptor = serviceManager.getService(serviceFullName);
                        ServiceConfigurationObject serviceConfig = repositoryAccessor.loadServiceConfiguration(serviceName, serviceType);
                        Object displayName = serviceFullName;
                        if (serviceConfig != null && serviceConfig.getServiceDisplayName() != null && serviceConfig.getServiceDisplayName().length() != 0) {
                            displayName = serviceConfig.getServiceDisplayName();
                        }
                        ServiceImageLink serviceLink = new ServiceImageLink(serviceFullName, (String)displayName);
                        Row row = this.table.newRow();
                        row.setColumn(COLUMN_SERVICE_FULL_NAME, (Object)serviceLink);
                        row.setColumn(COLUMN_STATE, (Object)AbstractServiceOperation.getServiceState(serviceManager, serviceFullName));
                        row.setColumn(COLUMN_INVOKE_METHOD, serviceConfig != null ? serviceConfig.getInvokeMode() : "n/a");
                        row.setColumn(COLUMN_DESCRIPTION, (Object)(serviceConfig != null ? serviceConfig.getServiceDescription() : "n/a"));
                        row.setColumn(COLUMN_EVENT_SCOPE, serviceConfig != null ? serviceConfig.getEventScope() : "n/a");
                        row.setColumn(COLUMN_AUTOSTART, serviceDescriptor != null ? Boolean.valueOf(serviceDescriptor.isAutostart()) : "n/a");
                        row.setColumn(COLUMN_SWAGGER, (Object)new ServiceSwaggerLinkWithImage(serviceFullName, XSessionAuthenticator.getTokenIfAuthenticated(url.getRequest()), false));
                        row.setColumn(COLUMN_CUSTOMIZED_SWAGGER, (Object)new ServiceSwaggerLinkWithImage(serviceFullName, XSessionAuthenticator.getTokenIfAuthenticated(url.getRequest()), true));
                        this.table.addToRowSet(row);
                    }
                    catch (Exception exception) {
                        Trace.logException(this, exception, false);
                    }
                }
            }
        }
        catch (RepositoryAccessorException exception) {
            Trace.logException(this, exception, false);
        }
        catch (RepositoryException exception) {
            Trace.logException(this, exception, false);
        }
    }

    public static class ServiceImageLink
    extends ComplexToken {
        public ServiceImageLink(String serviceName) {
            this(serviceName, serviceName);
        }

        public ServiceImageLink(String serviceName, String serviceDisplayName) {
            this.append(ServiceHtml.SERVICE_IMAGE).append(new ServiceLink(serviceName, serviceDisplayName));
        }
    }

    public static class ServiceSwaggerLinkWithImage
    extends DataspacesHtmlTable.SwaggerLinkWithImage {
        public ServiceSwaggerLinkWithImage(String serviceName, String tokenId, boolean customized) {
            super(new ServiceSwaggerJsonLink(serviceName, customized).addXSessionTokenParameter(tokenId), new ServiceSwaggerYamlLink(serviceName, customized).addXSessionTokenParameter(tokenId), new ServiceSwaggerUiLink(serviceName, tokenId, customized), new DataspacesHtmlTable.SwaggerClientDownloadLink(new ServiceSwaggerJsonLink(serviceName, customized).addXSessionTokenParameter(tokenId), serviceName));
        }
    }

    public static class ServiceSwaggerUiLink
    extends DataspacesHtmlTable.SwaggerUiLink {
        public ServiceSwaggerUiLink(String serviceName, String tokenId) {
            this(serviceName, tokenId, false);
        }

        public ServiceSwaggerUiLink(String serviceName, String tokenId, boolean customized) {
            super(new ServiceSwaggerJsonLink(serviceName, customized).addXSessionTokenParameter(tokenId));
        }
    }

    public static class ServiceSwaggerYamlLink
    extends AbstractServiceSwaggerJsonYamlLink {
        public ServiceSwaggerYamlLink(String serviceName) {
            this(serviceName, false);
        }

        public ServiceSwaggerYamlLink(String serviceName, boolean customized) {
            super(serviceName, "yaml", customized);
        }
    }

    public static class ServiceSwaggerJsonLink
    extends AbstractServiceSwaggerJsonYamlLink {
        public ServiceSwaggerJsonLink(String serviceName) {
            this(serviceName, false);
        }

        public ServiceSwaggerJsonLink(String serviceName, boolean customized) {
            super(serviceName, "json", customized);
        }
    }

    public static class AbstractServiceSwaggerJsonYamlLink
    extends DataspacesHtmlTable.SwaggerJsonYamlLink {
        public AbstractServiceSwaggerJsonYamlLink(String serviceName, Object formatName) {
            this(serviceName, formatName, false);
        }

        public AbstractServiceSwaggerJsonYamlLink(String serviceName, Object formatName, boolean customized) {
            super((customized ? API_CUSTOMIZER_SWAGGER_PREFIX : "") + "/service/" + serviceName, formatName);
            this.setDownload("swagger_" + HTTPUtils.htmlEncode(serviceName, false) + "." + String.valueOf(formatName));
        }
    }

    public static class ServiceConfigurationLink
    extends LinkToken {
        public ServiceConfigurationLink(String serviceName) {
            this(serviceName, serviceName + ".sco");
        }

        public ServiceConfigurationLink(String serviceName, String serviceDisplayName) {
            super(SorUriRegistry.registry().formatFullUri(ServiceConfigurationPreviewPage.class, serviceName), serviceDisplayName);
        }
    }

    public static class ServiceLink
    extends LinkToken {
        public ServiceLink(String serviceName) {
            this(serviceName, serviceName);
        }

        public ServiceLink(String serviceName, String serviceDisplayName) {
            super(SorUriRegistry.registry().formatFullUri(ServiceHtml.class, serviceName), serviceDisplayName);
        }
    }
}

