/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.metrics.MetricDefinition;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.ServiceHtml;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import java.sql.SQLException;

public class ServiceMetricsHtmlTable
extends AbstractHtmlTable {
    private static String COLUMN_METRIC_NAME = "Metric Name";
    private static String COLUMN_METRIC_UNITS = "Utins";
    private static String COLUMN_METRIC_MIN_THRESHOLD = "Min";
    private static String COLUMN_METRIC_MAX_THRESHOLD = "Max";
    private static String COLUMN_METRIC_DESCRIPTION = "Description";

    public ServiceMetricsHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_METRIC_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_METRIC_UNITS, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_METRIC_MIN_THRESHOLD, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_METRIC_MAX_THRESHOLD, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_METRIC_DESCRIPTION, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Service Metrics";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        ServiceConfigurationObject sco = ServiceHtml.getServiceConfiguration(runtime, url);
        for (String metricName : sco.listMetrics()) {
            try {
                Row row = this.table.newRow();
                this.table.addToRowSet(row);
                row.setColumn(COLUMN_METRIC_NAME, (Object)new ComplexToken().append(ServiceHtml.METRIC_IMAGE).append(metricName));
                MetricDefinition definition = sco.getMetric(metricName);
                row.setColumn(COLUMN_METRIC_UNITS, (Object)definition.getUnits());
                row.setColumn(COLUMN_METRIC_MIN_THRESHOLD, (Object)definition.getMinThreshold());
                row.setColumn(COLUMN_METRIC_MAX_THRESHOLD, (Object)definition.getMaxThreshold());
                row.setColumn(COLUMN_METRIC_DESCRIPTION, (Object)definition.getDescription());
            }
            catch (RowException exception) {
                Trace.logException(this, exception, false);
            }
            catch (SQLException exception) {
                Trace.logException(this, exception, false);
            }
            catch (ServiceConfigurationException exception) {
                Trace.logException(this, exception, false);
            }
        }
    }
}

