/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.lib.reflection.creator.ObjectCreatorFactory;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.CustomizedRequestBuilder;
import com.streamscape.sef.network.http.server.apicustomizer.service.AbstractServiceRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.service.ServiceRule;
import com.streamscape.sef.network.http.server.apicustomizer.service.ServiceRuleWrapper;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.AbstractToken;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.DataspacesHtmlTable;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.HtmlCodeToken;
import com.streamscape.sef.network.http.server.html.HtmlTokenFormatter;
import com.streamscape.sef.network.http.server.html.ImageToken;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.RemoteServicesHtmlTable;
import com.streamscape.sef.network.http.server.html.RowSetHtmlFormatter;
import com.streamscape.sef.network.http.server.html.ServiceActionableEventsHtmlTable;
import com.streamscape.sef.network.http.server.html.ServiceAdvisoriesHtmlTable;
import com.streamscape.sef.network.http.server.html.ServiceEventHandlersHtmlTable;
import com.streamscape.sef.network.http.server.html.ServiceEventTriggersHtmlTable;
import com.streamscape.sef.network.http.server.html.ServiceMetricsHtmlTable;
import com.streamscape.sef.network.http.server.html.ServicesHtmlTable;
import com.streamscape.sef.network.http.server.html.SpanToken;
import com.streamscape.sef.network.http.server.html.TextToken;
import com.streamscape.sef.network.http.server.html.Token;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.service.osf.evh.EventHandler;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletException;

public class ServiceHtml
extends AbstractHtmlPage {
    public static String SOR_SERVICE_URI = "/sor/service/";
    private HTTPAcceptorConfiguration serverConfig;
    private ServiceConfigurationObject config;
    public static ImageToken SERVICE_IMAGE = new ImageToken("/public/images/small-javabean.png");
    public static ImageToken TYPE_BEAN_IMAGE = new ImageToken("/public/images/TypeBean.png");
    public static ImageToken EVENT_IMAGE = new ImageToken("/public/images/event.gif");
    public static ImageToken EVENT_HANDLER_IMAGE = new ImageToken("/public/images/event_handler.png");
    public static ImageToken EVENT_TRIGGER_IMAGE = new ImageToken("/public/images/evtrigger.gif");
    public static ImageToken ACTIONABLE_EVENT_IMAGE = new ImageToken("/public/images/actionable_event.png");
    public static ImageToken ADVISORY_IMAGE = new ImageToken("/public/images/advisory.png");
    public static ImageToken METRIC_IMAGE = new ImageToken("/public/images/metric.png");
    public static ImageToken METHOD_IMAGE = new ImageToken("/public/images/method.png");
    public static ImageToken SEMANTIC_TYPE_IMAGE = new ImageToken("/public/images/semantic_type.png");
    public static ImageToken PAGES_LIST_IMAGE = new ImageToken("/public/images/pages_list.gif");

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        this.serverConfig = (HTTPAcceptorConfiguration)url.getRequest().getServletContext().getAttribute(HTTPAcceptorConfiguration.ATTRIBUTE);
        this.config = ServiceHtml.getServiceConfiguration(runtime, url);
    }

    @Override
    public String getTitle() {
        return "Service: " + this.config.getServiceType() + "." + this.config.getServiceName();
    }

    @Override
    public String getHtml() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getHeaderHtml());
        PropertiesHtmlTable properties = new PropertiesHtmlTable();
        properties.addIfNotNull("Display Name", this.config.getServiceDisplayName());
        properties.addIfNotNull("Service Description", this.config.getServiceDescription());
        properties.addIfNotNull("Service Event Scope", this.config.getEventScope().toString());
        properties.addIfNotNull("Service Class Name", this.config.getServiceClassName());
        properties.addIfNotNull("Configuration Object", new ServicesHtmlTable.ServiceConfigurationLink(this.config.getServiceType() + "." + this.config.getServiceName()));
        properties.addIfNotNull("Daemon", this.config.isDaemonService());
        properties.addIfNotNull("Interruptable", this.config.isInterruptableService());
        properties.addIfNotNull("Invoke Mode", (Object)this.config.getInvokeMode());
        properties.addIfNotNull("Accessible in nodes", ServiceHtml.listNodesWithService(this.config.getServiceType(), this.config.getServiceName()));
        builder.append(properties.getHtml());
        builder.append("<div class=\"" + SorServletCss.DEFAULT_DIV_STYLE + "\">\n");
        HtmlTokenFormatter formatter = new HtmlTokenFormatter();
        builder.append(new ServiceEventHandlersLink(this.config.getServiceType(), this.config.getServiceName()).addStyle(SorServletCss.LINK_BUTTON_STYLE).format(formatter)).append("\n");
        builder.append(new ServiceActionableEventsLink(this.config.getServiceType(), this.config.getServiceName()).addStyle(SorServletCss.LINK_BUTTON_STYLE).format(formatter)).append("\n");
        builder.append(new ServiceEventTriggersLink(this.config.getServiceType(), this.config.getServiceName()).addStyle(SorServletCss.LINK_BUTTON_STYLE).format(formatter)).append("\n");
        builder.append(new ServiceAdvisoriesLink(this.config.getServiceType(), this.config.getServiceName()).addStyle(SorServletCss.LINK_BUTTON_STYLE).format(formatter)).append("\n");
        builder.append(new ServiceMetricsLink(this.config.getServiceType(), this.config.getServiceName()).addStyle(SorServletCss.LINK_BUTTON_STYLE).format(formatter)).append("\n");
        builder.append("</div>\n");
        builder.append(ServiceHtml.makeServiceCallHtml(this.serverConfig, this.config.getServiceType(), this.config.getServiceName(), this.config.getEventHandlers()));
        return builder.toString();
    }

    public static ComplexToken listNodesWithService(String serviceType, String serviceName) {
        ComplexToken token = new ComplexToken();
        String serviceFullName = serviceType + "." + serviceName;
        Moderator moderator = RuntimeContext.getInstance().getModerator();
        boolean first = true;
        for (ComponentReference component : moderator.getComponents(EventScope.GLOBAL)) {
            if (component.getModel() != ComponentModel.SERVICE || !component.getName().endsWith(serviceFullName)) continue;
            if (!first) {
                token.append(", ");
            }
            first = false;
            String nodeName = component.getName().substring(0, component.getName().indexOf("://"));
            token.append(new RemoteServicesHtmlTable.RemoteServiceLink(nodeName, serviceFullName, nodeName));
        }
        return token;
    }

    public static String makeServiceCallHtml(HTTPAcceptorConfiguration serverConfig, String serviceType, String serviceName, List<EventHandler> handlers) {
        return ServiceHtml.makeServiceCallHtml(serverConfig, serviceType, serviceName, handlers, null);
    }

    public static String makeServiceCallHtml(HTTPAcceptorConfiguration serverConfig, String serviceType, String serviceName, List<EventHandler> handlers, String nodeName) {
        StringBuilder builder = new StringBuilder();
        builder.append("<div class=\"" + SorServletCss.DEFAULT_DIV_STYLE + "\">\n");
        builder.append("<br>").append(SorServletCss.bold("Service API Calls")).append("<br><br>");
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn("Value", ExtendedRowMetaData.Align.LEFT);
        RowSet rowSet = new RowSet(meta);
        for (EventHandler handler : handlers) {
            try {
                Row row = rowSet.newRow();
                row.setColumn("Value", (Object)new SpanToken(new ComplexToken().append(METHOD_IMAGE).append(new ServiceEventHandlersHtmlTable.ServiceEventHandlerLink(serviceType, serviceName, handler.getHandlerName()))).addStyle(SorServletCss.SERVICE_CALL_TAB_STYLE));
                rowSet.addToRowSet(row);
                row = rowSet.newRow();
                row.setColumn("Value", (Object)ServiceHtml.makeServiceCallTable(serverConfig, serviceType, serviceName, handler, nodeName));
                rowSet.addToRowSet(row);
            }
            catch (RowException exception) {
                Trace.logException(ServiceHtml.class, exception, false);
            }
            catch (SQLException exception) {
                Trace.logException(ServiceHtml.class, exception, false);
            }
        }
        builder.append(new RowSetHtmlFormatter(SorServletCss.TABLE_METHODS_STYLE, SorServletCss.TABLE_METHODS_STYLE_ALT).formatHorizontal(rowSet, false));
        builder.append("</div>\n");
        return builder.toString();
    }

    public static Token makeServiceCallTable(HTTPAcceptorConfiguration serverConfig, final String serviceType, final String serviceName, final EventHandler handler, String nodeName) {
        String d = "";
        try {
            Object object = ObjectCreatorFactory.createObjectCreator().createDefaultObject(handler.getRequestSemanticType());
            if (object != null) {
                d = HTTPUtils.getJsonSerializerForRest().serialize(object);
            } else {
                Trace.logError(ServiceHtml.class, "Failed to create object of semantic type '" + handler.getRequestSemanticType() + "'.");
            }
        }
        catch (Exception exception) {
            Trace.logException(ServiceHtml.class, exception, false);
        }
        final String data = d;
        AbstractToken serviceCall = new TextToken("n/a");
        StringBuilder builder = new StringBuilder();
        builder.append(serverConfig.getResolvedUrlWithSchema());
        builder.append("/service/invoke?service=").append(serviceType + "." + serviceName);
        if (nodeName != null) {
            builder.append("&nodeName=").append(nodeName);
        }
        builder.append("&eventHandler=").append(handler.getHandlerName());
        builder.append("&requestFormat=JSON&responseFormat=JSON&data=");
        serviceCall = new LinkToken(builder.toString() + HTTPUtils.encodeString(data), builder.toString() + data);
        RowSet rowSet = DataspacesHtmlTable.createRowSetForCalls();
        DataspacesHtmlTable.addCallToRowSet(rowSet, "GET", serviceCall);
        serviceCall = new HtmlCodeToken(DataspacesHtmlTable.makeCallsTable(rowSet));
        AbstractToken publicCall = new TextToken("n/a");
        if (serverConfig.getAPICustomizerConfiguration() != null) {
            rowSet = DataspacesHtmlTable.createRowSetForCalls();
            for (ServiceRule serviceRule : serverConfig.getAPICustomizerConfiguration().listServiceRules()) {
                try {
                    ServiceRuleWrapper wrapper = (ServiceRuleWrapper)serviceRule.createWrapper();
                    AbstractServiceRuleParametersResolver resolver = new AbstractServiceRuleParametersResolver(wrapper){

                        @Override
                        protected String onGetServiceName() {
                            return serviceType + "." + serviceName;
                        }

                        @Override
                        protected String onGetEventHandler(String parameterName) {
                            return handler.getHandlerName();
                        }

                        @Override
                        protected String onGetCorrelationId(String parameterName) {
                            return "<CorrelationId>";
                        }

                        @Override
                        protected String onGetDataContent(String parameterName) {
                            return data;
                        }

                        @Override
                        protected String onGetDurable(String parameterName) {
                            return "<durable>";
                        }

                        @Override
                        protected String onGetEventGroupId(String parameterName) {
                            return "<EventGroupId>";
                        }

                        @Override
                        protected String onGetEventId(String parameterName) {
                            return "<EventId>";
                        }

                        @Override
                        protected String onGetEventKey(String parameterName) {
                            return "<EventKey>";
                        }

                        @Override
                        protected String onGetLoadBalance(String parameterName) {
                            return "<LoadBalance>";
                        }

                        @Override
                        protected String onGetTimeout(String parameterName) {
                            return "<Timeout>";
                        }

                        @Override
                        protected String onGetEventProperty(String name) {
                            return "<Event Property " + name + ">";
                        }

                        @Override
                        protected String onGetRequestFormat() {
                            return "json";
                        }
                    };
                    if (!resolver.accepts()) continue;
                    HTTPRequest request = new CustomizedRequestBuilder(wrapper).build(resolver);
                    request.setUri(serverConfig.getResolvedUrlWithSchema() + request.getUri());
                    DataspacesHtmlTable.addCallToRowSet(rowSet, request);
                }
                catch (Exception exception) {
                    Trace.logError(ServiceHtml.class, "Failed to handle service rule: " + String.valueOf(serviceRule) + ". Cause: " + exception.getMessage());
                }
            }
            if (rowSet.getRowCount() > 0) {
                publicCall = new HtmlCodeToken(DataspacesHtmlTable.makeCallsTable(rowSet));
            }
        }
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn("Property", ExtendedRowMetaData.Align.LEFT);
        meta.addColumn("Value", ExtendedRowMetaData.Align.LEFT);
        RowSet rowSet2 = new RowSet(meta);
        try {
            Row row = rowSet2.newRow();
            row.setColumn("Property", (Object)"API Service Call:");
            row.setColumn("Value", (Object)serviceCall);
            rowSet2.addToRowSet(row);
            row = rowSet2.newRow();
            row.setColumn("Property", (Object)"Public Calls:");
            row.setColumn("Value", (Object)publicCall);
            rowSet2.addToRowSet(row);
        }
        catch (Exception exception) {
            Trace.logException(ServiceHtml.class, exception, false);
        }
        return new HtmlCodeToken(new RowSetHtmlFormatter(SorServletCss.TABLE_SERVICE_CALL_STYLE).formatVertical(rowSet2));
    }

    protected static ServiceConfigurationObject getServiceConfiguration(RuntimeContext runtime, FabricHTTPRequest url) throws Exception {
        String serviceName = url.getUriParameterOrThrowException("serviceName");
        int pos = serviceName.indexOf(46);
        if (pos == -1) {
            throw new ServletException("Invalid service name specified.");
        }
        try {
            return runtime.getRepositoryAccessor().loadServiceConfiguration(serviceName.substring(pos + 1), serviceName.substring(0, pos));
        }
        catch (Exception exception) {
            throw new ServletException("Failed to load service configuration. Cause: " + exception.toString());
        }
    }

    public static class ServiceEventHandlersLink
    extends LinkToken {
        public ServiceEventHandlersLink(String serviceType, String serviceName) {
            this(serviceType, serviceName, new ComplexToken().append(EVENT_HANDLER_IMAGE).append("Event Handlers"));
        }

        public ServiceEventHandlersLink(String serviceType, String serviceName, Object displayName) {
            super(SorUriRegistry.registry().formatFullUri(ServiceEventHandlersHtmlTable.class, serviceType + "." + serviceName), displayName);
        }
    }

    public static class ServiceActionableEventsLink
    extends LinkToken {
        public ServiceActionableEventsLink(String serviceType, String serviceName) {
            this(serviceType, serviceName, new ComplexToken().append(ACTIONABLE_EVENT_IMAGE).append("Actionable Events"));
        }

        public ServiceActionableEventsLink(String serviceType, String serviceName, Object displayName) {
            super(SorUriRegistry.registry().formatFullUri(ServiceActionableEventsHtmlTable.class, serviceType + "." + serviceName), displayName);
        }
    }

    public static class ServiceEventTriggersLink
    extends LinkToken {
        public ServiceEventTriggersLink(String serviceType, String serviceName) {
            this(serviceType, serviceName, new ComplexToken().append(EVENT_TRIGGER_IMAGE).append("Event Triggers"));
        }

        public ServiceEventTriggersLink(String serviceType, String serviceName, Object displayName) {
            super(SorUriRegistry.registry().formatFullUri(ServiceEventTriggersHtmlTable.class, serviceType + "." + serviceName), displayName);
        }
    }

    public static class ServiceAdvisoriesLink
    extends LinkToken {
        public ServiceAdvisoriesLink(String serviceType, String serviceName) {
            this(serviceType, serviceName, new ComplexToken().append(ADVISORY_IMAGE).append("Advisories"));
        }

        public ServiceAdvisoriesLink(String serviceType, String serviceName, Object displayName) {
            super(SorUriRegistry.registry().formatFullUri(ServiceAdvisoriesHtmlTable.class, serviceType + "." + serviceName), displayName);
        }
    }

    public static class ServiceMetricsLink
    extends LinkToken {
        public ServiceMetricsLink(String serviceType, String serviceName) {
            this(serviceType, serviceName, new ComplexToken().append(METRIC_IMAGE).append("Metrics"));
        }

        public ServiceMetricsLink(String serviceType, String serviceName, Object displayName) {
            super(SorUriRegistry.registry().formatFullUri(ServiceMetricsHtmlTable.class, serviceType + "." + serviceName), displayName);
        }
    }
}

