/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDoc;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.evtrigger.EventTriggerCompiledDefinition;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.ServiceHtml;
import com.streamscape.sef.network.http.server.html.TextToken;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.tools.lexer.BufferUtils;
import java.sql.SQLException;
import java.util.stream.Collectors;

public class ServiceEventTriggersHtmlTable
extends AbstractHtmlTable {
    private static String COLUMN_EVENT_TRIGGER_NAME = "Trigger Name";
    private static String COLUMN_TRIGGER_AUTO_ENABLE = "Trigger Auto Enable";
    private static String COLUMN_EVENT_SCOPE = "Event Scope";
    private static String COLUMN_ACTION_EVENT_ID = "Actionable Event Id";
    private static String COLUMN_ADVISORY_CAPABLE = "Advisory Capable";
    private static String COLUMN_EVENT_CAPABLE = "Event Capable";
    private static String COLUMN_EVENT_EVENT_ID = "Trigger Event Ids";
    private static String COLUMN_EVENT_TRIGGER_STATE = "Trigger State";
    private static String COLUMN_EVENT_TRIGGER_LAST_ERROR = "Last Error";

    public ServiceEventTriggersHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_EVENT_TRIGGER_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_TRIGGER_AUTO_ENABLE, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_EVENT_SCOPE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_ACTION_EVENT_ID, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_ADVISORY_CAPABLE, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_EVENT_CAPABLE, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_EVENT_EVENT_ID, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_EVENT_TRIGGER_STATE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_EVENT_TRIGGER_LAST_ERROR, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Service Event Triggers";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        try {
            ServiceConfigurationObject sco = ServiceHtml.getServiceConfiguration(runtime, url);
            ServiceAccessor serviceAccessor = connection.createServiceAccessor(sco.getServiceType(), sco.getServiceName());
            for (String triggerName : sco.listEventTriggers()) {
                Row row = this.table.newRow();
                try {
                    String lastError;
                    EventTriggerState triggerState;
                    EventTriggerDefinition definition = null;
                    EventTriggerData triggerData = sco.getEventTriggerData(triggerName);
                    if (serviceAccessor.isAvailable() && serviceAccessor.isOpened()) {
                        definition = serviceAccessor.getEventTriggerDefinition(triggerName);
                    }
                    if ((triggerState = serviceAccessor.getTriggerState(triggerName)) == null) {
                        triggerState = EventTriggerState.NOT_INITIALIZED;
                    }
                    if ((lastError = serviceAccessor.getLastError(triggerName)) == null) {
                        lastError = "---";
                    }
                    row.setColumn(COLUMN_EVENT_TRIGGER_NAME, (Object)new ComplexToken().append(ServiceHtml.EVENT_TRIGGER_IMAGE).append(new ServiceEventTriggerLink(sco.getServiceType(), sco.getServiceName(), triggerName)));
                    if (definition != null) {
                        Object advisoryCapable = "---";
                        Object eventCapable = "---";
                        Object triggerEventIds = "---";
                        if (definition instanceof EventTriggerCompiledDefinition) {
                            EventTriggerCompiledDefinition compiledDefinition = (EventTriggerCompiledDefinition)definition;
                            advisoryCapable = compiledDefinition.isAdvisoryCapable();
                            eventCapable = compiledDefinition.isEventCapable();
                            triggerEventIds = compiledDefinition.getRaisedEventIds().stream().map(e -> new TextToken(e)).collect(Collectors.toList());
                        }
                        row.setColumn(COLUMN_TRIGGER_AUTO_ENABLE, (Object)definition.isAutoEnable());
                        row.setColumn(COLUMN_EVENT_SCOPE, (Object)definition.getEventScope());
                        row.setColumn(COLUMN_ACTION_EVENT_ID, (Object)definition.getActionableEventId());
                        row.setColumn(COLUMN_ADVISORY_CAPABLE, advisoryCapable);
                        row.setColumn(COLUMN_EVENT_CAPABLE, eventCapable);
                        row.setColumn(COLUMN_EVENT_EVENT_ID, triggerEventIds);
                    } else {
                        row.setColumn(COLUMN_EVENT_SCOPE, (Object)"---");
                        row.setColumn(COLUMN_ACTION_EVENT_ID, (Object)"---");
                        row.setColumn(COLUMN_ADVISORY_CAPABLE, (Object)"---");
                        row.setColumn(COLUMN_EVENT_CAPABLE, (Object)"---");
                        row.setColumn(COLUMN_EVENT_EVENT_ID, (Object)"---");
                    }
                    if (triggerData != null) {
                        row.setColumn(COLUMN_TRIGGER_AUTO_ENABLE, (Object)triggerData.isAutoEnable());
                    }
                    row.setColumn(COLUMN_EVENT_TRIGGER_STATE, (Object)triggerState.toString());
                    row.setColumn(COLUMN_EVENT_TRIGGER_LAST_ERROR, (Object)lastError);
                    this.table.addToRowSet(row);
                }
                catch (RowException exception) {
                    Trace.logException(this, exception, false);
                }
                catch (SQLException exception) {
                    Trace.logException(this, exception, false);
                }
                catch (ServiceConfigurationException exception) {
                    Trace.logException(this, exception, false);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    public static class ServiceEventTriggerLink
    extends LinkToken {
        public ServiceEventTriggerLink(String serviceType, String serviceName, String triggerName) {
            super(SorUriRegistry.registry().formatFullUri(ServiceEventTriggerHtml.class, serviceType + "." + serviceName, triggerName), triggerName);
        }
    }

    public static class ServiceEventTriggerHtml
    extends AbstractHtmlPage {
        private String triggerName;
        private String triggerSyntax;
        private JavaDoc triggerJavaDoc;
        private ServiceConfigurationObject sco;

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            this.sco = ServiceHtml.getServiceConfiguration(runtime, url);
            this.triggerName = url.getUriParameterOrThrowException("triggerName");
            ServiceAccessor serviceAccessor = connection.createServiceAccessor(this.sco.getServiceType(), this.sco.getServiceName());
            if (serviceAccessor.isAvailable() && serviceAccessor.isOpened()) {
                this.triggerSyntax = serviceAccessor.getEventTriggerSyntax(this.triggerName);
            }
            if (this.triggerSyntax != null) {
                this.triggerJavaDoc = JavaDoc.Builder.extractJavaDoc(this.triggerSyntax);
                this.triggerSyntax = BufferUtils.removeJavaDoc(this.triggerSyntax);
            }
        }

        @Override
        public String getTitle() {
            return "Service Event Trigger: " + this.triggerName;
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            PropertiesHtmlTable properties = new PropertiesHtmlTable();
            properties.addIfNotNull("Service Trigger Name", this.triggerName);
            properties.addIfNotNull("Service", this.sco.getServiceType() + "." + this.sco.getServiceName());
            builder.append(properties.getHtml());
            if (this.triggerSyntax == null) {
                builder.append(SorServletCss.subheader("TRIGGER DOESN'T EXIST OR SERVICE IS NOT LOADED"));
                return builder.toString();
            }
            builder.append(SorServletCss.subheader("Documentation"));
            if (this.triggerJavaDoc != null) {
                builder.append(SorServletCss.makeJavaDocHtml(this.triggerJavaDoc, null, null));
            }
            builder.append(SorServletCss.subheader("Syntax"));
            builder.append(SorServletCss.hightlightCodeSQL(this.triggerSyntax)).append("\n");
            return builder.toString();
        }
    }
}

