/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.AbstractPreviewPage;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.EventPrototypesHtmlTable;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.SemanticTypeHtml;
import com.streamscape.sef.network.http.server.html.SemanticTypeLink;
import com.streamscape.sef.network.http.server.html.ServiceHtml;
import com.streamscape.sef.network.http.server.servlet.ExchangeServletHelper;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.service.osf.evh.EventHandler;
import java.sql.SQLException;
import javax.servlet.ServletException;

public class ServiceEventHandlersHtmlTable
extends AbstractHtmlTable {
    private static String COLUMN_HANDLER_NAME = "Handler Name";
    private static String COLUMN_METHOD_NAME = "Method Name";
    private static String COLUMN_INVOKE_MODE = "Invoke Mode";
    private static String COLUMN_REQUEST_EVENT_ID = "Request Event Id";
    private static String COLUMN_REQUEST_SEMANTIC_TYPE = "Request Semantic Type";
    private static String COLUMN_RESPONSE_EVENT_ID = "Response Event Id ";
    private static String COLUMN_RESPONSE_SEMANTIC_TYPE = "Response Semantic Type";

    public ServiceEventHandlersHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_HANDLER_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_INVOKE_MODE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_METHOD_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_REQUEST_EVENT_ID, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_REQUEST_SEMANTIC_TYPE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_RESPONSE_EVENT_ID, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_RESPONSE_SEMANTIC_TYPE, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Service Event Handlers";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        ServiceConfigurationObject sco = ServiceHtml.getServiceConfiguration(runtime, url);
        try {
            for (String handlerName : sco.listEventHandlers()) {
                EventHandler handler = sco.getEventHandler(handlerName);
                Row row = this.table.newRow();
                row.setColumn(COLUMN_HANDLER_NAME, (Object)new ComplexToken().append(ServiceHtml.EVENT_HANDLER_IMAGE).append(new ServiceEventHandlerLink(sco.getServiceType(), sco.getServiceName(), handlerName)));
                row.setColumn(COLUMN_METHOD_NAME, (Object)handler.getMethodName());
                row.setColumn(COLUMN_INVOKE_MODE, (Object)(handler.getInvokeMode() != null ? handler.getInvokeMode() : sco.getInvokeMode()));
                row.setColumn(COLUMN_REQUEST_EVENT_ID, (Object)new EventPrototypesHtmlTable.EventPrototypeWithSerializationLink(handler.getRequestEventId()));
                row.setColumn(COLUMN_REQUEST_SEMANTIC_TYPE, (Object)new SemanticTypeLink(handler.getRequestSemanticType()));
                row.setColumn(COLUMN_RESPONSE_EVENT_ID, (Object)new EventPrototypesHtmlTable.EventPrototypeWithSerializationLink(handler.getResponseEventId()));
                row.setColumn(COLUMN_RESPONSE_SEMANTIC_TYPE, (Object)new SemanticTypeLink(handler.getResponseSemanticType()));
                this.table.addToRowSet(row);
            }
        }
        catch (RowException exception) {
            Trace.logException(this, exception, false);
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, false);
        }
    }

    public static class ServiceEventHandlerLink
    extends LinkToken {
        public ServiceEventHandlerLink(String serviceType, String serviceName, String handlerName) {
            super(SorUriRegistry.registry().formatFullUri(ServiceEventHandlerHtml.class, serviceType + "." + serviceName, handlerName), handlerName);
        }
    }

    public static class ServiceEventHandlerResponseEventPage
    extends AbstractServiceEventHandlerRequestResponseObjectEventPage {
        @Override
        protected boolean isEvent() {
            return true;
        }

        @Override
        protected String getEventId(EventHandler eventHandler) {
            return eventHandler.getResponseEventId();
        }
    }

    public static class ServiceEventHandlerRequestEventPage
    extends AbstractServiceEventHandlerRequestResponseObjectEventPage {
        @Override
        protected boolean isEvent() {
            return true;
        }

        @Override
        protected String getEventId(EventHandler eventHandler) {
            return eventHandler.getRequestEventId();
        }
    }

    public static class ServiceEventHandlerResponseObjectPage
    extends AbstractServiceEventHandlerRequestResponseObjectEventPage {
        @Override
        protected boolean isEvent() {
            return false;
        }

        @Override
        protected String getEventId(EventHandler eventHandler) {
            return eventHandler.getResponseEventId();
        }
    }

    public static class ServiceEventHandlerRequestObjectPage
    extends AbstractServiceEventHandlerRequestResponseObjectEventPage {
        @Override
        protected boolean isEvent() {
            return false;
        }

        @Override
        protected String getEventId(EventHandler eventHandler) {
            return eventHandler.getRequestEventId();
        }
    }

    static abstract class AbstractServiceEventHandlerRequestResponseObjectEventPage
    extends AbstractPreviewPage {
        private Object object;

        AbstractServiceEventHandlerRequestResponseObjectEventPage() {
        }

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            ServiceConfigurationObject sco = ServiceHtml.getServiceConfiguration(runtime, url);
            EventHandler eventHandler = ServiceEventHandlerHtml.getEventHandler(url, sco);
            String eventId = this.getEventId(eventHandler);
            boolean isEvent = this.isEvent();
            ImmutableEventDatagram eventDatagram = HTTPUtils.createEvent(eventId);
            this.object = isEvent ? eventDatagram : ExchangeServletHelper.getResultObject(eventDatagram);
        }

        @Override
        protected Object getResponseObject() {
            return this.object;
        }

        protected abstract boolean isEvent();

        protected abstract String getEventId(EventHandler var1);
    }

    public static class ServiceEventHandlerByMethodNameHtml
    extends ServiceEventHandlerHtml {
    }

    public static class ServiceEventHandlerByEventIdHtml
    extends ServiceEventHandlerHtml {
    }

    public static class ServiceEventHandlerHtml
    extends AbstractHtmlPage {
        private PropertiesHtmlTable properties;
        private String handlerName;

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            ServiceConfigurationObject sco = ServiceHtml.getServiceConfiguration(runtime, url);
            EventHandler eventHandler = ServiceEventHandlerHtml.getEventHandler(url, sco);
            this.handlerName = eventHandler.getHandlerName();
            this.properties = new PropertiesHtmlTable();
            this.properties.addIfNotNull(COLUMN_METHOD_NAME, eventHandler.getMethodName());
            this.properties.addIfNotNull(COLUMN_INVOKE_MODE, (Object)(eventHandler.getInvokeMode() != null ? eventHandler.getInvokeMode() : sco.getInvokeMode()));
            this.properties.addIfNotNull(COLUMN_REQUEST_EVENT_ID, eventHandler.getRequestEventId() != null && eventHandler.getRequestEventId().length() > 0 ? new ComplexToken().append(new EventPrototypesHtmlTable.EventImageLink(eventHandler.getRequestEventId())) : "");
            this.properties.addIfNotNull(COLUMN_REQUEST_SEMANTIC_TYPE, new SemanticTypeHtml.SemanticTypeImageLink(eventHandler.getRequestSemanticType()));
            this.properties.addIfNotNull(COLUMN_RESPONSE_EVENT_ID, eventHandler.getResponseEventId() != null && eventHandler.getResponseEventId().length() > 0 ? new ComplexToken().append(new EventPrototypesHtmlTable.EventImageLink(eventHandler.getResponseEventId())) : "");
            this.properties.addIfNotNull(COLUMN_RESPONSE_SEMANTIC_TYPE, new SemanticTypeHtml.SemanticTypeImageLink(eventHandler.getResponseSemanticType()));
        }

        @Override
        public String getTitle() {
            return "Event Handler: " + this.handlerName;
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            builder.append(this.properties.getHtml());
            return builder.toString();
        }

        static EventHandler getEventHandler(FabricHTTPRequest url, ServiceConfigurationObject sco) throws Exception {
            String handlerName = url.getUriParameter("handlerName");
            if (handlerName != null) {
                for (EventHandler handler : sco.getEventHandlers()) {
                    if (!handler.getHandlerName().equals(handlerName)) continue;
                    return handler;
                }
                throw new ServletException("Event Handler with '" + handlerName + "' name does not exist.");
            }
            String methodName = url.getUriParameter("methodName");
            if (methodName != null) {
                for (EventHandler handler : sco.getEventHandlers()) {
                    if (!handler.getMethodName().equals(methodName)) continue;
                    return handler;
                }
                throw new ServletException("Event Handler for '" + methodName + "' method does not exist.");
            }
            String eventId = url.getUriParameter("eventId");
            if (eventId != null) {
                for (EventHandler handler : sco.getEventHandlers()) {
                    if (!handler.getRequestEventId().equals(eventId)) continue;
                    return handler;
                }
                throw new ServletException("Event Handler for '" + eventId + "' EventId does not exist.");
            }
            return null;
        }
    }

    public static class ServiceEventIdImagePreviewLink
    extends ServiceEventIdPreviewLink {
        public ServiceEventIdImagePreviewLink(String serviceType, String serviceName, String handlerName, String eventId) {
            super(serviceType, serviceName, handlerName, eventId);
            this.prepend(ServiceHtml.EVENT_IMAGE);
        }
    }

    public static class ServiceEventIdPreviewLink
    extends ComplexToken {
        public ServiceEventIdPreviewLink(String serviceType, String serviceName, String handlerName, String eventId) {
            if (eventId == null || eventId.length() == 0) {
                return;
            }
            this.append(eventId).append(" ");
            this.append(new LinkToken(ServiceHtml.SOR_SERVICE_URI + serviceType + "." + serviceName + "/RequestEvent?eventHandler=" + handlerName + "&responseFormat=XML", "xml")).append(" ");
            this.append(new LinkToken(ServiceHtml.SOR_SERVICE_URI + serviceType + "." + serviceName + "/RequestEvent?eventHandler=" + handlerName + "&responseFormat=JSON", "json"));
        }
    }
}

