/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.advisories.StateAdvisoryDefinition;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.ServiceHtml;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import java.sql.SQLException;

public class ServiceAdvisoriesHtmlTable
extends AbstractHtmlTable {
    private static String COLUMN_ADVISORY_NAME = "Advisory Name";
    private static String COLUMN_ADVISORY_TYPE = "Type";
    private static String COLUMN_ADVISORY_DESCRIPTION = "Description";

    public ServiceAdvisoriesHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_ADVISORY_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_ADVISORY_TYPE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_ADVISORY_DESCRIPTION, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Service Advisories";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        ServiceConfigurationObject sco = ServiceHtml.getServiceConfiguration(runtime, url);
        for (String advisoryName : sco.listAdvisories()) {
            try {
                Row row = this.table.newRow();
                this.table.addToRowSet(row);
                row.setColumn(COLUMN_ADVISORY_NAME, (Object)new ComplexToken().append(ServiceHtml.ADVISORY_IMAGE).append(advisoryName));
                StateAdvisoryDefinition definition = sco.getStateAdvisoryDefinition(advisoryName);
                row.setColumn(COLUMN_ADVISORY_TYPE, (Object)definition.getType());
                row.setColumn(COLUMN_ADVISORY_DESCRIPTION, (Object)definition.getDescription());
            }
            catch (RowException exception) {
                Trace.logException(this, exception, false);
            }
            catch (SQLException exception) {
                Trace.logException(this, exception, false);
            }
            catch (ServiceConfigurationException exception) {
                Trace.logException(this, exception, false);
            }
        }
    }
}

