/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.SemanticTypeLink;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.sql.SQLException;
import java.util.regex.Pattern;

public class SemanticTypesHtmlTable
extends AbstractHtmlTable {
    private static String COLUMN_SEMANTIC_TYPE = "SemanticType";
    private static String COLUMN_CLASS = "Class";
    private static String COLUMN_SYSTEM = "System";
    private static String COLUMN_VALID = "Valid";
    private static String COLUMN_ANCESTOR = "Ancestor";
    private static String COLUMN_INTERFACE = "Interface";
    private boolean includeSystemTypes = false;
    private boolean filterAsRegexp = false;
    private String filterTemplate = "";

    public SemanticTypesHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_SEMANTIC_TYPE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_CLASS, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_SYSTEM, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_VALID, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_ANCESTOR, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_INTERFACE, ExtendedRowMetaData.Align.CENTER);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Sematic Types";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        this.includeSystemTypes = url.getParameter("includeSystemTypes") != null && (url.getParameter("includeSystemTypes").length() == 0 || url.getParameter("includeSystemTypes").equalsIgnoreCase("on") || url.getParameter("includeSystemTypes").equalsIgnoreCase("true")) || url.getParameter("all") != null && (url.getParameter("all").equalsIgnoreCase("true") || url.getParameter("all").length() == 0);
        this.filterTemplate = url.getParameter("filterTemplate");
        this.filterAsRegexp = url.getParameter("filterAsRegexp") != null && (url.getParameter("filterAsRegexp").length() == 0 || url.getParameter("filterAsRegexp").equalsIgnoreCase("on") || url.getParameter("filterAsRegexp").equalsIgnoreCase("true"));
        Pattern filterPattern = null;
        if (this.filterTemplate != null && this.filterTemplate.length() > 0) {
            Object regexpTemplate = this.filterTemplate;
            if (!this.filterAsRegexp) {
                regexpTemplate = ".*" + Pattern.quote((String)regexpTemplate) + ".*";
            }
            try {
                filterPattern = Pattern.compile((String)regexpTemplate);
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to compile regexp '" + (String)regexpTemplate + "'. Cause: " + exception.getMessage());
            }
        }
        for (String typeName : runtime.getSemanticTypeCache().listSemanticTypes()) {
            SemanticType semanticType = runtime.getSemanticTypeCache().lookupSemanticType(typeName);
            if (semanticType == null || !this.includeSystemTypes && semanticType.isSystem() || filterPattern != null && !filterPattern.matcher(typeName).matches()) continue;
            this.addSemanticType(runtime.getSemanticTypeCache().lookupSemanticType(typeName));
        }
    }

    protected void addSemanticType(SemanticType semanticType) {
        try {
            if (semanticType == null) {
                return;
            }
            Row row = this.table.newRow();
            row.setColumn(COLUMN_SEMANTIC_TYPE, (Object)new SemanticTypeLink(semanticType.getTypeName()));
            row.setColumn(COLUMN_CLASS, (Object)semanticType.getClassName());
            row.setColumn(COLUMN_SYSTEM, (Object)semanticType.isSystem());
            row.setColumn(COLUMN_VALID, (Object)semanticType.isValid());
            row.setColumn(COLUMN_ANCESTOR, (Object)semanticType.getAncestorType());
            row.setColumn(COLUMN_INTERFACE, (Object)semanticType.isInterface());
            this.table.addToRowSet(row);
        }
        catch (RowException exception) {
            Trace.logException(this, exception, false);
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, false);
        }
    }

    @Override
    public String getHtml() {
        StringBuilder filter = new StringBuilder();
        filter.append("<div class=\"sor-div-filter\">\n");
        filter.append("<form><table><tr>\n");
        filter.append("<td><input type=\"text\" name=\"filterTemplate\" style=\"width:100%;\" value='" + (this.filterTemplate != null ? HTTPUtils.htmlEncode(this.filterTemplate, true) : "") + "'></td>\n");
        filter.append("<td><input type=\"submit\" class=\"sor-button-filter\" value=\"Filter\"></td></tr>\n");
        filter.append("<tr><td><input type=\"checkbox\" name=\"filterAsRegexp\"" + (this.filterAsRegexp ? " checked " : "") + ">Regular Expression\n");
        filter.append("<input type=\"checkbox\" name=\"includeSystemTypes\"" + (this.includeSystemTypes ? " checked " : "") + ">Include System Types</td></tr>\n");
        filter.append("</table></form>\n");
        filter.append("</div>\n");
        return filter.toString() + super.getHtml();
    }
}

