/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphVisitor;
import com.streamscape.lib.jar.JarFile;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.omf.mapper.SemanticMap;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.SdoUtils;
import com.streamscape.runtime.mf.operation.edl.doc.SdoEnumFieldsHtmlTable;
import com.streamscape.runtime.mf.operation.edl.doc.SdoFieldsHtmlTable;
import com.streamscape.runtime.mf.operation.edl.doc.SdoHtmlDoc;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.EventPrototypesHtmlTable;
import com.streamscape.sef.network.http.server.html.HtmlCodeToken;
import com.streamscape.sef.network.http.server.html.HtmlTokenFormatter;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.MappersHtmlTable;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.SemanticTypeLink;
import com.streamscape.sef.network.http.server.html.SemanticTypePreviewPage;
import com.streamscape.sef.network.http.server.html.ServiceHtml;
import com.streamscape.sef.network.http.server.html.ServicesHtmlTable;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.utils.SemanticTypeInfo;
import com.streamscape.sef.utils.SemanticUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SemanticTypeHtml
extends AbstractHtmlPage {
    private String typeName;
    private String className;
    private String packageName;
    private String ancestor;
    private Boolean isInterface;
    private Boolean isSystem;
    private Boolean isValid;
    private String description;
    private Boolean userClass = false;
    private String extArchive;
    private String libArchive;
    private String pkgName;
    private Set<String> dependentEvents = new HashSet<String>();
    private Set<String> dependentTypes = new HashSet<String>();
    private Set<String> dependentServices = new HashSet<String>();
    private Set<String> dependentArtifacts = new HashSet<String>();
    private String documentationAndDataObjectBlocks;

    @Override
    public String getTitle() {
        return "Semantic Type: " + this.typeName;
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        String semanticTypeName = url.getUriParameterOrThrowException("semanticTypeName");
        SemanticType semanticType = runtime.getSemanticTypeCache().lookupSemanticType(semanticTypeName);
        if (semanticType == null) {
            throw new Exception("Semantic type '" + semanticTypeName + "' not found.");
        }
        this.typeName = semanticType.getTypeName();
        this.className = semanticType.getClassName().lastIndexOf(46) != -1 ? semanticType.getClassName().substring(semanticType.getClassName().lastIndexOf(46) + 1) : semanticType.getClassName();
        this.packageName = semanticType.getClassName().lastIndexOf(46) != -1 ? semanticType.getClassName().substring(0, semanticType.getClassName().lastIndexOf(46)) : "";
        this.ancestor = semanticType.getAncestorType();
        this.isInterface = semanticType.isInterface();
        this.isSystem = semanticType.isSystem();
        this.isValid = semanticType.isValid();
        this.description = semanticType.getDescription();
        SemanticTypeInfo typeInfo = SemanticUtils.getSemanticTypeInfo(semanticType, runtime);
        this.extArchive = typeInfo.getExtJar();
        this.libArchive = typeInfo.getLibJar();
        if (typeInfo.getPackage() != null) {
            this.pkgName = typeInfo.getPackage().getFullName();
        }
        try {
            this.dependentEvents.addAll(SemanticUtils.listDependentEventIds(semanticType, (FabricContext)runtime));
            this.dependentTypes.addAll(SemanticUtils.listDependentTypes(semanticType, runtime));
            this.dependentServices.addAll(SemanticUtils.listDependentServices(semanticType, runtime));
            this.dependentArtifacts.addAll(SemanticUtils.listDependentMappers(semanticType, runtime));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
        if (this.libArchive != null) {
            String htmlFilename = SdoUtils.getHtmlPathInJar(semanticType.getClassName());
            JarFile jarFile = SemanticUtils.getLibJarFile(this.libArchive, runtime);
            byte[] bytes = jarFile.getEntryBytes(htmlFilename);
            if (bytes != null) {
                this.userClass = true;
                this.documentationAndDataObjectBlocks = SdoHtmlDoc.getDocumentationBlock(new String(bytes));
                String prefix = SorUriRegistry.registry().getPrefix();
                this.documentationAndDataObjectBlocks = this.documentationAndDataObjectBlocks.replaceAll("/sor/type", prefix + "/type");
                this.documentationAndDataObjectBlocks = this.documentationAndDataObjectBlocks.replaceAll("/sorquilt/type", prefix + "/type");
                this.documentationAndDataObjectBlocks = this.documentationAndDataObjectBlocks.replaceAll("class=\"TableListStyle\"", "class=\"" + SorServletCss.TABLE_LIST_STYLE + "\"");
            }
        }
        if (this.documentationAndDataObjectBlocks == null) {
            this.documentationAndDataObjectBlocks = SemanticTypeHtml.getDocumentationHeader() + SemanticTypeHtml.getDataObjectHeader();
            try {
                Class clazz = ClassUtils.loadClass(semanticType.getClassName(), runtime.getSystemClassLoaderChain());
                if (clazz == null) {
                    throw new ClassNotFoundException();
                }
                if (!clazz.isEnum()) {
                    TypeAnalyzer analyzer = TypeAnalyzerFactory.getInstance().createTypeAnalyzer();
                    TypeGraph typeGraph = analyzer.getTypeGraph(clazz);
                    final SdoFieldsHtmlTable fieldsTable = new SdoFieldsHtmlTable();
                    typeGraph.traverse(new TypeGraphVisitor(){

                        @Override
                        public boolean visit(TypeGraph node, int level) throws TypeAnalyzerException {
                            if (level != 1) {
                                return true;
                            }
                            fieldsTable.addField(node.getName(), node.getType());
                            return true;
                        }

                        @Override
                        public void afterChildrenVisit(TypeGraph node, int level) throws TypeAnalyzerException {
                        }
                    });
                    this.documentationAndDataObjectBlocks = this.documentationAndDataObjectBlocks + fieldsTable.getHtml();
                } else {
                    SdoEnumFieldsHtmlTable fieldsTable = new SdoEnumFieldsHtmlTable();
                    for (Object o : clazz.getEnumConstants()) {
                        fieldsTable.addField(o.toString());
                    }
                    this.documentationAndDataObjectBlocks = this.documentationAndDataObjectBlocks + fieldsTable.getHtml();
                }
            }
            catch (ClassNotFoundException exception) {
                this.documentationAndDataObjectBlocks = this.documentationAndDataObjectBlocks + "class " + semanticType.getClassName() + " cannot be loaded.<br>";
            }
        }
    }

    @Override
    public String getHeaderHtml() {
        return SorServletCss.header(this.typeName) + "\n" + this.getPropertiesHtml();
    }

    protected String getPropertiesHtml() {
        PropertiesHtmlTable properties = new PropertiesHtmlTable();
        properties.addIfNotNull("Namespace", this.packageName);
        properties.addIfNotNull("Object Class", this.className);
        properties.addIfNotNull("Ancestor", this.ancestor);
        properties.addIfNotNull("Interface", this.isInterface);
        properties.addIfNotNull("System", this.isSystem);
        properties.addIfNotNull("User Class", this.userClass);
        if (this.isValid != null && this.isValid.booleanValue()) {
            properties.addIfNotNull("Valid", true);
        } else if (this.isValid != null) {
            properties.addIfNotNull("Valid", new HtmlCodeToken("<font color=\"red\">false</font>"));
        }
        if (this.extArchive != null) {
            properties.addIfNotNull("Ext Archive", this.extArchive);
        }
        if (this.pkgName != null) {
            properties.addIfNotNull("Package", this.pkgName);
        }
        if (this.libArchive != null) {
            properties.addIfNotNull("Archive", this.libArchive);
        }
        if (this.dependentEvents.size() > 0) {
            properties.addIfNotNull("Dependent Events", SemanticTypeHtml.makeEventImageLinksList(this.dependentEvents));
        }
        if (this.dependentTypes.size() > 0) {
            properties.addIfNotNull("Dependent Types", SemanticTypeHtml.makeSemanticTypeImageLinksList(this.dependentTypes));
        }
        if (this.dependentArtifacts.size() > 0) {
            properties.addIfNotNull("Dependent Artifacts", SemanticTypeHtml.makeArtifactLinksList(this.dependentArtifacts));
        }
        if (this.dependentServices.size() > 0) {
            properties.addIfNotNull("Dependent Services", SemanticTypeHtml.makeServiceImageLinksList(this.dependentServices));
        }
        properties.addIfNotNull("Description", this.description);
        return properties.getHtml();
    }

    public String getSerializationHtml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<div class=\"").append(SorServletCss.DEFAULT_DIV_STYLE).append("\">\n");
        HtmlTokenFormatter formatter = new HtmlTokenFormatter();
        builder.append(new SemanticTypePreviewLink(this.typeName, "xml", "XML Preview").addStyle(SorServletCss.LINK_BUTTON_STYLE).format(formatter)).append("\n");
        builder.append(new SemanticTypePreviewLink(this.typeName, "json", "JSON Preview").addStyle(SorServletCss.LINK_BUTTON_STYLE).format(formatter)).append("\n");
        builder.append("</div>\n");
        return builder.toString();
    }

    @Override
    public String getHtml() {
        return this.getHeaderHtml() + this.documentationAndDataObjectBlocks + "<br>" + this.getSerializationHtml();
    }

    public static String getDocumentationHeader() {
        return SorServletCss.subheader("Documentation");
    }

    public static String getDataObjectHeader() {
        return SorServletCss.subheader("Data Object");
    }

    public static ComplexToken makeServiceImageLinksList(Collection<String> services) {
        ComplexToken complexToken = new ComplexToken();
        Iterator<String> iterator = services.iterator();
        while (iterator.hasNext()) {
            complexToken.append(new ServicesHtmlTable.ServiceImageLink(iterator.next()));
            if (!iterator.hasNext()) continue;
            complexToken.append(new HtmlCodeToken("<br>"));
        }
        return complexToken;
    }

    public static ComplexToken makeEventImageLinksList(Collection<String> events) {
        ComplexToken complexToken = new ComplexToken();
        Iterator<String> iterator = events.iterator();
        while (iterator.hasNext()) {
            complexToken.append(new EventPrototypesHtmlTable.EventImageLink(iterator.next()));
            if (!iterator.hasNext()) continue;
            complexToken.append(new HtmlCodeToken("<br>"));
        }
        return complexToken;
    }

    public static ComplexToken makeSemanticTypeLinksList(Collection<String> types) {
        ComplexToken complexToken = new ComplexToken();
        Iterator<String> iterator = types.iterator();
        while (iterator.hasNext()) {
            complexToken.append(new SemanticTypeLink(iterator.next()));
            if (!iterator.hasNext()) continue;
            complexToken.append(", ");
        }
        return complexToken;
    }

    public static ComplexToken makeSemanticTypeImageLinksList(Collection<String> types) {
        ComplexToken complexToken = new ComplexToken();
        Iterator<String> iterator = types.iterator();
        while (iterator.hasNext()) {
            complexToken.append(new SemanticTypeImageLink(iterator.next()));
            if (!iterator.hasNext()) continue;
            complexToken.append(new HtmlCodeToken("<br>"));
        }
        return complexToken;
    }

    public static ComplexToken makeArtifactLinksList(Collection<String> artifacts) {
        ComplexToken complexToken = new ComplexToken();
        String semanticMapType = SemanticMap.class.getSimpleName() + ".";
        Iterator<String> iterator = artifacts.iterator();
        while (iterator.hasNext()) {
            String artifact = iterator.next();
            if (artifact.startsWith(semanticMapType)) {
                complexToken.append(new MappersHtmlTable.MapperLink(artifact.substring(semanticMapType.length()), artifact));
            } else {
                complexToken.append(artifact);
            }
            if (!iterator.hasNext()) continue;
            complexToken.append(new HtmlCodeToken("<br>"));
        }
        return complexToken;
    }

    private String makeStringList(Collection<String> collection) {
        if (collection.size() <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String element : collection) {
            builder.append(element).append(", ");
        }
        builder.setLength(builder.length() - 2);
        return builder.toString();
    }

    public static class SemanticTypePreviewLink
    extends LinkToken {
        public SemanticTypePreviewLink(String semanticTypeName, String format) {
            this(semanticTypeName, format, semanticTypeName);
        }

        public SemanticTypePreviewLink(String semanticTypeName, String format, Object displayName) {
            super(SorUriRegistry.registry().formatFullUri(SemanticTypePreviewPage.class, semanticTypeName) + "?responseFormat=" + format, displayName);
        }
    }

    public static class SemanticTypeImageLink
    extends ComplexToken {
        public SemanticTypeImageLink(String typeName) {
            this.append(ServiceHtml.SEMANTIC_TYPE_IMAGE).append(new SemanticTypeLink(typeName));
        }
    }
}

