/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.sqlquery.DescribeSQLQueryOperation;
import com.streamscape.runtime.mf.operation.sqlquery.ListSQLQueriesOperation;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.enums.SQLQueryType;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.RowSetHtmlFormatter;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;

public class SQLQueriesHtmlTable
extends AbstractHtmlTable {
    public static String COLUMN_SQL_QUERY_NAME = "Name";
    public static String COLUMN_SQL_QUERY_DESCRIPTION = "Description";
    public static String COLUMN_SQL_QUERY_TYPE = "Query Type";
    public static String COLUMN_SQL_QUERY_IS_CALLABLE = "Is Callable";

    public SQLQueriesHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_SQL_QUERY_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_SQL_QUERY_TYPE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_SQL_QUERY_IS_CALLABLE, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_SQL_QUERY_DESCRIPTION, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "SQL Queries";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        try {
            for (String queryName : ListSQLQueriesOperation.listSQLQueries(runtime)) {
                try {
                    SQLQuery query = DescribeSQLQueryOperation.getSQLQuery(queryName);
                    if (query == null) {
                        Trace.logError(this, "Failed to get SQL query '" + queryName + "' from .tfcache.");
                        continue;
                    }
                    Row row = this.table.newRow();
                    row.setColumn(COLUMN_SQL_QUERY_NAME, (Object)new SQLQueryLink(queryName));
                    row.setColumn(COLUMN_SQL_QUERY_TYPE, (Object)SQLQueryType.getTypeById(query.getQueryType()));
                    row.setColumn(COLUMN_SQL_QUERY_IS_CALLABLE, (Object)query.isCallable());
                    row.setColumn(COLUMN_SQL_QUERY_DESCRIPTION, (Object)query.getDescription());
                    this.table.addToRowSet(row);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    public static class SQLQueryLink
    extends LinkToken {
        public SQLQueryLink(String queryName, String displayName) {
            super(SorUriRegistry.registry().formatFullUri(SQLQueryHtml.class, queryName), displayName);
        }

        public SQLQueryLink(String queryName) {
            this(queryName, queryName);
        }
    }

    public static class SQLQueryHtml
    extends AbstractHtmlPage {
        private String queryName;
        private SQLQuery query;

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            this.queryName = url.getUriParameterOrThrowException("queryName");
            this.query = DescribeSQLQueryOperation.getSQLQuery(this.queryName);
            if (this.query == null) {
                Trace.logError(this, "Failed to get SQL query '" + this.queryName + "' from .tfcache.");
                throw new Exception("Failed to get SQL query '" + this.queryName + "' from .tfcache.");
            }
        }

        @Override
        public String getTitle() {
            return "SQL Query: " + this.queryName;
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            PropertiesHtmlTable properties = new PropertiesHtmlTable();
            properties.addIfNotNull(COLUMN_SQL_QUERY_NAME, this.queryName);
            properties.addIfNotNull(COLUMN_SQL_QUERY_TYPE, (Object)SQLQueryType.getTypeById(this.query.getQueryType()));
            properties.addIfNotNull(COLUMN_SQL_QUERY_IS_CALLABLE, this.query.isCallable());
            properties.addIfNotNull(COLUMN_SQL_QUERY_DESCRIPTION, this.query.getDescription());
            builder.append(properties.getHtml());
            builder.append(SorServletCss.subheader("SQL Query"));
            builder.append(SorServletCss.hightlightCodeSQL(this.query.getSqlScript())).append("\n");
            builder.append(SorServletCss.subheader("SQL Query Parameters"));
            try {
                builder.append(new RowSetHtmlFormatter(SorServletCss.TABLE_LIST_STYLE, SorServletCss.TABLE_LIST_STYLE_ALT).formatHorizontal(DescribeSQLQueryOperation.getSQLQueryParametersTable(this.query)));
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to get SQL query '" + this.queryName + "' from .tfcache.");
            }
            return builder.toString();
        }
    }
}

