/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.ds.parser.expression.URL;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.omf.json.jackson.JacksonUtils;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetFactory;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.HtmlCodeToken;
import com.streamscape.sef.network.http.server.html.HtmlTokenFormatter;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.ObjectToRowSetConverter;
import com.streamscape.sef.network.http.server.html.Token;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.servlet.dataspace.DSRowSetResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class RowSetHtmlFormatter {
    private String cssClassName = null;
    private String cssRowClassName = null;
    private static AtomicLong expandableLabelIndex = new AtomicLong();
    private ObjectToRowSetConverter objectToRowSetConverter = new ObjectToRowSetConverter();

    public RowSetHtmlFormatter(String cssClassName) {
        this(cssClassName, null);
    }

    public RowSetHtmlFormatter(String cssClassName, String cssRowClassName) {
        this.cssClassName = cssClassName;
        this.cssRowClassName = cssRowClassName;
    }

    public void setObjectToRowSetConverter(ObjectToRowSetConverter objectToRowSetConverter) {
        this.objectToRowSetConverter = objectToRowSetConverter;
    }

    public String formatHorizontal(RowSet rowSet) {
        return this.formatHorizontal(rowSet, new StringBuilder()).toString();
    }

    public Appendable formatHorizontal(RowSet rowSet, Appendable builder) {
        return this.formatHorizontal(rowSet, true, builder);
    }

    public String formatHorizontal(RowSet rowSet, boolean withColumnNames) {
        return this.formatHorizontal(rowSet, withColumnNames, new StringBuilder()).toString();
    }

    public Appendable formatHorizontal(RowSet rowSet, boolean withColumnNames, Appendable builder) {
        return this.format(rowSet, withColumnNames, false, builder, null);
    }

    public String formatVertical(RowSet rowSet) {
        return this.formatVertical(rowSet, new StringBuilder()).toString();
    }

    public Appendable formatVertical(RowSet rowSet, Appendable builder) {
        return this.format(rowSet, false, true, builder, null);
    }

    public Appendable format(RowSet rowSet, boolean withColumnNames, boolean isVertical, Appendable builder, List<String> ignorableColumns) {
        try {
            HtmlTokenFormatter htmlFormatter = new HtmlTokenFormatter();
            if (this.cssClassName != null) {
                builder.append("<table class=\"").append(this.cssClassName).append("\">\n");
            } else {
                builder.append("<table border=\"1\" cellpadding=\"3\">\n");
            }
            if (withColumnNames) {
                builder.append("<tr>\n");
                for (String columnName : rowSet.getMeta().getColumnNames()) {
                    if (ignorableColumns != null && ignorableColumns.contains(columnName)) continue;
                    builder.append("<th>").append(columnName).append("</th>\n");
                }
                builder.append("</tr>\n");
            }
            ExtendedRowMetaData extendedRowMetaData = null;
            if (rowSet.getMeta() instanceof ExtendedRowMetaData) {
                extendedRowMetaData = (ExtendedRowMetaData)rowSet.getMeta();
            }
            for (int rowIndex = 1; rowIndex <= rowSet.getRowCount(); ++rowIndex) {
                if (this.cssRowClassName != null && rowIndex % 2 == 0) {
                    builder.append("<tr class=\"").append(this.cssRowClassName).append("\">\n");
                } else {
                    builder.append("<tr>\n");
                }
                Row row = rowSet.getRowAt(rowIndex);
                int processedColumnIndex = 0;
                for (int columnIndex = 1; columnIndex <= row.getColumnCount(); ++columnIndex) {
                    if (ignorableColumns != null && ignorableColumns.contains(rowSet.getMeta().getColumnName(columnIndex))) continue;
                    String columnTag = "td";
                    if (++processedColumnIndex == 1 && isVertical && !withColumnNames && row.getColumnCount() - columnIndex >= 1) {
                        columnTag = "th";
                    }
                    Object value = row.getColumn(columnIndex);
                    ColumnDescriptor descriptor = rowSet.getMeta().getColumnDescriptor(columnIndex);
                    value = DSRowSetResponse.convertRowSetValue(value, descriptor, FormatAndMimeTypes.HTML);
                    boolean convertObjectToRowSet = false;
                    if (value != null) {
                        if (descriptor.getType() == SQLType.URL) {
                            URL url = (URL)value;
                            value = new LinkToken(url.getLink(), url.getName() != null ? url.getName() : row.getMeta().getColumnName(columnIndex));
                        } else if (value instanceof Object[] || value instanceof Collection) {
                            Object[] array;
                            if (value instanceof List) {
                                value = ((Collection)value).toArray();
                            }
                            if ((array = (Object[])value).length == 0) {
                                value = "[]";
                            } else {
                                convertObjectToRowSet = true;
                            }
                        } else if (!(value instanceof Token || JacksonUtils.isPrimitive(value.getClass()) || JacksonUtils.isEnum(value.getClass()))) {
                            if (descriptor.getType() == SQLType.EVENT || descriptor.getType() == SQLType.OTHER || descriptor.getType() == SQLType.FACETS || descriptor.getType() == SQLType.ASPECTS) {
                                convertObjectToRowSet = true;
                            } else if (value instanceof Blob || value instanceof Clob || value instanceof EventDatagram) {
                                value = ((RowSetFactory)new RowSetFactory().setWithBlobs(false)).convertValue(value, descriptor, false);
                            }
                        }
                    }
                    if (convertObjectToRowSet) {
                        RowSet valueRowSet = this.objectToRowSetConverter.convertObjectToRowSet(value);
                        if (valueRowSet != null) {
                            value = new HtmlCodeToken(this.formatRowSetToExpandableRow(valueRowSet));
                        } else {
                            convertObjectToRowSet = false;
                        }
                    }
                    if (extendedRowMetaData != null) {
                        builder.append("<" + columnTag + " align=\"").append(extendedRowMetaData.getColumnAlign(extendedRowMetaData.getColumnName(columnIndex)).toString().toLowerCase()).append("\"").append(" valign=\"").append(extendedRowMetaData.getColumnVAlign(extendedRowMetaData.getColumnName(columnIndex)).toString().toLowerCase()).append("\">");
                    } else if (convertObjectToRowSet) {
                        builder.append("<" + columnTag + " class=\"expandable\">");
                    } else {
                        String align = "left";
                        if (!this.objectToRowSetConverter.isVertical() && value != null && this.isNumberOrBoolean(value.getClass())) {
                            align = "right";
                        }
                        builder.append("<" + columnTag + " align=\"" + align + "\">");
                    }
                    String svalue = value != null && value instanceof Token ? ((Token)value).format(htmlFormatter) : htmlFormatter.format(value);
                    builder.append(svalue).append("</" + columnTag + ">\n");
                }
                builder.append("</tr>\n");
            }
            builder.append("</table>");
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
        return builder;
    }

    public Appendable formatRowSetToExpandableTable(RowSet rowSet, Appendable builder) throws IOException {
        builder.append("<table class=\"" + this.cssClassName + "\">\n");
        builder.append("<tr><td class=\"expandable\">");
        this.formatRowSetToExpandableRow(rowSet, true, builder);
        builder.append("</td></tr></table>");
        return builder;
    }

    public String formatRowSetToExpandableRow(RowSet rowSet) throws IOException {
        return this.formatRowSetToExpandableRow(rowSet, false, new StringBuilder()).toString();
    }

    public Appendable formatRowSetToExpandableRow(RowSet rowSet, boolean expanded, Appendable builder) throws IOException {
        String typeName = null;
        try {
            rowSet.next();
            typeName = rowSet.getString("@type");
            try {
                rowSet.beforeFirst();
            }
            catch (SQLException exception1) {
                Trace.logException(this, exception1, true);
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, true);
        }
        if (rowSet.getMeta().getColumnCount() == 0) {
            builder.append("{}");
            return builder;
        }
        try {
            if (rowSet.getRowCount() == 1 && rowSet.getMeta().getColumnCount() == 1 && "@type".equals(rowSet.getMeta().getColumnName(1)) && rowSet.next() && "map".equals(typeName)) {
                builder.append("{}");
                return builder;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String label = "expandablelabel" + expandableLabelIndex.incrementAndGet();
        builder.append("<input type=\"checkbox\" id=\"" + label + "\" " + (expanded ? "checked" : "") + ">");
        builder.append("<label for=\"" + label + "\">" + typeName + "</label>");
        boolean withColumnNames = !this.objectToRowSetConverter.isVertical();
        boolean isVertical = this.objectToRowSetConverter.isVertical();
        this.format(rowSet, withColumnNames, isVertical, builder, Arrays.asList("@type"));
        return builder;
    }

    private boolean isNumberOrBoolean(Class<?> clazz) {
        return (clazz = TypeFactory.unwrapBoxer(clazz)) == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE || clazz == Byte.TYPE || clazz == Boolean.TYPE || clazz == BigInteger.class || clazz == BigDecimal.class;
    }

    private boolean isStringOrPrimitive(Class<?> clazz) {
        return clazz == String.class || Date.class.isAssignableFrom(clazz);
    }
}

