/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.ServiceHtml;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.util.List;

public class RemoteServicesHtmlTable
extends AbstractHtmlTable {
    private static String COLUMN_SERVICE_FULL_NAME = "Service Name";
    private static String COLUMN_NODE_NAME = "Node Name";

    public RemoteServicesHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_SERVICE_FULL_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_NODE_NAME, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Remote Services";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        Moderator moderator = RuntimeContext.getInstance().getModerator();
        for (ComponentReference component : moderator.getComponents(EventScope.GLOBAL)) {
            try {
                if (component.getModel() != ComponentModel.SERVICE || component.getName().startsWith(RuntimeContext.getInstance().getName())) continue;
                List<String> nameTokens = ModeratorUtils.splitComponentFullName(component.getName());
                String serviceName = nameTokens.get(1) + "." + nameTokens.get(2);
                Row row = this.table.newRow();
                row.setColumn(COLUMN_SERVICE_FULL_NAME, (Object)new RemoteServiceImageLink(nameTokens.get(0), serviceName));
                row.setColumn(COLUMN_NODE_NAME, (Object)nameTokens.get(0));
                this.table.addToRowSet(row);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
            }
        }
    }

    public static class RemoteServiceImageLink
    extends ComplexToken {
        public RemoteServiceImageLink(String nodeName, String serviceName) {
            this(nodeName, serviceName, serviceName);
        }

        public RemoteServiceImageLink(String nodeName, String serviceName, String serviceDisplayName) {
            this.append(ServiceHtml.SERVICE_IMAGE).append(new RemoteServiceLink(nodeName, serviceName, serviceDisplayName));
        }
    }

    public static class RemoteServiceHtml
    extends AbstractHtmlPage {
        private HTTPAcceptorConfiguration serverConfig;
        private String nodeName;
        private String serviceName;
        private HTTPServerFabricConnection connection;

        @Override
        public String getTitle() {
            return "Service: " + this.nodeName + "://" + this.serviceName;
        }

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            this.serverConfig = (HTTPAcceptorConfiguration)url.getRequest().getServletContext().getAttribute(HTTPAcceptorConfiguration.ATTRIBUTE);
            this.nodeName = url.getUriParameterOrThrowException("nodeName");
            this.serviceName = url.getUriParameterOrThrowException("serviceName");
            this.connection = connection;
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            if (this.connection == null) {
                builder.append(SorServletCss.bold("<br>Failed to get remote service information, server fabric connection doesn't exist.<br>"));
                return builder.toString();
            }
            try {
                String serviceFullName = this.nodeName + "://" + this.serviceName;
                ServiceAccessor accessor = this.connection.getOrCreateServiceAccessor(serviceFullName, serviceFullName + "_ServiceAccessorForHtml");
                PropertiesHtmlTable properties = new PropertiesHtmlTable();
                properties.addIfNotNull("Node Name", this.nodeName);
                properties.addIfNotNull("Service Event Scope", "global");
                properties.addIfNotNull("Available", accessor.isAvailable());
                builder.append(properties.getHtml());
                String[] s = this.serviceName.split("\\.");
                builder.append(ServiceHtml.makeServiceCallHtml(this.serverConfig, s[0], s[1], accessor.getEventHandlers(), this.nodeName));
            }
            catch (Exception exception) {
                builder.append(SorServletCss.bold("<br>Failed to get remote service information, cause: " + exception.toString() + ".<br>"));
                Trace.logException(this, exception, false);
            }
            return builder.toString();
        }
    }

    public static class RemoteServiceLink
    extends LinkToken {
        public RemoteServiceLink(String nodeName, String serviceName) {
            this(nodeName, serviceName, serviceName);
        }

        public RemoteServiceLink(String nodeName, String serviceName, String serviceDisplayName) {
            super(SorUriRegistry.registry().formatFullUri(RemoteServiceHtml.class, nodeName, serviceName), serviceDisplayName);
        }
    }
}

