/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.RowSetHtmlFormatter;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import java.sql.SQLException;

public class PropertiesHtmlTable {
    private RowSet rowSet;

    public PropertiesHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn("Property", ExtendedRowMetaData.Align.LEFT, ExtendedRowMetaData.VAlign.TOP);
        meta.addColumn("Value", ExtendedRowMetaData.Align.LEFT);
        this.rowSet = new RowSet(meta);
    }

    public RowSet getRowSet() {
        return this.rowSet;
    }

    public void initFrom(RowSet fromRowSet) {
        try {
            while (fromRowSet.next()) {
                this.rowSet.addToRowSet(fromRowSet.getCurrentRow());
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    public String getHtml() {
        return new RowSetHtmlFormatter(SorServletCss.TABLE_PROPERTIES_STYLE).formatVertical(this.rowSet);
    }

    public void addIfNotNull(String name, Object value) {
        if (value != null) {
            try {
                if (value instanceof Boolean) {
                    value = value.toString().toLowerCase();
                }
                this.rowSet.addToRowSet(new Object[]{name + (name.length() > 0 ? ":" : ""), value});
            }
            catch (SQLException exception) {
                Trace.logException(this, exception, false);
            }
        }
    }
}

