/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.fasterxml.jackson.databind.module.SimpleModule;
import com.streamscape.Trace;
import com.streamscape.omf.json.JSONSerializerException;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JacksonUtils;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.json.jackson.MapJsonGenerator;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectToRowSetConverter {
    private boolean vertical = false;
    private boolean mapsVertical = true;

    public boolean isVertical() {
        return this.vertical;
    }

    public ObjectToRowSetConverter setVertical(boolean vertical) {
        this.vertical = vertical;
        return this;
    }

    public boolean isMapsVertical() {
        return this.mapsVertical;
    }

    public ObjectToRowSetConverter setMapsVertical(boolean mapsVertical) {
        this.mapsVertical = mapsVertical;
        return this;
    }

    public RowSet convertObjectToRowSet(Object value) {
        if (value == null) {
            return null;
        }
        ArrayList map = null;
        if (value instanceof Object[] && ((Object[])value).length > 0) {
            map = new ArrayList();
            for (Object v : (Object[])value) {
                ((List)map).add(this.convertObjectToMap(v));
            }
        } else {
            map = this.convertObjectToMap(value);
        }
        RowSet rowSet = null;
        if (map != null) {
            if (map instanceof Map) {
                rowSet = this.convertMapToRowSet((Map)((Object)map));
            } else if (map instanceof List) {
                rowSet = this.convertArrayToRowSet(map);
            }
        }
        return rowSet;
    }

    private Object convertObjectToMap(Object value) {
        if (!(value instanceof LinkedHashMapMarked) && !(value instanceof ArrayListMarked)) {
            JSONSerializer serializer = RuntimeContext.getInstance().getJSONSerializerFactory().createSerializerDefaultBuilderLazy("JsonSerializerForComplexObjectInRowSetHtmlResponse").apply(c -> {
                c.setJsonNotation(JsonNotation.TYPE);
                c.setJsonNotationLevel(JsonNotationLevel.COMPLEX_OBJECTS, JsonNotationLevel.ROOT_ELEMENT, JsonNotationLevel.POLYMORPHIC_MAPS_AND_COLLECTIONS);
                SimpleModule module = new SimpleModule();
                module.addSerializer(java.util.Date.class, new JacksonUtils.ToStringSerializer<java.util.Date>(java.util.Date.class));
                module.addSerializer(Time.class, new JacksonUtils.ToStringSerializer<Time>(Time.class));
                module.addSerializer(Date.class, new JacksonUtils.ToStringSerializer<Date>(Date.class));
                module.addSerializer(Timestamp.class, new JacksonUtils.ToStringSerializer<Timestamp>(Timestamp.class));
                c.addModule(module);
            }).getOrBuild();
            MapJsonGenerator generator = new MapJsonGenerator(() -> new LinkedHashMapMarked(), () -> new ArrayListMarked());
            try {
                serializer.serialize(value, generator);
                return generator.getDocument();
            }
            catch (JSONSerializerException | IOException exception) {
                Trace.logError(this, "Failed to serializer object from row set.");
                Trace.logException(this, exception, false);
            }
        }
        return value;
    }

    private RowSet convertMapToRowSet(Map map) {
        boolean isMap;
        Object typeName = map.get("@type");
        boolean bl = isMap = typeName != null && typeName.equals("map");
        if (this.isVertical() || isMap && this.isMapsVertical()) {
            if (isMap && map.size() == 1) {
                return new RowSet(new RowMetaData());
            }
            RowMetaData meta = new RowMetaData();
            if (typeName != null) {
                meta.addColumn("@type", String.class);
            }
            meta.addColumn("key", Object.class);
            meta.addColumn("value", Object.class);
            RowSet rowSet = new RowSet(meta);
            map.entrySet().forEach(e -> {
                try {
                    Object key = ((Map.Entry)e).getKey();
                    Object value = ((Map.Entry)e).getValue();
                    if (typeName != null && !"@type".equals(key)) {
                        rowSet.addToRowSet(new Object[]{typeName, key, value});
                    } else {
                        rowSet.addToRowSet(new Object[]{key, value});
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            });
            return rowSet;
        }
        RowMetaData meta = new RowMetaData();
        ArrayList values = new ArrayList();
        map.entrySet().forEach(e -> {
            Object value = ((Map.Entry)e).getValue();
            Class valueClass = String.class;
            if (value != null) {
                valueClass = value.getClass();
            }
            meta.addColumn((String)((Map.Entry)e).getKey(), valueClass);
            values.add(value);
        });
        RowSet rowSet = new RowSet(meta);
        try {
            rowSet.addToRowSet(values.toArray());
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, true);
        }
        return rowSet;
    }

    private RowSet convertArrayToRowSet(List list) {
        RowMetaData meta = new RowMetaData();
        meta.addColumn("@type", String.class);
        meta.addColumn("value", Object.class);
        RowSet rowSet = new RowSet(meta);
        try {
            for (Object o : list) {
                rowSet.addToRowSet(new Object[]{"list", o});
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, true);
        }
        return rowSet;
    }

    public static class LinkedHashMapMarked<K, V>
    extends LinkedHashMap<K, V> {
    }

    public static class ArrayListMarked<E>
    extends ArrayList<E> {
    }
}

