/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.omf.mapper.MappingObject;
import com.streamscape.omf.mapper.MappingRule;
import com.streamscape.omf.mapper.SemanticMap;
import com.streamscape.omf.mapper.SemanticMapRepositoryUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.EventPrototypesHtmlTable;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.RowSetHtmlFormatter;
import com.streamscape.sef.network.http.server.html.SemanticTypeHtml;
import com.streamscape.sef.network.http.server.html.SemanticTypeLink;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MappersHtmlTable
extends AbstractHtmlTable {
    public static String COLUMN_MAPPER_NAME = "Name";
    public static String COLUMN_SOURCE_OBJECTS = "Source Objects";
    public static String COLUMN_TARGET_OBJECT = "Target Object";
    public static String COLUMN_VALIDATE_SOURCE = "Validate Source ";
    public static String COLUMN_VALIDATE_TARGET = "Validate Target";
    public static String COLUMN_DEFAULT_DATASPACE = "Default Dataspace";

    public MappersHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_MAPPER_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_SOURCE_OBJECTS, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_TARGET_OBJECT, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_VALIDATE_SOURCE, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_VALIDATE_TARGET, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_DEFAULT_DATASPACE, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Semantic Mappers";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        try {
            for (String mapperName : SemanticMapRepositoryUtils.listSemanticMaps()) {
                try {
                    SemanticMap mapper = SemanticMapRepositoryUtils.lookupSemanticMap(mapperName);
                    if (mapper == null) {
                        Trace.logError(this, "Failed to get semantic mapper '" + mapperName + "' from .tfcache.");
                        continue;
                    }
                    ArrayList<String> sourceObjects = new ArrayList<String>();
                    for (MappingObject obj : mapper.getSources()) {
                        sourceObjects.add(obj.getSemanticType());
                    }
                    Row row = this.table.newRow();
                    row.setColumn(COLUMN_MAPPER_NAME, (Object)new MapperLink(mapperName, mapperName));
                    row.setColumn(COLUMN_SOURCE_OBJECTS, (Object)SemanticTypeHtml.makeSemanticTypeLinksList(sourceObjects));
                    row.setColumn(COLUMN_TARGET_OBJECT, mapper.getTarget() != null ? new SemanticTypeLink(mapper.getTarget().getSemanticType()) : "");
                    row.setColumn(COLUMN_VALIDATE_SOURCE, (Object)mapper.canValidateSource());
                    row.setColumn(COLUMN_VALIDATE_TARGET, (Object)mapper.canValidateTarget());
                    row.setColumn(COLUMN_DEFAULT_DATASPACE, (Object)mapper.getDefaultDataspace());
                    this.table.addToRowSet(row);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    public static class MapperLink
    extends LinkToken {
        public MapperLink(String mapperName, String displayName) {
            super(SorUriRegistry.registry().formatFullUri(MapperHtml.class, mapperName), displayName);
        }
    }

    public static class MapperHtml
    extends AbstractHtmlPage {
        private static Pattern SEMANTIC_TYPE_PATTERN = Pattern.compile("%(\\w*):");
        private String mapperName;
        private SemanticMap mapper;

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            this.mapperName = url.getUriParameterOrThrowException("mapperName");
            this.mapper = SemanticMapRepositoryUtils.lookupSemanticMap(this.mapperName);
            if (this.mapper == null) {
                Trace.logError(this, "Failed to get semantic mapper '" + this.mapperName + "' from .tfcache.");
                throw new Exception("Semantic mapper '" + this.mapperName + "' doesn't exist.");
            }
        }

        @Override
        public String getTitle() {
            return "Semantic Mapper: " + this.mapperName;
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            List sourceObjects = this.mapper.getSources().stream().map(s -> s.getSemanticType()).collect(Collectors.toList());
            PropertiesHtmlTable properties = new PropertiesHtmlTable();
            properties.addIfNotNull(COLUMN_VALIDATE_SOURCE, this.mapper.canValidateSource());
            properties.addIfNotNull(COLUMN_VALIDATE_TARGET, this.mapper.canValidateTarget());
            properties.addIfNotNull(COLUMN_DEFAULT_DATASPACE, this.mapper.getDefaultDataspace());
            builder.append(properties.getHtml());
            this.buildMappingObjectsTable(builder, "Source Mapping Objects", this.mapper.getSources());
            this.buildMappingObjectsTable(builder, "Target Mapping Object", Arrays.asList(this.mapper.getTarget()));
            this.buildMappingRulesTable(builder);
            return builder.toString();
        }

        private void buildMappingRulesTable(StringBuilder builder) {
            builder.append("<div class=\"" + SorServletCss.DEFAULT_DIV_STYLE + "\">\n");
            builder.append(SorServletCss.bold("Semantic Mapper Rules")).append("<br><br>");
            ExtendedRowMetaData meta = new ExtendedRowMetaData();
            meta.addColumn("Rule", ExtendedRowMetaData.Align.LEFT);
            meta.addColumn("Comment", ExtendedRowMetaData.Align.LEFT);
            RowSet rowSet = new RowSet(meta);
            for (MappingRule mappingRule : this.mapper.getMappingRules()) {
                try {
                    Row row = rowSet.newRow();
                    row.setColumn("Rule", (Object)this.replaceSemanticTypesWithLinkInRule(mappingRule.getRule().trim()));
                    row.setColumn("Comment", (Object)mappingRule.getComment());
                    rowSet.addToRowSet(row);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                }
            }
            builder.append(new RowSetHtmlFormatter(SorServletCss.TABLE_SEMANTIC_MAPPER_RULES_STYLE, SorServletCss.TABLE_SEMANTIC_MAPPER_RULES_STYLE_ALT).formatHorizontal(rowSet));
            builder.append("</div>\n");
        }

        private void buildMappingObjectsTable(StringBuilder builder, String name, List<MappingObject> objects) {
            builder.append("<div class=\"" + SorServletCss.DEFAULT_DIV_STYLE + "\">\n");
            builder.append(SorServletCss.bold(name)).append("<br><br>");
            ExtendedRowMetaData meta = new ExtendedRowMetaData();
            meta.addColumn("Semantic Type", ExtendedRowMetaData.Align.LEFT);
            meta.addColumn("Alias", ExtendedRowMetaData.Align.LEFT);
            meta.addColumn("Event Id", ExtendedRowMetaData.Align.LEFT);
            RowSet rowSet = new RowSet(meta);
            if (objects != null) {
                for (MappingObject object : objects) {
                    if (object == null) continue;
                    try {
                        Row row = rowSet.newRow();
                        row.setColumn("Semantic Type", (Object)new SemanticTypeHtml.SemanticTypeImageLink(object.getSemanticType()));
                        row.setColumn("Alias", (Object)(object.getAlias() != null ? object.getAlias() : ""));
                        row.setColumn("Event Id", object.getEventId() != null ? new EventPrototypesHtmlTable.EventImageLink(object.getEventId()) : "");
                        rowSet.addToRowSet(row);
                    }
                    catch (Exception exception) {
                        Trace.logException(this, exception, false);
                    }
                }
            }
            builder.append(new RowSetHtmlFormatter(SorServletCss.TABLE_SEMANTIC_MAPPER_RULES_STYLE, SorServletCss.TABLE_SEMANTIC_MAPPER_RULES_STYLE_ALT).formatHorizontal(rowSet));
            builder.append("</div>\n");
        }

        private ComplexToken replaceSemanticTypesWithLinkInRule(String rule) {
            ComplexToken token = new ComplexToken();
            Matcher matcher = SEMANTIC_TYPE_PATTERN.matcher(rule);
            if (matcher.find()) {
                StringBuffer builder;
                do {
                    builder = new StringBuffer();
                    matcher.appendReplacement(builder, "");
                    token.append(builder.toString()).append("%").append(new SemanticTypeLink(matcher.group(1))).append(":");
                } while (matcher.find());
                builder = new StringBuffer();
                matcher.appendTail(builder);
                token.append(builder.toString());
            } else {
                token.append(rule);
            }
            return token;
        }
    }
}

