/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.sef.network.http.server.authentication.XSessionAuthenticator;
import com.streamscape.sef.network.http.server.html.AbstractToken;
import com.streamscape.sef.network.http.server.html.TokenFormatter;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;

public class LinkToken
extends AbstractToken {
    private String linkTo;
    private Object text;
    private String download;
    private String onClick;

    public LinkToken() {
    }

    public LinkToken(String linkTo) {
        this(linkTo, linkTo);
    }

    public LinkToken(String linkTo, Object text) {
        this.linkTo = linkTo;
        this.text = text;
        this.appendXSessionToken();
    }

    private void appendXSessionToken() {
        String tokenId;
        FabricHTTPRequest url;
        if (this.linkTo != null && (this.linkTo.startsWith("/ds") || this.linkTo.startsWith("/odata/v4") || this.linkTo.startsWith("/service")) && (url = FabricHTTPRequest.getThreadLocal()) != null && (tokenId = XSessionAuthenticator.getTokenIfAuthenticated(url.getRequest())) != null) {
            this.linkTo = this.linkTo.indexOf("?") != -1 ? this.linkTo + "&" : this.linkTo + "?";
            this.linkTo = this.linkTo + "x-session-token=" + tokenId;
        }
    }

    public String getLinkTo() {
        return this.linkTo;
    }

    public void setLinkTo(String linkTo) {
        this.linkTo = linkTo;
    }

    public Object getText() {
        return this.text;
    }

    public void setText(Object text) {
        this.text = text;
    }

    public String getDownload() {
        return this.download;
    }

    public void setDownload(String download) {
        this.download = download;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    @Override
    public String format(TokenFormatter formatter) {
        return formatter.format(this);
    }
}

