/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.sef.network.http.server.html.ButtonToken;
import com.streamscape.sef.network.http.server.html.HtmlCodeToken;
import com.streamscape.sef.network.http.server.html.ImageToken;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.SpanToken;
import com.streamscape.sef.network.http.server.html.TextToken;
import com.streamscape.sef.network.http.server.html.Token;
import com.streamscape.sef.network.http.server.html.TokenFormatter;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;

public class HtmlTokenFormatter
implements TokenFormatter {
    @Override
    public String format(Object value) {
        if (value != null) {
            if (value instanceof TextToken) {
                return HTTPUtils.htmlEncode(((TextToken)value).getText().toString(), true);
            }
            if (value instanceof HtmlCodeToken) {
                return ((HtmlCodeToken)value).getHtmlCode();
            }
            if (value instanceof ImageToken) {
                return "<img " + HtmlTokenFormatter.getStyleClassesAndId((Token)value) + " src=\"" + ((ImageToken)value).getLink() + "\"/> ";
            }
            if (value instanceof Token) {
                return ((Token)value).format(this);
            }
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    return "x";
                }
                return "";
            }
            return HTTPUtils.htmlEncode(value.toString(), true);
        }
        return "null";
    }

    @Override
    public String format(LinkToken value) {
        return "<a " + HtmlTokenFormatter.getStyleClassesAndId(value) + (String)(value.getDownload() != null ? " download=\"" + value.getDownload() + "\"" : "") + (String)(value.getOnClick() != null ? " onclick=\"" + value.getOnClick().replaceAll("\"", "\"\"") + "\"" : "") + " href=\"" + value.getLinkTo() + "\">" + this.format(value.getText()) + "</a>";
    }

    @Override
    public String format(SpanToken value) {
        return "<span " + HtmlTokenFormatter.getStyleClassesAndId(value) + ">" + value.getToken().format(this) + "</span>";
    }

    @Override
    public String format(ButtonToken value) {
        return "<input type=\"submit\" " + HtmlTokenFormatter.getStyleClassesAndId(value) + "  value=\"" + value.getValue() + "\" onclick=\"location.href='" + value.getHref() + "'\"/>";
    }

    public static String getStyleClassesAndId(Token token) {
        StringBuilder builder = null;
        if (token.getStyles() != null && token.getStyles().size() > 0) {
            builder = new StringBuilder();
            builder.append("class=\"");
            for (String style : token.getStyles()) {
                builder.append(style).append(" ");
            }
            builder.append("\"");
        }
        if (token.getId() != null) {
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(" id=\"").append(token.getId()).append("\"");
        }
        if (token.getTitle() != null) {
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(" title=\"").append(token.getTitle()).append("\"");
        }
        if (builder != null) {
            return builder.toString();
        }
        return "";
    }
}

