/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.Token;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.Map;

public class HTTPRequestHtmlBuilder {
    public Token buildToken(HTTPRequest request) {
        if (request.getMethod().equalsIgnoreCase("get")) {
            Object uri = request.getUri();
            Object encodedUri = request.getUri();
            Pair<String, String> query = this.buildQueryParameters(request);
            if (((String)query.first).length() > 0) {
                uri = (String)uri + "?" + (String)query.first;
                encodedUri = (String)encodedUri + "?" + (String)query.second;
            }
            ComplexToken token = new ComplexToken();
            token.addStyle(SorServletCss.DEFAULT_DIV_STYLE);
            token.append(new LinkToken((String)encodedUri, uri));
            token.append(this.buildHeaders(request));
            return token;
        }
        String uri = request.getUri();
        String data = request.getDataString();
        if (data == null) {
            data = (String)this.buildQueryParameters((HTTPRequest)request).first;
        }
        ComplexToken token = new ComplexToken();
        token.addStyle(SorServletCss.DEFAULT_DIV_STYLE);
        token.append(new LinkToken(uri, uri));
        if (data != null && data.length() > 0) {
            token.append("\nContent: " + data);
        }
        token.append(this.buildHeaders(request));
        return token;
    }

    public Pair<String, String> buildQueryParameters(HTTPRequest request) {
        Object query = "";
        Object encodedQuery = "";
        if (request.getQueryParameters() != null && request.getQueryParameters().size() > 0) {
            for (Map.Entry<String, String> entry : request.getQueryParameters().entrySet()) {
                if (((String)query).length() > 0) {
                    query = (String)query + "&";
                    encodedQuery = (String)encodedQuery + "&";
                }
                query = (String)query + entry.getKey() + "=" + entry.getValue();
                encodedQuery = (String)encodedQuery + entry.getKey() + "=" + HTTPUtils.encodeString(entry.getValue());
            }
        }
        return new Pair<String, String>((String)query, (String)encodedQuery);
    }

    public String buildHeaders(HTTPRequest request) {
        Object headers = "";
        if (request.getHeaders() != null && request.getHeaders().size() > 0) {
            headers = "\nHeaders: " + String.valueOf(request.getHeaders());
        }
        return headers;
    }
}

