/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.event.ListEventsOperation;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.EventPreviewPage;
import com.streamscape.sef.network.http.server.html.EventPrototypeHtml;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.ServiceHtml;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletException;

public class EventPrototypesHtmlTable
extends AbstractHtmlTable {
    private static String COLUMN_EVENT_ID = "EventId";
    private static String COLUMN_PRODUCERS = "Producers";
    private static String COLUMN_CONSUMERS = "Consumers";
    private static String COLUMN_SYSTEM = "System";
    private boolean includeSystemEvents = false;
    private FilterMode filterMode = FilterMode.CONTAINS;
    private String filterTemplate = "";

    public EventPrototypesHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_EVENT_ID, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_PRODUCERS, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_CONSUMERS, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_SYSTEM, ExtendedRowMetaData.Align.CENTER);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Event Prototypes";
    }

    @Override
    public void init(RuntimeContext context, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        this.includeSystemEvents = url.getParameter("includeSystemEvents") != null && (url.getParameter("includeSystemEvents").length() == 0 || url.getParameter("includeSystemEvents").equalsIgnoreCase("on") || url.getParameter("includeSystemEvents").equalsIgnoreCase("true"));
        this.filterTemplate = url.getParameter("filterTemplate");
        this.filterMode = FilterMode.CONTAINS;
        if (url.getParameter("filterMode") != null) {
            if (url.getParameter("filterMode").equalsIgnoreCase(FilterMode.EVENT_FILTER.toString())) {
                this.filterMode = FilterMode.EVENT_FILTER;
            } else if (url.getParameter("filterMode").equalsIgnoreCase(FilterMode.REGEXP.toString())) {
                this.filterMode = FilterMode.REGEXP;
            }
        }
        List<ComponentReference> components = context.getModerator().getComponents(EventScope.INHERITED);
        List<EventConsumerReference> consumers = context.getModerator().getEventConsumers(EventScope.INHERITED);
        DatagramPrototypeCache cache = context.getDatagramPrototypeCache();
        for (String eventId : this.listEvents(cache)) {
            Prototype prototype;
            if (ListEventsOperation.isReservedEvent(eventId) || !this.includeSystemEvents && ListEventsOperation.isSystemEvent(eventId) || (prototype = cache.lookupPrototype(eventId)) == null) continue;
            try {
                Row row = this.table.newRow();
                row.setColumn(COLUMN_EVENT_ID, (Object)new EventImageLink(eventId));
                row.setColumn(COLUMN_PRODUCERS, (Object)this.hasProducer(eventId, components));
                row.setColumn(COLUMN_CONSUMERS, (Object)this.hasConsumer(eventId, consumers));
                row.setColumn(COLUMN_SYSTEM, (Object)ListEventsOperation.isSystemEvent(eventId));
                this.table.addToRowSet(row);
            }
            catch (RowException exception) {
                Trace.logException(this, exception, false);
            }
            catch (SQLException exception) {
                Trace.logException(this, exception, false);
            }
        }
    }

    private List<String> listEvents(DatagramPrototypeCache cache) throws ServletException {
        if (this.filterTemplate != null && this.filterTemplate.length() > 0) {
            if (this.filterMode == FilterMode.EVENT_FILTER) {
                try {
                    return cache.listEventIdsByFilter(new Filter(this.filterTemplate));
                }
                catch (FilterFormatException exception) {
                    throw new ServletException("Wrong event filter specified: " + this.filterTemplate + "." + exception.getMessage());
                }
            }
            Pattern filterPattern = null;
            Object regexpTemplate = this.filterTemplate;
            if (this.filterMode == FilterMode.CONTAINS) {
                regexpTemplate = ".*" + Pattern.quote((String)regexpTemplate) + ".*";
            }
            try {
                filterPattern = Pattern.compile((String)regexpTemplate);
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to compile regexp '" + (String)regexpTemplate + "'. Cause: " + exception.getMessage());
            }
            ArrayList<String> result = new ArrayList<String>();
            for (String eventId : cache.listEventIds()) {
                if (!filterPattern.matcher(eventId).matches()) continue;
                result.add(eventId);
            }
            return result;
        }
        return cache.listEventIds();
    }

    private boolean hasProducer(String eventId, List<ComponentReference> componentReferences) {
        for (ComponentReference reference : componentReferences) {
            if (!reference.isBoundEventId(eventId)) continue;
            return true;
        }
        return false;
    }

    private boolean hasConsumer(String eventId, List<EventConsumerReference> consumerReferences) {
        for (EventConsumerReference reference : consumerReferences) {
            if (!reference.matchesEventId(eventId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getHtml() {
        StringBuilder filter = new StringBuilder();
        filter.append("<div class=\"sor-div-filter\">\n");
        filter.append("<form><table><tr>\n");
        filter.append("<td><input type=\"text\" name=\"filterTemplate\"  style=\"width:100%;\" value='" + (this.filterTemplate != null ? HTTPUtils.htmlEncode(this.filterTemplate, true) : "") + "'></td>\n");
        filter.append("<td><input type=\"submit\" class=\"sor-button-filter\" value=\"Filter\"></td></tr>\n");
        filter.append("<tr><td>\n");
        filter.append("<input type=\"radio\" name=\"filterMode\" value=\"" + FilterMode.CONTAINS.toString() + "\"" + (this.filterMode == FilterMode.CONTAINS ? " checked " : "") + ">Simple Filter\n");
        filter.append("<input type=\"radio\" name=\"filterMode\" value=\"" + FilterMode.EVENT_FILTER.toString() + "\"" + (this.filterMode == FilterMode.EVENT_FILTER ? " checked " : "") + ">Event Filter\n");
        filter.append("<input type=\"radio\" name=\"filterMode\" value=\"" + FilterMode.REGEXP.toString() + "\"" + (this.filterMode == FilterMode.REGEXP ? " checked " : "") + ">Regular Expression\n");
        filter.append("</td></tr>\n");
        filter.append("<tr><td><input type=\"checkbox\" name=\"includeSystemEvents\"" + (this.includeSystemEvents ? " checked " : "") + ">Include System Events</td></tr>\n");
        filter.append("</table></form>\n");
        filter.append("</div>\n");
        return this.getHeaderHtml() + filter.toString() + this.getTableHtml();
    }

    static enum FilterMode {
        CONTAINS,
        EVENT_FILTER,
        REGEXP;

    }

    public static class EventImageLink
    extends EventPrototypeWithSerializationLink {
        public EventImageLink(String eventId) {
            super(eventId);
            this.prepend(ServiceHtml.EVENT_IMAGE);
        }
    }

    public static class EventPrototypeWithSerializationLink
    extends ComplexToken {
        public EventPrototypeWithSerializationLink(String eventId) {
            this.append(new EventPrototypeLink(eventId)).append(" ");
            this.append(new EventSerializationLink(eventId, "xml")).append(" ");
            this.append(new EventSerializationLink(eventId, "json")).append(" ");
        }
    }

    public static class EventPrototypeLink
    extends LinkToken {
        public EventPrototypeLink(String eventId) {
            super(SorUriRegistry.registry().formatFullUri(EventPrototypeHtml.class, eventId), eventId);
        }
    }

    public static class EventSerializationLink
    extends LinkToken {
        public EventSerializationLink(String eventId, String format) {
            this(eventId, format, format);
        }

        public EventSerializationLink(String eventId, String format, Object displayName) {
            super(SorUriRegistry.registry().formatFullUri(EventPreviewPage.class, eventId) + "?responseFormat=" + format, displayName);
        }
    }
}

